# Student Selection Feature for Particular Amount

## Overview
This feature allows you to select specific students for particular amounts in the accounting system. Selected students are stored as comma-separated IDs in the `selected_students` column of the `accounting_particular_amount_v5` table.

## Database Changes
Before using this feature, you need to add the `selected_students` column to your database:

```sql
ALTER TABLE `accounting_particular_amount_v5` 
ADD COLUMN `selected_students` TEXT NULL AFTER `months`;
```

## Features

### 1. Student Filtering
- Filter students by course using the dropdown
- Search students by name, registration ID, or contact number
- Real-time search with highlighting

### 2. Student Selection
- Checkbox selection for individual students
- "Select All" checkbox to select/deselect all visible students
- Selected students are automatically saved when the form is submitted

### 3. Table Display
- Student table with 300px height and scrollable content
- Sticky header for better navigation
- Responsive design

### 4. Data Persistence
- Selected students are saved as comma-separated IDs
- When editing existing records, previously selected students are automatically checked
- Student names are displayed in the overview table

## Usage

1. **Adding/Editing Particular Amount:**
   - Fill in the basic details (year, course, branch, etc.)
   - Use the course filter to narrow down students
   - Use the search box to find specific students
   - Check the checkboxes for students you want to include
   - Click "Save" to store the selection

2. **Viewing Selected Students:**
   - The overview table shows all configured amounts
   - The "Selected Students" column displays the names of selected students
   - Click the edit button to modify selections

## Files Modified/Created

- `particular_amount.php` - Main file with student selection interface
- `load_students.php` - AJAX endpoint for loading students
- `add_selected_students_column.sql` - Database migration script

## Technical Details

- Uses AJAX to load students dynamically
- Implements real-time search with highlighting
- Stores student IDs as comma-separated values
- Maintains backward compatibility with existing records
