-- Smart School Database Backup
-- Generated: 2025-12-18 08:27:04
-- --------------------------------------------------------

-- Table structure for table `4th_grad_point_v3`
DROP TABLE IF EXISTS `4th_grad_point_v3`;
CREATE TABLE `4th_grad_point_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `points_grades` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `4th_grad_point_v3`
INSERT INTO `4th_grad_point_v3` (`id`, `name`, `points_grades`) VALUES("1","Default","[{\"point\":\"5.00\",\"grad\":\"A+\"},{\"point\":\"4.00\",\"grad\":\"A\"},{\"point\":\"3.00\",\"grad\":\"B\"},{\"point\":\"0.1\",\"grad\":\"D\"}]");


-- Table structure for table `academic_bkash_refunds`
DROP TABLE IF EXISTS `academic_bkash_refunds`;
CREATE TABLE `academic_bkash_refunds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` varchar(200) DEFAULT NULL,
  `course_id` varchar(500) DEFAULT NULL,
  `payment_id` varchar(200) DEFAULT NULL,
  `original_trx_id` varchar(200) DEFAULT NULL,
  `refund_trx_id` varchar(200) DEFAULT NULL,
  `amount` varchar(200) DEFAULT NULL,
  `status` varchar(200) DEFAULT NULL,
  `reason` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `academic_bkash_refunds`


-- Table structure for table `academic_onpay_seetings`
DROP TABLE IF EXISTS `academic_onpay_seetings`;
CREATE TABLE `academic_onpay_seetings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `SSL_domain_name` varchar(300) NOT NULL,
  `SSL_IS_SANDBOX` varchar(300) NOT NULL,
  `SSL_STORE_ID` varchar(300) NOT NULL,
  `SSL_STORE_PASSWORD` varchar(300) NOT NULL,
  `bkash_base_url` varchar(300) NOT NULL,
  `bkash_username` varchar(300) NOT NULL,
  `bkash_password` varchar(300) NOT NULL,
  `bkash_app_key` varchar(300) NOT NULL,
  `bkash_app_secret` varchar(300) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `academic_onpay_seetings`


-- Table structure for table `academic_year`
DROP TABLE IF EXISTS `academic_year`;
CREATE TABLE `academic_year` (
  `academic_year_id` int(11) NOT NULL AUTO_INCREMENT,
  `academic_year_name_bn` varchar(255) DEFAULT NULL,
  `academic_year_name_en` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`academic_year_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

-- Dumping data for table `academic_year`
INSERT INTO `academic_year` (`academic_year_id`, `academic_year_name_bn`, `academic_year_name_en`) VALUES("6","25","২৫");
INSERT INTO `academic_year` (`academic_year_id`, `academic_year_name_bn`, `academic_year_name_en`) VALUES("9","২৬","26");


-- Table structure for table `accounting_additional_fees`
DROP TABLE IF EXISTS `accounting_additional_fees`;
CREATE TABLE `accounting_additional_fees` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` varchar(50) NOT NULL,
  `description` text NOT NULL,
  `amount` varchar(10) NOT NULL,
  `payment_method` varchar(200) DEFAULT NULL,
  `transaction_id` varchar(500) DEFAULT NULL,
  `payment_date` varchar(200) DEFAULT NULL,
  `status` enum('pending','paid') DEFAULT 'pending',
  `date` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_additional_fees`


-- Table structure for table `accounting_bank_accounts`
DROP TABLE IF EXISTS `accounting_bank_accounts`;
CREATE TABLE `accounting_bank_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_name` varchar(100) NOT NULL,
  `account_name` varchar(100) NOT NULL,
  `account_number` varchar(50) NOT NULL,
  `branch_name` varchar(100) NOT NULL,
  `opening_balance` decimal(15,2) DEFAULT 0.00,
  `current_balance` decimal(15,2) DEFAULT 0.00,
  `status` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_by` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_bank_accounts`
INSERT INTO `accounting_bank_accounts` (`id`, `bank_name`, `account_name`, `account_number`, `branch_name`, `opening_balance`, `current_balance`, `status`, `created_at`, `created_by`) VALUES("1","City bank","City bank","4564","56456456",NULL,"2151.00","1","2025-05-23 03:34:49","1");
INSERT INTO `accounting_bank_accounts` (`id`, `bank_name`, `account_name`, `account_number`, `branch_name`, `opening_balance`, `current_balance`, `status`, `created_at`, `created_by`) VALUES("2","Islami Bank","Islami Bank","5164565646546","Islami Bank","0.00","0.00","1","2025-05-23 03:41:57","1");


-- Table structure for table `accounting_bank_transactions`
DROP TABLE IF EXISTS `accounting_bank_transactions`;
CREATE TABLE `accounting_bank_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_account_id` int(11) NOT NULL,
  `type` enum('deposit','withdraw','transfer') NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `description` text NOT NULL,
  `cheque_no` varchar(50) DEFAULT NULL,
  `reference` varchar(100) DEFAULT NULL,
  `transaction_date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_by` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_account_id` (`bank_account_id`),
  CONSTRAINT `accounting_bank_transactions_ibfk_1` FOREIGN KEY (`bank_account_id`) REFERENCES `accounting_bank_accounts` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_bank_transactions`


-- Table structure for table `accounting_bkash_pay`
DROP TABLE IF EXISTS `accounting_bkash_pay`;
CREATE TABLE `accounting_bkash_pay` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(200) NOT NULL,
  `payment_id` varchar(200) NOT NULL,
  `payment_month` varchar(11) DEFAULT NULL,
  `trx_id` varchar(200) NOT NULL,
  `student_id` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `course_id` varchar(200) NOT NULL,
  `amount` varchar(200) NOT NULL,
  `payment_type` varchar(200) NOT NULL,
  `description` text NOT NULL,
  `status` varchar(200) NOT NULL,
  `payment_execute_time` datetime NOT NULL,
  `payment_method` varchar(200) NOT NULL,
  `response` text NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_bkash_pay`


-- Table structure for table `accounting_cash_transactions`
DROP TABLE IF EXISTS `accounting_cash_transactions`;
CREATE TABLE `accounting_cash_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` enum('cash_in','cash_out') NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `description` text NOT NULL,
  `voucher_no` varchar(50) DEFAULT NULL,
  `reference` varchar(100) DEFAULT NULL,
  `transaction_date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_by` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_cash_transactions`


-- Table structure for table `accounting_cost_category_v5`
DROP TABLE IF EXISTS `accounting_cost_category_v5`;
CREATE TABLE `accounting_cost_category_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) NOT NULL,
  `details` text DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_cost_category_v5`
INSERT INTO `accounting_cost_category_v5` (`id`, `name`, `details`, `date`) VALUES("2","শিক্ষক বেতন","শিক্ষক বেতন","2025-10-28 07:23:23");
INSERT INTO `accounting_cost_category_v5` (`id`, `name`, `details`, `date`) VALUES("3","অফিস খরচ","অফিস খরচ","2025-10-28 07:23:39");
INSERT INTO `accounting_cost_category_v5` (`id`, `name`, `details`, `date`) VALUES("4","MB","মোবাইল  বিল","2025-10-28 07:24:13");


-- Table structure for table `accounting_cost_inc_sms_v5`
DROP TABLE IF EXISTS `accounting_cost_inc_sms_v5`;
CREATE TABLE `accounting_cost_inc_sms_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cost_sms_temp` varchar(1000) DEFAULT NULL,
  `income_sms_temp` varchar(1000) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_cost_inc_sms_v5`
INSERT INTO `accounting_cost_inc_sms_v5` (`id`, `cost_sms_temp`, `income_sms_temp`, `date`) VALUES("1","সম্মানিত গ্রাহক `cost_by_or_income_by`, আপনি `amount` টাকা খরচ করেছেন, আপনার ভাউচার নাম্বার `voucher_no` বিস্তারিত জানতে যোগাযোগ করুন ওয়েব বাজার বিডি |","সম্মানিত শুভাকাঙ্ক্ষী `cost_by_or_income_by`, আপনার অনুদান টি গ্রহণ করা হয়েছে `amount` টাকা, আপনার ভাউচার নাম্বার `voucher_no` |","2025-09-22 05:46:49");


-- Table structure for table `accounting_cost_v5`
DROP TABLE IF EXISTS `accounting_cost_v5`;
CREATE TABLE `accounting_cost_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `voucher_no` varchar(200) DEFAULT NULL,
  `amount` varchar(500) NOT NULL,
  `description` text DEFAULT NULL,
  `category_id` varchar(200) NOT NULL,
  `cost_by_name` varchar(500) DEFAULT NULL,
  `attachment` varchar(500) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `phone` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_cost_v5`


-- Table structure for table `accounting_income_category_v5`
DROP TABLE IF EXISTS `accounting_income_category_v5`;
CREATE TABLE `accounting_income_category_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) NOT NULL,
  `details` text NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_income_category_v5`
INSERT INTO `accounting_income_category_v5` (`id`, `name`, `details`, `date`) VALUES("3","বেতন","মাসিক বেতন","2025-08-29 10:52:08");
INSERT INTO `accounting_income_category_v5` (`id`, `name`, `details`, `date`) VALUES("4","পরিক্ষার ফি","পরিক্ষার ফি","2025-08-29 10:52:52");
INSERT INTO `accounting_income_category_v5` (`id`, `name`, `details`, `date`) VALUES("5","ছা্ত্র-ছাত্রী  মাসিক বেতন","ছা্ত্র-ছাত্রী  মাসিক বেতন","2025-10-28 07:24:45");
INSERT INTO `accounting_income_category_v5` (`id`, `name`, `details`, `date`) VALUES("6","পরীক্ষার ফি- ১ম সাময়িক","পরীক্ষার ফি- ১ম সাময়িক","2025-10-28 07:24:56");
INSERT INTO `accounting_income_category_v5` (`id`, `name`, `details`, `date`) VALUES("7","পরীক্ষার ফি- বার্ষিক ","পরীক্ষার ফি- বার্ষিক ","2025-10-28 07:25:07");


-- Table structure for table `accounting_income_v5`
DROP TABLE IF EXISTS `accounting_income_v5`;
CREATE TABLE `accounting_income_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `voucher_no` varchar(200) DEFAULT NULL,
  `amount` varchar(20) NOT NULL,
  `description` text NOT NULL,
  `category_id` int(11) NOT NULL,
  `income_by_name` varchar(200) NOT NULL,
  `attachment` varchar(500) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `phone` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_income_v5`


-- Table structure for table `accounting_log_v5`
DROP TABLE IF EXISTS `accounting_log_v5`;
CREATE TABLE `accounting_log_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(500) NOT NULL,
  `details` text NOT NULL,
  `user_id` int(11) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_log_v5`
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("37","Accounting Data Reset","All accounting data has been reset successfully","1","2025-08-28 02:03:20");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("38","Accounting Data Reset","All accounting data has been reset successfully","1","2025-08-28 12:54:55");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("39","Accounting Data Reset","All accounting data has been reset successfully","1","2025-08-29 02:54:25");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("40","Payment Transaction Deleted","{\"student_id\":\"7\",\"student_name\":\"MD ROBIUL HASAN\",\"amount\":\"1,500.00\",\"date\":\"2025-08-31 17:12:02\",\"payment_id\":\"11\"}","1","2025-08-31 17:16:02");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("41","Particular Deleted - Name: খরচ","one_time","1","2025-10-20 17:31:57");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("42","Particular Deleted - Name: মাসিক বেতন","one_time","1","2025-11-02 07:39:37");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("43","Particular Deleted - Name: বার্ষিক পরীক্ষা ফি","one_time","1","2025-11-02 07:39:49");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("44","Particular Deleted - Name: বার্ষিক পরীক্ষা ফি","one_time","1","2025-11-02 07:40:27");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("45","Particular Deleted - Name: বার্ষিক পরীক্ষা ফি","one_time","1","2025-11-02 07:59:38");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("46","Particular Deleted - Name: ভর্তি ফি","one_time","1","2025-11-02 07:59:49");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("47","Particular Deleted - Name: ভর্তি ফি","one_time","1","2025-11-16 17:10:01");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("48","Particular Deleted - Name: বার্ষিক পরীক্ষা ফি","one_time","1","2025-11-16 17:15:44");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("49","Particular Deleted - Name: বার্ষিক পরীক্ষা ফি","one_time","1","2025-11-16 17:16:02");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("50","Particular Deleted - Name: ভর্তি ফি","one_time","1","2025-11-16 17:20:44");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("51","Particular Deleted - Name: বার্ষিক পরীক্ষা ফি","one_time","1","2025-11-16 17:20:50");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("52","Particular Deleted - Name: ভর্তি ফি","one_time","1","2025-11-16 18:25:17");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("53","Particular Deleted - Name: বার্ষিক পরীক্ষা ফি","one_time","1","2025-11-16 18:27:21");
INSERT INTO `accounting_log_v5` (`id`, `title`, `details`, `user_id`, `date`) VALUES("54","Accounting Data Reset","All accounting data has been reset successfully","1","2025-11-18 05:39:52");


-- Table structure for table `accounting_manual_getway_v5`
DROP TABLE IF EXISTS `accounting_manual_getway_v5`;
CREATE TABLE `accounting_manual_getway_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) NOT NULL,
  `qr_code_image` varchar(500) NOT NULL,
  `number` varchar(500) NOT NULL,
  `note` text NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_manual_getway_v5`


-- Table structure for table `accounting_particular_amount_v5`
DROP TABLE IF EXISTS `accounting_particular_amount_v5`;
CREATE TABLE `accounting_particular_amount_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `particular_id` varchar(500) NOT NULL,
  `course_id` varchar(200) NOT NULL,
  `amount` int(11) NOT NULL,
  `year` varchar(200) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `old_student_amount` decimal(10,2) DEFAULT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `gender` varchar(10) DEFAULT 'All',
  `frequency` varchar(20) DEFAULT 'One Time',
  `months` varchar(50) DEFAULT NULL,
  `selected_students` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_particular_amount_lookup` (`course_id`,`branch_id`,`gender`,`particular_id`,`amount`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_particular_amount_v5`
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("1","30","1","1500","2025","2025-11-25 07:38:52","1500.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("2","30","2","1500","2025","2025-11-25 07:39:02","1500.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("3","30","3","1500","2025","2025-11-25 07:39:12","1500.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("4","30","4","1500","2025","2025-11-25 07:39:21","1500.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("5","30","5","1500","2025","2025-11-25 07:39:31","1500.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("6","30","6","1500","2025","2025-11-25 07:39:41","1500.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("7","30","7","1500","2025","2025-11-25 07:39:55","1500.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("8","30","8","1500","2025","2025-11-25 07:40:08","1500.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("9","31","1","500","2025","2025-11-25 07:41:21","500.00","1","All","Monthly","01,02,03,04,05,06,07,08,09,10,11,12",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("10","31","2","500","2025","2025-11-25 07:42:04","500.00","1","All","Monthly","01,02,03,04,05,06,07,08,09,10,11,12",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("11","31","3","500","2025","2025-11-25 07:42:33","500.00","1","All","Monthly","01,02,03,04,05,06,07,08,09,10,11,12",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("12","31","4","500","2025","2025-11-25 07:43:01","500.00","1","All","Monthly","01,02,03,04,05,06,07,08,09,10,11,12",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("13","31","5","500","2025","2025-11-25 07:43:27","500.00","1","All","Monthly","01,02,03,04,05,06,07,08,09,10,11,12",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("14","31","6","500","2025","2025-11-25 07:43:59","500.00","1","All","Monthly","01,02,03,04,05,06,07,08,09,10,11,12",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("15","31","7","500","2025","2025-11-25 07:44:22","500.00","1","All","Monthly","01,02,03,04,05,06,07,08,09,10,11,12",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("16","31","8","500","2025","2025-11-25 07:44:47","500.00","1","All","Monthly","01,02,03,04,05,06,07,08,09,10,11,12",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("17","32","1","200","2025","2025-11-25 07:45:24","200.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("18","32","2","220","2025","2025-11-25 07:45:48","220.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("19","32","3","240","2025","2025-11-25 07:46:11","240.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("20","32","4","250","2025","2025-11-25 07:46:32","250.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("21","32","5","260","2025","2025-11-25 07:47:05","260.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("22","32","6","270","2025","2025-11-25 07:47:25","270.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("23","32","7","280","2025","2025-11-25 07:47:43","280.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("24","32","8","300","2025","2025-11-25 07:48:13","300.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("25","33","1","200","2025","2025-11-25 07:50:26","200.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("26","33","2","220","2025","2025-11-25 07:50:41","220.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("27","33","3","240","2025","2025-11-25 07:51:01","240.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("28","33","4","250","2025","2025-11-25 07:51:18","250.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("29","33","5","260","2025","2025-11-25 07:51:37","260.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("30","33","6","270","2025","2025-11-25 07:51:56","270.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("31","33","7","280","2025","2025-11-25 07:52:16","280.00","1","All","One Time","",NULL);
INSERT INTO `accounting_particular_amount_v5` (`id`, `particular_id`, `course_id`, `amount`, `year`, `date`, `old_student_amount`, `branch_id`, `gender`, `frequency`, `months`, `selected_students`) VALUES("32","33","8","300","2025","2025-11-25 07:52:33","300.00","1","All","One Time","",NULL);


-- Table structure for table `accounting_particular_history_v5`
DROP TABLE IF EXISTS `accounting_particular_history_v5`;
CREATE TABLE `accounting_particular_history_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `particular_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `action` varchar(200) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_particular_history_v5`


-- Table structure for table `accounting_particular_stock_v5`
DROP TABLE IF EXISTS `accounting_particular_stock_v5`;
CREATE TABLE `accounting_particular_stock_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `particular_id` int(11) NOT NULL,
  `stock` int(11) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_particular_stock_v5`


-- Table structure for table `accounting_particular_v5`
DROP TABLE IF EXISTS `accounting_particular_v5`;
CREATE TABLE `accounting_particular_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) NOT NULL,
  `type` varchar(200) DEFAULT 'one_time',
  `pay_lastdate` date DEFAULT NULL,
  `last_date_over_amount` varchar(20) DEFAULT NULL,
  `status` varchar(200) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_particular_v5`
INSERT INTO `accounting_particular_v5` (`id`, `name`, `type`, `pay_lastdate`, `last_date_over_amount`, `status`, `date`) VALUES("30","ভর্তি ফি","one_time",NULL,NULL,NULL,"2025-08-27 08:02:27");
INSERT INTO `accounting_particular_v5` (`id`, `name`, `type`, `pay_lastdate`, `last_date_over_amount`, `status`, `date`) VALUES("31","মাসিক বেতন","one_time",NULL,NULL,NULL,"2025-08-27 08:02:41");
INSERT INTO `accounting_particular_v5` (`id`, `name`, `type`, `pay_lastdate`, `last_date_over_amount`, `status`, `date`) VALUES("32","১ম সাময়িক পরীক্ষা ফি","one_time",NULL,NULL,NULL,"2025-11-02 08:08:12");
INSERT INTO `accounting_particular_v5` (`id`, `name`, `type`, `pay_lastdate`, `last_date_over_amount`, `status`, `date`) VALUES("33","বার্ষিক পরীক্ষা ফি","one_time",NULL,NULL,NULL,"2025-10-20 17:10:39");


-- Table structure for table `accounting_payment_method_v5`
DROP TABLE IF EXISTS `accounting_payment_method_v5`;
CREATE TABLE `accounting_payment_method_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) NOT NULL,
  `details` text NOT NULL,
  `qr_code_image` varchar(1000) NOT NULL,
  `number` varchar(500) NOT NULL,
  `note` text NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_payment_method_v5`
INSERT INTO `accounting_payment_method_v5` (`id`, `name`, `details`, `qr_code_image`, `number`, `note`, `date`) VALUES("3","বিকাশ পারসোনাল","","../../images/68ad9772785dd.jpg","01727316073","প্রতিষ্ঠানের বিকাশ পারসোনাল নাম্বার সেন্ড মানি করে ট্রানজেকশন সঠিক ভাবে লিখে দিন ভুল করবেন না।","2025-08-26 11:16:02");


-- Table structure for table `accounting_payment_particular_v5`
DROP TABLE IF EXISTS `accounting_payment_particular_v5`;
CREATE TABLE `accounting_payment_particular_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_id` varchar(11) DEFAULT NULL,
  `year` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `particular_id` int(11) NOT NULL,
  `payment_month` varchar(11) DEFAULT NULL,
  `frequency` varchar(100) DEFAULT NULL,
  `amount` varchar(200) NOT NULL,
  `created_at` datetime NOT NULL,
  `sub_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_payment_particular_v5`
INSERT INTO `accounting_payment_particular_v5` (`id`, `payment_id`, `year`, `student_id`, `particular_id`, `payment_month`, `frequency`, `amount`, `created_at`, `sub_id`) VALUES("1","1","2025","202510037","30",NULL,"One Time","1500","2025-11-25 08:03:20","1");
INSERT INTO `accounting_payment_particular_v5` (`id`, `payment_id`, `year`, `student_id`, `particular_id`, `payment_month`, `frequency`, `amount`, `created_at`, `sub_id`) VALUES("2","2","2025","202510038","30",NULL,"One Time","1500","2025-11-25 08:04:16","1");
INSERT INTO `accounting_payment_particular_v5` (`id`, `payment_id`, `year`, `student_id`, `particular_id`, `payment_month`, `frequency`, `amount`, `created_at`, `sub_id`) VALUES("3","3","2025","202510039","30",NULL,"One Time","1500","2025-11-25 08:04:45","1");
INSERT INTO `accounting_payment_particular_v5` (`id`, `payment_id`, `year`, `student_id`, `particular_id`, `payment_month`, `frequency`, `amount`, `created_at`, `sub_id`) VALUES("4","4","2025","20252045","30",NULL,"One Time","1500","2025-12-14 15:09:02","4");


-- Table structure for table `accounting_payment_transport_v5`
DROP TABLE IF EXISTS `accounting_payment_transport_v5`;
CREATE TABLE `accounting_payment_transport_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `month` varchar(30) NOT NULL,
  `amount` varchar(200) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_payment_transport_v5`


-- Table structure for table `accounting_payment_tuition_v5`
DROP TABLE IF EXISTS `accounting_payment_tuition_v5`;
CREATE TABLE `accounting_payment_tuition_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `month` varchar(20) NOT NULL,
  `amount` varchar(200) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_payment_tuition_v5`


-- Table structure for table `accounting_payment_v5`
DROP TABLE IF EXISTS `accounting_payment_v5`;
CREATE TABLE `accounting_payment_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `voucher_no` varchar(50) DEFAULT NULL,
  `student_id` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `course_id` int(11) NOT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `registration_no` varchar(50) DEFAULT NULL,
  `total_amount` varchar(50) NOT NULL,
  `discount` varchar(50) DEFAULT NULL,
  `paid_amount` varchar(50) NOT NULL,
  `payment_date` datetime NOT NULL,
  `payment_month` int(11) NOT NULL,
  `payment_type` varchar(50) NOT NULL,
  `receive_amount` varchar(20) DEFAULT NULL,
  `due_amount` varchar(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `discount_text` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_payment_v5`
INSERT INTO `accounting_payment_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `branch_id`, `registration_no`, `total_amount`, `discount`, `paid_amount`, `payment_date`, `payment_month`, `payment_type`, `receive_amount`, `due_amount`, `created_at`, `user_id`, `date`, `discount_text`) VALUES("1","0","202510037","2025","1","1","202510037","1500","0","1500","0000-00-00 00:00:00","11","cash","1500","0","2025-11-25 08:03:20","1","2025-11-25 08:03:20","");
INSERT INTO `accounting_payment_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `branch_id`, `registration_no`, `total_amount`, `discount`, `paid_amount`, `payment_date`, `payment_month`, `payment_type`, `receive_amount`, `due_amount`, `created_at`, `user_id`, `date`, `discount_text`) VALUES("2","0","202510038","2025","1","1","202510038","1500","0","1500","0000-00-00 00:00:00","11","cash","1500","0","2025-11-25 08:04:16","1","2025-11-25 08:04:16","");
INSERT INTO `accounting_payment_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `branch_id`, `registration_no`, `total_amount`, `discount`, `paid_amount`, `payment_date`, `payment_month`, `payment_type`, `receive_amount`, `due_amount`, `created_at`, `user_id`, `date`, `discount_text`) VALUES("3","0","202510039","2025","1","1","202510039","1500","0","1500","0000-00-00 00:00:00","11","cash","1500","0","2025-11-25 08:04:45","1","2025-11-25 08:04:45","");
INSERT INTO `accounting_payment_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `branch_id`, `registration_no`, `total_amount`, `discount`, `paid_amount`, `payment_date`, `payment_month`, `payment_type`, `receive_amount`, `due_amount`, `created_at`, `user_id`, `date`, `discount_text`) VALUES("4","0","20252045","2025","4","1","20252045","1500","0","1500","0000-00-00 00:00:00","12","cash","1500","0","2025-12-14 15:09:02","1","2025-12-14 15:09:02","");


-- Table structure for table `accounting_payments_request_v5`
DROP TABLE IF EXISTS `accounting_payments_request_v5`;
CREATE TABLE `accounting_payments_request_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(200) NOT NULL,
  `payment_month` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `payment_method` varchar(200) NOT NULL,
  `amount` varchar(200) NOT NULL,
  `type` varchar(200) NOT NULL,
  `transaction_id` varchar(200) NOT NULL,
  `student_id` int(11) NOT NULL,
  `course` int(11) NOT NULL,
  `year` varchar(20) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `response` varchar(1000) DEFAULT NULL,
  `pay_number` varchar(200) NOT NULL,
  `previous_submit_count` int(11) NOT NULL DEFAULT 0,
  `lock_status` int(11) NOT NULL DEFAULT 0,
  `status` varchar(300) NOT NULL DEFAULT 'Pending',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_payments_request_v5`
INSERT INTO `accounting_payments_request_v5` (`id`, `invoice_id`, `payment_month`, `description`, `payment_method`, `amount`, `type`, `transaction_id`, `student_id`, `course`, `year`, `date`, `response`, `pay_number`, `previous_submit_count`, `lock_status`, `status`) VALUES("1","30","0","ভর্তি ফি","3","1500","Payment","1235","20252045","4","2025","2025-12-14 15:06:19",NULL,"01727316073","0","0","Pending");


-- Table structure for table `accounting_sell_v5`
DROP TABLE IF EXISTS `accounting_sell_v5`;
CREATE TABLE `accounting_sell_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `voucher_no` varchar(200) DEFAULT NULL,
  `student_id` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `course_id` int(11) NOT NULL,
  `regi` int(11) NOT NULL,
  `particulars` text NOT NULL,
  `discount` varchar(200) NOT NULL,
  `discount_text` varchar(200) NOT NULL,
  `paid_amount` varchar(200) NOT NULL,
  `receive_amount` varchar(200) NOT NULL,
  `due_amount` varchar(200) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_sell_v5`


-- Table structure for table `accounting_settings_sms_v5`
DROP TABLE IF EXISTS `accounting_settings_sms_v5`;
CREATE TABLE `accounting_settings_sms_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `one_time_collection` text NOT NULL,
  `multi_time_collection` text NOT NULL,
  `one_time_due_collection` varchar(2000) NOT NULL,
  `multi_time_due_collection` varchar(2000) NOT NULL,
  `due_reminder_template` varchar(2000) NOT NULL,
  `invoice_url` varchar(300) NOT NULL,
  `apiUrl` varchar(500) NOT NULL,
  `apiKey` varchar(500) NOT NULL,
  `authKey` varchar(500) NOT NULL,
  `sms_status` varchar(200) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_settings_sms_v5`
INSERT INTO `accounting_settings_sms_v5` (`id`, `one_time_collection`, `multi_time_collection`, `one_time_due_collection`, `multi_time_due_collection`, `due_reminder_template`, `invoice_url`, `apiUrl`, `apiKey`, `authKey`, `sms_status`, `date`) VALUES("1","সম্মানিত অভিভাবক  আপনার  পেমেন্ট   `item_info` মাসের  গৃহীত হয়েছে: `recive_amount_bn` টাকা,অপরিশোধিত পরিমাণ: `due_amount_bn` টাকা, ইনভয়েস আইডি: `payment_id_bn` . শিক্ষার্থীর নাম: মুহাম্মদ `student_name_bn`, শিক্ষার্থীর আইডি: `student_id_bn` , ইনভয়েস পরীক্ষা করুন: `invoice_url` ওয়েব বাজার বিডি","আপনার  পেমেন্ট  গৃহীত হয়েছে: `recive_amount_bn` টাকা,অপরিশোধিত পরিমাণ: `due_amount_bn` টাকা, ইনভয়েস আইডি: `payment_id_bn`","সম্মানিত অভিভাবক  আপনার  পেমেন্ট  গৃহীত হয়েছে: `now_payment_bn` টাকা,অপরিশোধিত পরিমাণ: `due_amount_bn` টাকা. শিক্ষার্থীর নাম: মুহাম্মদ `student_name_bn`, শিক্ষার্থীর আইডি: `student_id_bn` , ইনভয়েস পরীক্ষা করুন: `invoice_url` ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","সম্মানিত অভিভাবক  আপনার  পেমেন্ট  গৃহীত হয়েছে: `now_payment_bn` টাকা,অপরিশোধিত পরিমাণ: `due_amount_bn` টাকা  . শিক্ষার্থীর নাম: মুহাম্মদ `student_name_bn`, শিক্ষার্থীর আইডি: `student_id_bn` , ইনভয়েস পরীক্ষা করুন: `invoice_url` ওয়েব বাজার বিডি","সম্মানিত অভিভাবক শিক্ষার্থীর নাম: `student_name_bn`, শিক্ষার্থীর আইডি: `student_id_bn` , অপরিশোধিত টাকা: `due_amount_bn`","https://doubariidealpublicschool.top/sms","","","","on","2025-11-02 07:45:38");


-- Table structure for table `accounting_settings_v5`
DROP TABLE IF EXISTS `accounting_settings_v5`;
CREATE TABLE `accounting_settings_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `website_name` varchar(300) NOT NULL,
  `short_name` varchar(300) NOT NULL,
  `website_name_bn` varchar(300) NOT NULL,
  `logo` varchar(300) NOT NULL,
  `watermark` varchar(300) NOT NULL,
  `address` varchar(300) NOT NULL,
  `address_bn` varchar(300) NOT NULL,
  `site_url` varchar(300) NOT NULL,
  `invoice` varchar(300) NOT NULL,
  `invoice_note` varchar(300) NOT NULL,
  `invoice_paid_mark` varchar(300) NOT NULL,
  `currency` varchar(20) NOT NULL,
  `sslcommerz` varchar(200) NOT NULL,
  `bkash` varchar(500) NOT NULL,
  `manual_payment` varchar(200) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `invoice_prefix` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_settings_v5`
INSERT INTO `accounting_settings_v5` (`id`, `website_name`, `short_name`, `website_name_bn`, `logo`, `watermark`, `address`, `address_bn`, `site_url`, `invoice`, `invoice_note`, `invoice_paid_mark`, `currency`, `sslcommerz`, `bkash`, `manual_payment`, `date`, `invoice_prefix`) VALUES("1","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","logo_1761701460_2logo.png","watermark_1761701460_2logo.png","গ্রাম : ডৌবাড়ী  উপজেলাঃ গোয়াইনঘাট  জেলাঃ সিলেট বিভাগ ঃ সিলেট।","গ্রাম : ডৌবাড়ী  উপজেলাঃ গোয়াইনঘাট  জেলাঃ সিলেট বিভাগ ঃ সিলেট।","https://doubariidealpublicschool.top/sms/","invoice_1","প্রিয় অভিভাবকবৃন্দ, আপনাদের অবগতির জন্য জানানো যাচ্ছে যে, শিক্ষার্থীর বেতন প্রতিমাসের ১-৫ তারিখের মধ্যে দেওয়ার অনুরোধ করা হচ্ছে। কর্তৃপক্ষ","on","","off","off","on","2025-10-29 01:31:00","dIps");


-- Table structure for table `accounting_ssl_pay`
DROP TABLE IF EXISTS `accounting_ssl_pay`;
CREATE TABLE `accounting_ssl_pay` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(100) NOT NULL,
  `payment_month` varchar(11) DEFAULT NULL,
  `payment_id` varchar(100) NOT NULL,
  `student_id` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `course_id` int(11) NOT NULL,
  `amount` varchar(100) NOT NULL,
  `payment_type` varchar(100) NOT NULL,
  `description` text NOT NULL,
  `status` varchar(200) NOT NULL,
  `payment_execute_time` datetime NOT NULL,
  `payment_method` varchar(200) NOT NULL,
  `response` varchar(500) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_ssl_pay`


-- Table structure for table `accounting_transaction_v5`
DROP TABLE IF EXISTS `accounting_transaction_v5`;
CREATE TABLE `accounting_transaction_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `voucher_no` varchar(200) DEFAULT NULL,
  `student_id` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `course_id` int(11) NOT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `receive_amount` varchar(500) NOT NULL,
  `payment_method_id` varchar(110) NOT NULL,
  `payment_id` int(11) NOT NULL,
  `type` varchar(200) NOT NULL,
  `paymentID` varchar(1000) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_transaction_v5`
INSERT INTO `accounting_transaction_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `branch_id`, `receive_amount`, `payment_method_id`, `payment_id`, `type`, `paymentID`, `created_at`) VALUES("1","0","202510037","2025","1","1","1500","3","1","particular",NULL,"2025-11-25 08:03:20");
INSERT INTO `accounting_transaction_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `branch_id`, `receive_amount`, `payment_method_id`, `payment_id`, `type`, `paymentID`, `created_at`) VALUES("2","0","202510038","2025","1","1","1500","3","2","particular",NULL,"2025-11-25 08:04:16");
INSERT INTO `accounting_transaction_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `branch_id`, `receive_amount`, `payment_method_id`, `payment_id`, `type`, `paymentID`, `created_at`) VALUES("3","0","202510039","2025","1","1","1500","3","3","particular",NULL,"2025-11-25 08:04:45");
INSERT INTO `accounting_transaction_v5` (`id`, `voucher_no`, `student_id`, `year`, `course_id`, `branch_id`, `receive_amount`, `payment_method_id`, `payment_id`, `type`, `paymentID`, `created_at`) VALUES("4","0","20252045","2025","4","1","1500","3","4","particular",NULL,"2025-12-14 15:09:02");


-- Table structure for table `accounting_transport_fee_v5`
DROP TABLE IF EXISTS `accounting_transport_fee_v5`;
CREATE TABLE `accounting_transport_fee_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `amount` int(11) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_transport_fee_v5`


-- Table structure for table `accounting_tuition_fee_v5`
DROP TABLE IF EXISTS `accounting_tuition_fee_v5`;
CREATE TABLE `accounting_tuition_fee_v5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` varchar(500) NOT NULL,
  `year` varchar(200) NOT NULL,
  `amount` int(11) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `accounting_tuition_fee_v5`


-- Table structure for table `activities_student_v3`
DROP TABLE IF EXISTS `activities_student_v3`;
CREATE TABLE `activities_student_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `activity_status` varchar(200) NOT NULL,
  `course` varchar(200) NOT NULL,
  `subject` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `year` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `activities_student_v3`
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("1","2031","5","3","21","2025-04-04","2024");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("2","2032","7","3","21","2025-04-04","2024");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("3","2033","8","3","21","2025-04-04","2024");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("4","2031","6","3","44","2025-04-04","2024");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("5","2032","7","3","44","2025-04-04","2024");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("6","2033","8","3","44","2025-04-04","2024");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("7","2031","6","3","44","2025-04-07","2024");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("8","2032","7","3","44","2025-04-07","2024");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("9","2033","6","3","44","2025-04-07","2024");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("10","2031","5","3","44","2025-04-06","2024");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("11","2032","7","3","44","2025-04-06","2024");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("12","2033","7","3","44","2025-04-06","2024");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("13","2031","6","3","19","2025-04-08","2024");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("14","2032","7","3","19","2025-04-08","2024");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("15","2033","6","3","19","2025-04-08","2024");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("16","44","5","7","170","2025-08-03","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("17","43","5","7","170","2025-08-03","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("18","42","5","7","170","2025-08-03","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("19","41","5","7","170","2025-08-03","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("20","44","5","7","170","2025-08-05","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("21","43","6","7","170","2025-08-05","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("22","42","7","7","170","2025-08-05","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("23","41","9","7","170","2025-08-05","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("24","44","5","7","170","2025-08-10","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("25","43","6","7","170","2025-08-10","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("26","42","6","7","170","2025-08-10","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("27","41","6","7","170","2025-08-10","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("28","44","5","7","170","2025-08-13","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("29","43","7","7","170","2025-08-13","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("30","42","7","7","170","2025-08-13","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("31","41","5","7","170","2025-08-13","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("32","44","6","7","170","2025-08-23","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("33","43","5","7","170","2025-08-23","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("34","42","7","7","170","2025-08-23","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("35","41","8","7","170","2025-08-23","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("36","44","5","7","170","2025-08-25","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("37","43","5","7","170","2025-08-25","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("38","42","5","7","170","2025-08-25","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("39","41","5","7","170","2025-08-25","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("40","20222015","","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("41","1","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("42","3","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("43","4","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("44","5","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("45","6","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("46","8","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("47","7","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("48","9","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("49","10","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("50","11","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("51","16","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("52","15","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("53","14","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("54","13","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("55","12","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("56","22","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("57","21","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("58","20","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("59","19","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("60","18","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("61","17","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("62","24","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("63","23","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("64","30","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("65","29","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("66","28","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("67","27","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("68","26","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("69","25","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("70","38","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("71","37","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("72","36","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("73","80","5","1","119","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("74","20222015","","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("75","1","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("76","3","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("77","4","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("78","5","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("79","6","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("80","8","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("81","7","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("82","9","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("83","10","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("84","11","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("85","16","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("86","15","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("87","14","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("88","13","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("89","12","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("90","22","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("91","21","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("92","20","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("93","19","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("94","18","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("95","17","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("96","24","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("97","23","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("98","30","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("99","29","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("100","28","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("101","27","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("102","26","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("103","25","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("104","38","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("105","37","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("106","36","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("107","80","5","1","120","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("108","20222015","","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("109","1","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("110","3","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("111","4","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("112","5","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("113","6","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("114","8","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("115","7","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("116","9","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("117","10","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("118","11","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("119","16","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("120","15","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("121","14","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("122","13","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("123","12","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("124","22","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("125","21","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("126","20","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("127","19","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("128","18","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("129","17","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("130","24","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("131","23","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("132","30","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("133","29","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("134","28","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("135","27","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("136","26","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("137","25","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("138","38","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("139","37","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("140","36","5","1","121","2025-10-30","2025");
INSERT INTO `activities_student_v3` (`id`, `student_id`, `activity_status`, `course`, `subject`, `date`, `year`) VALUES("141","80","5","1","121","2025-10-30","2025");


-- Table structure for table `activities_v3`
DROP TABLE IF EXISTS `activities_v3`;
CREATE TABLE `activities_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `details` varchar(2000) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `activities_v3`
INSERT INTO `activities_v3` (`id`, `name`, `details`, `date`) VALUES("5","ভালো","ভালো","2024-12-27 06:04:20");
INSERT INTO `activities_v3` (`id`, `name`, `details`, `date`) VALUES("6","উত্তম","উত্তম","2024-12-27 06:04:29");
INSERT INTO `activities_v3` (`id`, `name`, `details`, `date`) VALUES("7","খারাপ","খারাপ","2024-12-27 06:04:38");
INSERT INTO `activities_v3` (`id`, `name`, `details`, `date`) VALUES("8","খুবই খারাপ","খুবই খারাপ","2024-12-27 06:04:45");
INSERT INTO `activities_v3` (`id`, `name`, `details`, `date`) VALUES("9","Others","Others","2025-01-11 08:50:19");


-- Table structure for table `add_registation_number_update_info`
DROP TABLE IF EXISTS `add_registation_number_update_info`;
CREATE TABLE `add_registation_number_update_info` (
  `id` int(11) NOT NULL,
  `log_type` varchar(100) NOT NULL,
  `data` text NOT NULL,
  `title` varchar(100) NOT NULL,
  `creator_by` int(30) NOT NULL,
  `creator_by_sub_user` int(11) NOT NULL,
  `is_read` text NOT NULL,
  `is_red_sub_user` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table `add_registation_number_update_info`
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("0","registation number create","{\"message\":\"Created by admin Update Registration create   \",\"creator_name\":\"admin\",\"student_id_p\":\"1\"}","Update Registration number","1","0","[\"1\"]","[\"2\"]","2023-12-19 01:15:08","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("30","registation number create","{\"message\":\"Created by admin Update Registration create   \",\"creator_name\":\"admin\",\"student_id_p\":\"1\"}","Update Registration number","1","0","[\"1\"]","[\"2\"]","2023-11-04 10:49:41","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("31","registation number create","{\"message\":\"Created by admin Update Registration create   \",\"creator_name\":\"admin\",\"student_id_p\":\"4\"}","Update Registration number","1","0","[\"1\"]","[\"2\"]","2023-11-30 02:02:41","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("32","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 3\",\"creator_name\":\"admin\",\"course_id\":\"3\",\"start_number\":\"000020\",\"success_count\":2,\"error_count\":0}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-03-26 20:24:01","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("33","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 3\",\"creator_name\":\"admin\",\"course_id\":\"3\",\"start_number\":\"20253\",\"success_count\":2,\"error_count\":0}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-03-26 20:24:28","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("34","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 3\",\"creator_name\":\"admin\",\"course_id\":\"3\",\"start_number\":\"20243\",\"success_count\":2,\"error_count\":0}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-03-29 04:47:35","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("35","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 1\",\"creator_name\":\"admin\",\"course_id\":\"1\",\"start_number\":\"1\",\"success_count\":3,\"error_count\":0}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-04-18 05:45:43","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("36","registation number create","{\"message\":\"Created by admin Update Registration create   \",\"creator_name\":\"admin\",\"student_id_p\":\"2\"}","Update Registration number","1","0","[\"1\"]","[\"2\"]","2025-07-25 15:37:32","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("37","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 1\",\"creator_name\":\"admin\",\"course_id\":\"1\",\"start_number\":\"12345\",\"success_count\":23,\"error_count\":0}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-07-25 15:40:51","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("38","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 1\",\"creator_name\":\"admin\",\"course_id\":\"1\",\"start_number\":\"12345\",\"success_count\":23,\"error_count\":0}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-07-25 15:41:21","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("39","registation number create","{\"message\":\"Created by admin Update Registration create   \",\"creator_name\":\"admin\",\"student_id_p\":\"2\"}","Update Registration number","1","0","[\"1\"]","[\"2\"]","2025-07-25 15:42:01","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("40","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 2\",\"creator_name\":\"admin\",\"course_id\":\"2\",\"start_number\":\"1\",\"success_count\":13,\"error_count\":0}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-07-27 17:57:05","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("41","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 3\",\"creator_name\":\"admin\",\"course_id\":\"3\",\"start_number\":\"1\",\"success_count\":0,\"error_count\":6}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-07-27 17:59:01","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("42","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 3\",\"creator_name\":\"admin\",\"course_id\":\"3\",\"start_number\":\"1\",\"success_count\":0,\"error_count\":6}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-07-27 18:00:05","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("43","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 4\",\"creator_name\":\"admin\",\"course_id\":\"4\",\"start_number\":\"1\",\"success_count\":0,\"error_count\":6}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-07-27 18:01:16","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("44","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 3\",\"creator_name\":\"admin\",\"course_id\":\"3\",\"start_number\":\"1\",\"success_count\":0,\"error_count\":6}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-07-27 18:02:56","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("45","registation number create","{\"message\":\"Created by admin Update Registration create   \",\"creator_name\":\"admin\",\"student_id_p\":\"2\"}","Update Registration number","1","0","[\"1\"]","[\"2\"]","2025-07-27 18:16:04","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("46","registation number create","{\"message\":\"Created by admin Update Registration create   \",\"creator_name\":\"admin\",\"student_id_p\":\"3\"}","Update Registration number","1","0","[\"1\"]","[\"2\"]","2025-07-27 18:16:24","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("47","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 2\",\"creator_name\":\"admin\",\"course_id\":\"2\",\"start_number\":\"1\",\"success_count\":13,\"error_count\":0}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-07-27 18:17:02","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("48","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 5\",\"creator_name\":\"admin\",\"course_id\":\"5\",\"start_number\":\"1\",\"success_count\":0,\"error_count\":12}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-07-27 18:19:08","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("49","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 5\",\"creator_name\":\"admin\",\"course_id\":\"5\",\"start_number\":\"1\",\"success_count\":0,\"error_count\":12}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-07-27 18:19:43","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("50","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 5\",\"creator_name\":\"admin\",\"course_id\":\"5\",\"start_number\":\"23\",\"success_count\":12,\"error_count\":0}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-07-27 18:20:02","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("51","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 4\",\"creator_name\":\"admin\",\"course_id\":\"4\",\"start_number\":\"1\",\"success_count\":0,\"error_count\":6}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-07-27 18:24:12","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("52","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 4\",\"creator_name\":\"admin\",\"course_id\":\"4\",\"start_number\":\"10\",\"success_count\":2,\"error_count\":4}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-07-27 18:24:31","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("53","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 4\",\"creator_name\":\"admin\",\"course_id\":\"4\",\"start_number\":\"1\",\"success_count\":0,\"error_count\":6}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-07-27 18:25:56","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("54","registation number create","{\"message\":\"Created by admin Update Registration create   \",\"creator_name\":\"admin\",\"student_id_p\":\"11\"}","Update Registration number","1","0","[\"1\"]","[\"2\"]","2025-07-31 16:36:53","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("55","registation number create","{\"message\":\"Created by admin Update Registration create   \",\"creator_name\":\"admin\",\"student_id_p\":\"2\"}","Update Registration number","1","0","[\"1\"]","[\"2\"]","2025-07-31 16:37:16","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("56","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 3\",\"creator_name\":\"admin\",\"course_id\":\"3\",\"start_number\":\"1\",\"success_count\":0,\"error_count\":6}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-08-01 06:35:14","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("57","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 3\",\"creator_name\":\"admin\",\"course_id\":\"3\",\"start_number\":\"10\",\"success_count\":0,\"error_count\":6}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-08-01 06:35:35","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("58","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 3\",\"creator_name\":\"admin\",\"course_id\":\"3\",\"start_number\":\"30\",\"success_count\":1,\"error_count\":5}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-08-01 06:40:15","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("59","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 3\",\"creator_name\":\"admin\",\"course_id\":\"3\",\"start_number\":\"36\",\"success_count\":6,\"error_count\":0}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-08-01 06:41:23","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("60","registation number create","{\"message\":\"Created by admin Update Registration create   \",\"creator_name\":\"admin\",\"student_id_p\":\"4\"}","Update Registration number","1","0","[\"1\"]","[\"2\"]","2025-08-01 06:41:53","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("61","registation number create","{\"message\":\"Created by admin Update Registration create   \",\"creator_name\":\"admin\",\"student_id_p\":\"1\"}","Update Registration number","1","0","[\"1\"]","[\"2\"]","2025-08-01 06:42:08","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("62","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 5\",\"creator_name\":\"admin\",\"course_id\":\"5\",\"start_number\":\"25\",\"success_count\":1,\"error_count\":13}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-08-01 06:42:49","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("63","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 4\",\"creator_name\":\"admin\",\"course_id\":\"4\",\"start_number\":\"2025\",\"success_count\":6,\"error_count\":0}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-08-08 09:39:43","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("64","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 1\",\"creator_name\":\"admin\",\"course_id\":\"1\",\"start_number\":\"202501\",\"success_count\":33,\"error_count\":0}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-08-10 15:25:37","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("65","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 2\",\"creator_name\":\"admin\",\"course_id\":\"2\",\"start_number\":\"2025\",\"success_count\":7,\"error_count\":6}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-08-10 15:39:10","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("66","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 3\",\"creator_name\":\"admin\",\"course_id\":\"3\",\"start_number\":\"2025\",\"success_count\":0,\"error_count\":6}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-08-10 15:39:52","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("67","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 5\",\"creator_name\":\"admin\",\"course_id\":\"5\",\"start_number\":\"2025\",\"success_count\":1,\"error_count\":13}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-08-11 13:59:32","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("68","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 5\",\"creator_name\":\"admin\",\"course_id\":\"5\",\"start_number\":\"202501\",\"success_count\":0,\"error_count\":14}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-08-11 14:00:01","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("69","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 5\",\"creator_name\":\"admin\",\"course_id\":\"5\",\"start_number\":\"1\",\"success_count\":8,\"error_count\":6}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-08-11 14:14:49","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("70","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 5\",\"creator_name\":\"admin\",\"course_id\":\"5\",\"start_number\":\"202503\",\"success_count\":0,\"error_count\":14}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-08-11 14:23:43","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("71","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 5\",\"creator_name\":\"admin\",\"course_id\":\"5\",\"start_number\":\"20253\",\"success_count\":14,\"error_count\":0}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-08-11 14:24:05","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("72","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 5\",\"creator_name\":\"admin\",\"course_id\":\"5\",\"start_number\":\"202501\",\"success_count\":0,\"error_count\":14}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-08-11 14:25:07","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("73","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 5\",\"creator_name\":\"admin\",\"course_id\":\"5\",\"start_number\":\"202501\",\"success_count\":0,\"error_count\":14}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-08-11 14:25:31","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("74","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 5\",\"creator_name\":\"admin\",\"course_id\":\"5\",\"start_number\":\"202531\",\"success_count\":11,\"error_count\":3}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-08-11 14:26:00","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("75","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 5\",\"creator_name\":\"admin\",\"course_id\":\"5\",\"start_number\":\"202545\",\"success_count\":14,\"error_count\":0}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-08-11 14:29:23","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("76","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 1\",\"creator_name\":\"admin\",\"course_id\":\"1\",\"start_number\":\"202570\",\"success_count\":33,\"error_count\":0}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-08-11 14:31:14","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("77","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 2\",\"creator_name\":\"admin\",\"course_id\":\"2\",\"start_number\":\"202594\",\"success_count\":4,\"error_count\":9}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-08-11 14:31:59","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("78","bulk registration update","{\"message\":\"Created by admin Bulk Registration Update for Course ID: 3\",\"creator_name\":\"admin\",\"course_id\":\"3\",\"start_number\":\"202597\",\"success_count\":0,\"error_count\":6}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-08-11 14:32:27","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("79","bulk registration update","{\"message\":\"Created by doubari_admin Bulk Registration Update for Course ID: 6\",\"creator_name\":\"doubari_admin\",\"course_id\":\"6\",\"start_number\":\"2025110\",\"success_count\":2,\"error_count\":0}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-11-05 04:40:06","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("80","bulk registration update","{\"message\":\"Created by doubari_admin Bulk Registration Update for Course ID: 5\",\"creator_name\":\"doubari_admin\",\"course_id\":\"5\",\"start_number\":\"2025001\",\"success_count\":15,\"error_count\":0}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-11-05 04:47:25","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("81","bulk registration update","{\"message\":\"Created by doubari_admin Bulk Registration Update for Course ID: 7\",\"creator_name\":\"doubari_admin\",\"course_id\":\"7\",\"start_number\":\"202520\",\"success_count\":4,\"error_count\":0}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-11-05 05:23:18","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("82","bulk registration update","{\"message\":\"Created by doubari_admin Bulk Registration Update for Course ID: 3\",\"creator_name\":\"doubari_admin\",\"course_id\":\"3\",\"start_number\":\"2025001\",\"success_count\":0,\"error_count\":6}","Bulk Update Registration numbers","1","0","[\"1\"]","[\"2\"]","2025-11-16 07:55:07","user");
INSERT INTO `add_registation_number_update_info` (`id`, `log_type`, `data`, `title`, `creator_by`, `creator_by_sub_user`, `is_read`, `is_red_sub_user`, `created_at`, `status`) VALUES("83","registation number create","{\"message\":\"Created by doubari_admin Update Registration create   \",\"creator_name\":\"doubari_admin\",\"student_id_p\":\"20252031\"}","Update Registration number","1","0","[\"1\"]","[\"2\"]","2025-11-16 07:58:45","user");


-- Table structure for table `admin_notice`
DROP TABLE IF EXISTS `admin_notice`;
CREATE TABLE `admin_notice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `notice_title` varchar(255) DEFAULT NULL,
  `notice_desc` longtext DEFAULT NULL,
  `notice_link` varchar(255) DEFAULT NULL,
  `teacher_action` varchar(255) DEFAULT NULL,
  `course_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `start_date` varchar(255) DEFAULT NULL,
  `update_date` timestamp NULL DEFAULT current_timestamp(),
  `image` varchar(255) DEFAULT NULL,
  `status` varchar(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `admin_notice`
INSERT INTO `admin_notice` (`id`, `notice_title`, `notice_desc`, `notice_link`, `teacher_action`, `course_id`, `user_id`, `start_date`, `update_date`, `image`, `status`) VALUES("23","আপনার সন্তানকে নিয়মিত বিদ্যালয় পাঠাবেন।","আপনার সন্তানকে নিয়মিত  বিদ্যালয়ে পাঠাবেন তাহলে আপনার সন্তানের  উন্নতি হবে",NULL,"all,69,73,74,75,76,77","all,1,2,3,4,5,6,7,8,9,10,11,12","","1753891684","2025-07-30 16:08:04","","user");
INSERT INTO `admin_notice` (`id`, `notice_title`, `notice_desc`, `notice_link`, `teacher_action`, `course_id`, `user_id`, `start_date`, `update_date`, `image`, `status`) VALUES("24"," আসসালামু আলাইকুম, ।প্রতি মাসের ৫ তারিখের মধ্যে আপনার সন্তানের মাসিক বেতন পরিশোধ করে  অংশীজন হিসেবে সহযোগিতা  করবেন । আপনার সহযোগিতায় বিদ্যালয় অনেক দূর এগিয়ে যাবে ।","শিক্ষার্থীদের বেতন পরিশোধ করেন ।",NULL,"all,69,73,74,75,76,77","all,1,2,3,4,5,6,7,8,9,10,11,12","","1754407523","2025-08-05 14:32:54","","1");


-- Table structure for table `admission_form_settings`
DROP TABLE IF EXISTS `admission_form_settings`;
CREATE TABLE `admission_form_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_name` varchar(100) NOT NULL,
  `show_field` tinyint(1) NOT NULL DEFAULT 1,
  `label` varchar(255) NOT NULL,
  `correction_text` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `admission_form_settings`
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("1","s_name_en","1","Student Name (English)","Student Name (English)");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("2","s_name_bn","1","Student Name (Bangla)","Student Name (Bangla)");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("3","s_mobile","1","Mother Mobile Number","Mother Mobile Number");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("4","s_email","1","Email (Optional)","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("5","s_birth_date","1","Date Of Birth","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("6","id_type","1","ID TYPE","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("7","s_birth_certificate","1","Birth Certificate No","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("8","s_gender","1","Gender","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("9","religion","1","Religion","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("10","bloodgroup","1","Blood Group","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("11","present_school_name","1","Present School Name","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("12","s_father_name_en","0","Father Name (English)","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("13","s_father_name_bn","1","Father Name (Bangla)","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("14","s_father_dob","1","Father Date of Birth","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("15","s_father_nid","1","Father National ID Number","Father ID");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("16","s_father_profession","1","Father Profession","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("17","s_father_contact","1","Father Mobile Number","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("18","s_mother_name_en","1","Mother Name (English)","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("19","s_mother_name_bn","1","Mother Name (Bangla)","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("20","s_mother_dob","1","Mother Date of Birth","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("21","s_mother_nid","1","Mother National ID Number","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("22","s_mother_profession","1","Mother Profession","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("23","s_parents_income","1","Parents Yearly Income","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("24","s_village","1","Village/House, Road","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("25","s_post_office","1","Post/Block, Section","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("26","s_police","1","Thana","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("27","s_district","1","District","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("28","p_ad_v","1","Permanent Village/House, Road","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("29","p_ad_p","1","Permanent Post/Block, Section","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("30","p_ad_t","1","Permanent Thana","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("31","p_ad_d","1","Permanent District","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("32","class","1","Course","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("33","branch","1","Group","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("34","section","1","Section","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("35","shift","1","Shift","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("36","academic_year","1","Session","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("37","quota_name","1","Student Quotes","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("38","institution_name_ex","1","Get Admission In Any Institution","Get Admission In Any Institution2");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("39","trade_name","1","Name of Educational Institution","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("40","s_image","1","Student Image ( jpg / png support )","Student Image ( jpg / png support )2");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("41","student_signature","1","Student Signature (optional)","");
INSERT INTO `admission_form_settings` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("42","institution_name_ex_text","1","institution_name_ex_text","institution_name_ex_text");


-- Table structure for table `admission_form_settings_bangla`
DROP TABLE IF EXISTS `admission_form_settings_bangla`;
CREATE TABLE `admission_form_settings_bangla` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_name` varchar(100) NOT NULL,
  `show_field` tinyint(1) NOT NULL DEFAULT 1,
  `label` varchar(255) NOT NULL,
  `correction_text` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `admission_form_settings_bangla`
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("1","s_name_en","1","Student Name (English)","শিক্ষার্থীর নাম ইংরেজি");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("2","s_name_bn","1","Student Name (Bangla)","শিক্ষার্থীর নাম বাংলা");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("3","s_mobile","1","Mother Mobile Number","অভিভাকের মোবাইল নম্বর");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("4","s_email","0","Email (Optional)","ইমেল (ঐচ্ছিক)");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("5","s_birth_date","1","Date Of Birth","জন্ম তারিখ");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("6","id_type","1","ID TYPE","আইডি টাইপ");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("7","s_birth_certificate","1","Birth Certificate No","জন্ম সনদ নম্বর");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("8","s_gender","1","Gender","লিঙ্গ");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("9","religion","1","Religion","ধর্ম");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("10","bloodgroup","1","Blood Group","রক্তের গ্রুপ");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("11","present_school_name","0","Present School Name","পূর্বে স্কুলের নাম");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("12","s_father_name_en","1","Father Name (English)","পিতার নাম (ইংরেজি)");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("13","s_father_name_bn","1","Father Name (Bangla)","পিতার নাম (বাংলা)");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("14","s_father_dob","1","Father Date of Birth","পিতার জন্ম তারিখ");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("15","s_father_nid","1","Father National ID Number","পিতা জাতীয় পরিচয়পত্র");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("16","s_father_profession","1","Father Profession","পিতার পেশা");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("17","s_father_contact","1","Father Mobile Number","পিতার মোবাইল নম্বর");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("18","s_mother_name_en","1","Mother Name (English)","মায়ের নাম (ইংরেজি)");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("19","s_mother_name_bn","1","Mother Name (Bangla)","মাতার নাম (বাংলা)");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("20","s_mother_dob","1","Mother Date of Birth","মায়ের জন্ম তারিখ");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("21","s_mother_nid","1","Mother National ID Number","মায়ের জাতীয় পরিচয়পত্র");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("22","s_mother_profession","1","Mother Profession","মায়ের পেশা");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("23","s_parents_income","0","Parents Yearly Income","পিতামাতার বার্ষিক আয়");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("24","s_village","1","Village/House, Road","গ্রাম/বাড়ি, রাস্তা");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("25","s_post_office","1","Post/Block, Section","ডাকঘর");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("26","s_police","1","Thana","থানা");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("27","s_district","1","District","জেলা");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("28","p_ad_v","1","Permanent Village/House, Road","স্থায়ী গ্রাম/বাড়ি, রাস্তা");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("29","p_ad_p","1","Permanent Post/Block, Section","ডাকঘর");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("30","p_ad_t","1","Permanent Thana","স্থায়ী থানা");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("31","p_ad_d","1","Permanent District","স্থায়ী জেলা");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("32","class","1","Course","ক্লাস");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("33","branch","1","Group","গ্রুপ");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("34","section","1","Section","বিভাগ");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("35","shift","1","Shift","সিফট");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("36","academic_year","1","Session","সাল");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("37","quota_name","0","Student Quotes","শিক্ষার্থী কোটা");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("38","institution_name_ex","1","Get Admission In Any Institution","ভর্তির প্রতিষ্ঠানের নাম সিলেক্ট করুন");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("39","trade_name","0","Name of Educational Institution","শিক্ষা প্রতিষ্ঠানের নাম");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("40","s_image","1","Student Image ( jpg / png support )","ছাত্রের ছবি (jpg / png সাপোর্ট)");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("41","student_signature","0","Student Signature (optional)","শিক্ষার্থীর স্বাক্ষর (ঐচ্ছিক)");
INSERT INTO `admission_form_settings_bangla` (`id`, `field_name`, `show_field`, `label`, `correction_text`) VALUES("42","institution_name_ex_text","0","institution_name_ex_text","institution_name_ex_text");


-- Table structure for table `admission_form_tamplete`
DROP TABLE IF EXISTS `admission_form_tamplete`;
CREATE TABLE `admission_form_tamplete` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_name` varchar(250) NOT NULL,
  `file_name` varchar(250) DEFAULT NULL,
  `form_no` varchar(100) NOT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

-- Dumping data for table `admission_form_tamplete`
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("2","
\nADMISSION FORM - 1 (English)",NULL,"1","0");
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("3","ADMISSION FORM - 2 (Bangla)",NULL,"2","0");
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("4","ADMISSION FORM - 3",NULL,"3","0");
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("5","ADMISSION FORM - 4",NULL,"4","0");
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("6","ADMISSION FORM - 5",NULL,"5","0");
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("7","ADMISSION FORM - 6",NULL,"6","0");
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("8","ADMISSION FORM - 7",NULL,"7","0");
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("9","ADMISSION FORM - 8",NULL,"8","0");
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("10","
\nADMISSION FORM - 9 (English)",NULL,"9","0");
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("11","ADMISSION FORM - 10 (Bangla)",NULL,"10","0");
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("12","\nADMISSION FORM - 11 (English)",NULL,"11","0");
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("13","ADMISSION FORM - 12 (Bangla)",NULL,"12","0");
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("14","ADMISSION FORM - 13 (English)",NULL,"13","0");
INSERT INTO `admission_form_tamplete` (`id`, `form_name`, `file_name`, `form_no`, `status`) VALUES("15","ADMISSION FORM - 14 (Bangla)",NULL,"14","1");


-- Table structure for table `admission_switch`
DROP TABLE IF EXISTS `admission_switch`;
CREATE TABLE `admission_switch` (
  `id` int(10) NOT NULL,
  `msg` varchar(250) NOT NULL,
  `admission_start_date` varchar(250) DEFAULT NULL,
  `admission_last_date` varchar(250) DEFAULT NULL,
  `type` varchar(100) NOT NULL,
  `status` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `admission_switch`
INSERT INTO `admission_switch` (`id`, `msg`, `admission_start_date`, `admission_last_date`, `type`, `status`) VALUES("1","এখন থেকে শুরু","1757127600","1767188160","student","1");
INSERT INTO `admission_switch` (`id`, `msg`, `admission_start_date`, `admission_last_date`, `type`, `status`) VALUES("2","Contact Admin For Teacher Registration","1757125620","1767191220","teacher","1");


-- Table structure for table `admit_activation`
DROP TABLE IF EXISTS `admit_activation`;
CREATE TABLE `admit_activation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `zi_section` int(11) DEFAULT NULL,
  `zi_year` int(11) DEFAULT NULL,
  `zi_session` int(11) DEFAULT NULL,
  `zi_class` int(11) DEFAULT NULL,
  `z_exam_name` int(11) DEFAULT NULL,
  `z_regi_id` int(11) DEFAULT NULL,
  `z_shift` int(11) DEFAULT NULL,
  `z_group` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `admit_activation`
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("13","6","2023","3","3","21","1","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("14","6","2023","3","3","21","3","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("15","6","2023","3","3","21","2","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("16","6","2023","3","3","21","47","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("17","6","2023","3","3","23","1","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("18","6","2023","3","3","23","3","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("19","6","2023","3","3","23","2","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("20","6","2023","3","3","23","47","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("21","6","2023","3","3","21","2","1","2","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("22","6","2023","3","3","29","2","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("23","6","2023","3","3","29","0","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("24","6","2023","3","3","29","1","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("25","6","2024","4","3","21","7","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("26","6","2024","4","3","21","6","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("27","6","2024","4","3","21","5","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("28","6","2024","4","3","21","4","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("29","6","2024","4","3","21","3","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("30","6","2024","4","3","21","1","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("31","6","2024","4","3","21","2","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("32","6","2024","4","3","21","0","1","1","1");
INSERT INTO `admit_activation` (`id`, `zi_section`, `zi_year`, `zi_session`, `zi_class`, `z_exam_name`, `z_regi_id`, `z_shift`, `z_group`, `status`) VALUES("33","6","2024","4","3","21","9","1","1","1");


-- Table structure for table `admit_card_download`
DROP TABLE IF EXISTS `admit_card_download`;
CREATE TABLE `admit_card_download` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `start_date` varchar(250) NOT NULL,
  `end_date` varchar(250) NOT NULL,
  `class` varchar(250) NOT NULL,
  `branch` varchar(250) NOT NULL,
  `year` varchar(250) NOT NULL,
  `session` varchar(250) NOT NULL,
  `section` varchar(100) DEFAULT NULL,
  `shift` varchar(100) DEFAULT NULL,
  `exam_name` longtext NOT NULL,
  `description_code` varchar(100) NOT NULL,
  `particular_id` int(11) NOT NULL,
  `payment_month` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `admit_card_download`
INSERT INTO `admit_card_download` (`id`, `start_date`, `end_date`, `class`, `branch`, `year`, `session`, `section`, `shift`, `exam_name`, `description_code`, `particular_id`, `payment_month`) VALUES("19","2025-10-20","2025-10-20","1","1","2025","6","6","3","Annual Examination 2025","1","0","2025-11-01");
INSERT INTO `admit_card_download` (`id`, `start_date`, `end_date`, `class`, `branch`, `year`, `session`, `section`, `shift`, `exam_name`, `description_code`, `particular_id`, `payment_month`) VALUES("20","2025-10-20","2025-11-20","2","1","2025","6","6","3","Annual Examination 2025","1","0","2025-11-01");
INSERT INTO `admit_card_download` (`id`, `start_date`, `end_date`, `class`, `branch`, `year`, `session`, `section`, `shift`, `exam_name`, `description_code`, `particular_id`, `payment_month`) VALUES("21","2025-10-20","2025-10-20","3","1","2025","6","6","3","Annual Examination 2025","1","0","2025-11-01");
INSERT INTO `admit_card_download` (`id`, `start_date`, `end_date`, `class`, `branch`, `year`, `session`, `section`, `shift`, `exam_name`, `description_code`, `particular_id`, `payment_month`) VALUES("22","2025-10-20","2025-10-20","4","1","2025","6","6","3","Annual Examination 2025","1","0","2025-11-01");
INSERT INTO `admit_card_download` (`id`, `start_date`, `end_date`, `class`, `branch`, `year`, `session`, `section`, `shift`, `exam_name`, `description_code`, `particular_id`, `payment_month`) VALUES("23","2025-10-20","2025-10-20","5","1","2025","6","6","3","Annual Examination 2025","1","0","2025-11-01");
INSERT INTO `admit_card_download` (`id`, `start_date`, `end_date`, `class`, `branch`, `year`, `session`, `section`, `shift`, `exam_name`, `description_code`, `particular_id`, `payment_month`) VALUES("24","2025-10-20","2025-10-20","6","1","2025","6","6","3","Annual Examination 2025","1","0","2025-11-01");
INSERT INTO `admit_card_download` (`id`, `start_date`, `end_date`, `class`, `branch`, `year`, `session`, `section`, `shift`, `exam_name`, `description_code`, `particular_id`, `payment_month`) VALUES("25","2025-10-20","2025-11-20","7","1","2025","6","6","3","Annual Examination 2025","1","0","2025-11-01");
INSERT INTO `admit_card_download` (`id`, `start_date`, `end_date`, `class`, `branch`, `year`, `session`, `section`, `shift`, `exam_name`, `description_code`, `particular_id`, `payment_month`) VALUES("26","2025-11-16","2025-11-22","3","1","2025","6","6","3","Annual Examination 2025","1","0","2025-12-01");


-- Table structure for table `admit_card_exam_name_entry`
DROP TABLE IF EXISTS `admit_card_exam_name_entry`;
CREATE TABLE `admit_card_exam_name_entry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bangla` varchar(255) DEFAULT NULL,
  `english` varchar(255) DEFAULT NULL,
  `exam_center_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- Dumping data for table `admit_card_exam_name_entry`
INSERT INTO `admit_card_exam_name_entry` (`id`, `bangla`, `english`, `exam_center_name`) VALUES("2","প্রথম সাময়িক পরীক্ষা/২০২৪","First Provisional Examination/2024","ঢাকা কলেজ,ঢাকা");
INSERT INTO `admit_card_exam_name_entry` (`id`, `bangla`, `english`, `exam_center_name`) VALUES("3","প্রথম","First Provisional ","আমার ওয়েব বাজার বিডি");
INSERT INTO `admit_card_exam_name_entry` (`id`, `bangla`, `english`, `exam_center_name`) VALUES("4","","","");
INSERT INTO `admit_card_exam_name_entry` (`id`, `bangla`, `english`, `exam_center_name`) VALUES("5","","","");


-- Table structure for table `admit_id_card_template`
DROP TABLE IF EXISTS `admit_id_card_template`;
CREATE TABLE `admit_id_card_template` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `card_image` varchar(250) DEFAULT NULL,
  `card_no` int(20) DEFAULT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  `file_name` varchar(250) DEFAULT '0',
  `css_file_name` varchar(250) NOT NULL DEFAULT '0',
  `active_status` int(12) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

-- Dumping data for table `admit_id_card_template`
INSERT INTO `admit_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("1","image/template_1733536512_1.admit_card_english_1.png","1","1","0","0","0");
INSERT INTO `admit_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("2","image/template_1728004523_2.admit_card_bangla_2.png","2","1","0","0","0");
INSERT INTO `admit_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("3","image/template_1728004969_3.admit_card_bangla_3.png","3","1","0","0","0");
INSERT INTO `admit_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("4","image/template_1704964506_admit_card_english_4.png","4","1","0","0","0");
INSERT INTO `admit_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("7","image/template_1733499117_5.admit_card_bangla_5.png","5","1","0","0","0");
INSERT INTO `admit_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("8","image/template_1728004969_3.admit_card_bangla_3.png","6","1","0","0","0");
INSERT INTO `admit_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("9","image/template_1753327506_admit-cardB.png","7","1","0","0","1");
INSERT INTO `admit_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("10","image/template_1753327465_admit-cardE.png","8","1","0","0","0");


-- Table structure for table `all_jakat`
DROP TABLE IF EXISTS `all_jakat`;
CREATE TABLE `all_jakat` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `details` varchar(250) NOT NULL,
  `create_date` varchar(100) NOT NULL,
  `total_amount` int(20) NOT NULL,
  `amount_status` varchar(100) DEFAULT NULL,
  `d_status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `all_jakat`


-- Table structure for table `all_tax`
DROP TABLE IF EXISTS `all_tax`;
CREATE TABLE `all_tax` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `percent` int(10) NOT NULL,
  `details` varchar(250) DEFAULT NULL,
  `create_date` varchar(100) NOT NULL,
  `total_amount` int(20) NOT NULL,
  `amount_status` varchar(100) DEFAULT NULL,
  `d_status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `all_tax`


-- Table structure for table `api`
DROP TABLE IF EXISTS `api`;
CREATE TABLE `api` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `institute_name` varchar(250) DEFAULT NULL,
  `api_key` varchar(250) NOT NULL,
  `api_auth` varchar(250) NOT NULL,
  `domain` varchar(250) DEFAULT NULL,
  `user_id` int(20) NOT NULL,
  `expire_date` varchar(250) NOT NULL,
  `status` varchar(250) NOT NULL DEFAULT 'on',
  `device_serial_key` varchar(250) NOT NULL,
  `default_request` varchar(250) NOT NULL DEFAULT 'localhost',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `api`


-- Table structure for table `api_dashboards`
DROP TABLE IF EXISTS `api_dashboards`;
CREATE TABLE `api_dashboards` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `api_key` varchar(250) NOT NULL,
  `api_auth` varchar(250) NOT NULL,
  `last_update` varchar(250) NOT NULL,
  `balance` int(20) NOT NULL DEFAULT 0,
  `email_status` int(10) NOT NULL,
  `expire_date` varchar(250) NOT NULL,
  `status` int(10) NOT NULL DEFAULT 0,
  `user_name` varchar(250) NOT NULL,
  `user_email` varchar(250) NOT NULL,
  `user_mobile` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `api_dashboards`


-- Table structure for table `applications_type_v3`
DROP TABLE IF EXISTS `applications_type_v3`;
CREATE TABLE `applications_type_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) NOT NULL,
  `details` text NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `applications_type_v3`
INSERT INTO `applications_type_v3` (`id`, `name`, `details`, `date`) VALUES("1","Sick leave","sick leave","2025-01-06 08:28:19");
INSERT INTO `applications_type_v3` (`id`, `name`, `details`, `date`) VALUES("2","Tour leave","Tour leave","2025-01-06 08:28:32");
INSERT INTO `applications_type_v3` (`id`, `name`, `details`, `date`) VALUES("3","Others","Others","2025-01-06 08:28:40");
INSERT INTO `applications_type_v3` (`id`, `name`, `details`, `date`) VALUES("4","Family Problem","Family Problem","2025-01-06 08:31:13");


-- Table structure for table `attendance`
DROP TABLE IF EXISTS `attendance`;
CREATE TABLE `attendance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_std` int(11) DEFAULT NULL,
  `year` int(11) DEFAULT NULL,
  `class_std` int(11) DEFAULT NULL,
  `subject` int(11) DEFAULT NULL,
  `shift_id` int(11) DEFAULT NULL,
  `atten_date` varchar(255) DEFAULT NULL,
  `std_id` varchar(11) NOT NULL,
  `std_time` int(11) NOT NULL,
  `present_status` int(11) DEFAULT NULL COMMENT '1=present, 0= Absent, 2=Unkonw',
  `teacher_id` varchar(100) DEFAULT NULL,
  `is_full_day` int(11) DEFAULT NULL,
  `admin_id` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=889 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `attendance`
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("246","1","2025","1",NULL,"3","2025-06-03","20252011","1749137370","1",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("247","1","2025","1",NULL,"3","2025-06-03","20252012","1749137370","3",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("248","1","2025","1",NULL,"3","2025-06-03","20252013","1749137370","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("249","1","2025","1",NULL,"3","2025-06-03","20252014","1748958831","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("250","1","2025","1",NULL,"3","2025-06-03","20252015","1748958831","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("251","1","2025","1","51","3","2025-06-03","20252011","1748964540","3",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("252","1","2025","1","51","3","2025-06-03","20252012","1748964540","1",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("253","1","2025","1","51","3","2025-06-03","20252013","1748964540","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("254","1","2025","1","51","3","2025-06-03","20252014","1748964540","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("255","1","2025","1","51","3","2025-06-03","20252015","1748964540","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("256","1","2025","1",NULL,"3","2025-06-04","20252011","1749056484","3",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("257","1","2025","1",NULL,"3","2025-06-04","20252012","1749056484","3",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("258","1","2025","1",NULL,"3","2025-06-04","20252013","1749056484","3",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("259","1","2025","1",NULL,"3","2025-06-04","20252014","1749024238","1",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("260","1","2025","1",NULL,"3","2025-06-04","20252015","1749024238","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("261","1","2025","1","51","3","2025-06-04","20252011","1749024081","1",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("262","1","2025","1","51","3","2025-06-04","20252012","1749024081","3",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("263","1","2025","1","51","3","2025-06-04","20252013","1749024081","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("264","1","2025","1","51","3","2025-06-04","20252014","1749024081","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("265","1","2025","1","51","3","2025-06-04","20252015","1749024081","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("266","1","2025","1","51","5","2025-06-04","20252011","1749024094","1",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("267","1","2025","1","51","5","2025-06-04","20252012","1749024094","1",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("268","1","2025","1","51","5","2025-06-04","20252013","1749024094","3",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("269","1","2025","1","51","5","2025-06-04","20252014","1749024094","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("270","1","2025","1","51","5","2025-06-04","20252015","1749024094","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("271","1","2025","1",NULL,"5","2025-06-04","20252011","1749024241","1",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("272","1","2025","1",NULL,"5","2025-06-04","20252012","1749024241","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("273","1","2025","1",NULL,"5","2025-06-04","20252013","1749024241","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("274","1","2025","1",NULL,"5","2025-06-04","20252014","1749024241","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("275","1","2025","1",NULL,"5","2025-06-04","20252015","1749024241","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("276","1","2025","1","55","3","2025-06-04","20252011","1749061448","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("277","1","2025","1","55","3","2025-06-04","20252012","1749061448","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("278","1","2025","1","55","3","2025-06-04","20252013","1749061448","3",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("279","1","2025","1",NULL,"5","2025-06-03","20252011","1749137846","3",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("280","1","2025","1",NULL,"5","2025-06-03","20252012","1749137846","1",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("281","1","2025","1",NULL,"5","2025-06-03","20252013","1749137846","1",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("282","1","2025","1",NULL,"3","2025-06-06","20252012","1749213477","1",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("283","1","2025","1",NULL,"3","2025-06-06","20252013","1749213477","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("284","1","2025","1",NULL,"5","2025-06-06","20252012","1749212322","1",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("285","1","2025","1",NULL,"5","2025-06-06","20252013","1749212322","1",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("286","1","2025","1","51","5","2025-06-06","20252012","1749212378","1",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("287","1","2025","1","51","5","2025-06-06","20252013","1749212378","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("288","1","2025","1",NULL,"3","2025-06-10","20252012","1749432173","1",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("289","1","2025","1",NULL,"3","2025-06-10","20252013","1749432173","3",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("290","1","2025","1","51","3","2025-06-10","20252012","1749432180","1",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("291","1","2025","1","51","3","2025-06-10","20252013","1749432180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("292","1","2025","1",NULL,"5","2025-06-11","20252011","1749471204","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("293","1","2025","1",NULL,"5","2025-06-11","20252012","1749471204","1",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("294","1","2025","1",NULL,"5","2025-06-11","20252013","1749471204","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("295","1","2025","1",NULL,"3","2025-06-11","20252011","1749472135","1",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("296","1","2025","1",NULL,"3","2025-06-11","20252012","1749472135","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("297","1","2025","1",NULL,"3","2025-06-11","20252013","1749472135","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("298","1","2025","1",NULL,"3","2025-07-28","1","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("299","1","2025","1",NULL,"3","2025-07-28","3","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("300","1","2025","1",NULL,"3","2025-07-28","4","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("301","1","2025","1",NULL,"3","2025-07-28","5","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("302","1","2025","1",NULL,"3","2025-07-28","6","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("303","1","2025","1",NULL,"3","2025-07-28","8","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("304","1","2025","1",NULL,"3","2025-07-28","7","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("305","1","2025","1",NULL,"3","2025-07-28","9","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("306","1","2025","1",NULL,"3","2025-07-28","10","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("307","1","2025","1",NULL,"3","2025-07-28","11","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("308","1","2025","1",NULL,"3","2025-07-28","16","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("309","1","2025","1",NULL,"3","2025-07-28","15","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("310","1","2025","1",NULL,"3","2025-07-28","14","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("311","1","2025","1",NULL,"3","2025-07-28","13","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("312","1","2025","1",NULL,"3","2025-07-28","12","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("313","1","2025","1",NULL,"3","2025-07-28","22","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("314","1","2025","1",NULL,"3","2025-07-28","21","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("315","1","2025","1",NULL,"3","2025-07-28","20","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("316","1","2025","1",NULL,"3","2025-07-28","19","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("317","1","2025","1",NULL,"3","2025-07-28","18","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("318","1","2025","1",NULL,"3","2025-07-28","17","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("319","1","2025","1",NULL,"3","2025-07-28","24","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("320","1","2025","1",NULL,"3","2025-07-28","23","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("321","1","2025","1",NULL,"3","2025-07-28","30","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("322","1","2025","1",NULL,"3","2025-07-28","29","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("323","1","2025","1",NULL,"3","2025-07-28","28","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("324","1","2025","1",NULL,"3","2025-07-28","27","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("325","1","2025","1",NULL,"3","2025-07-28","26","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("326","1","2025","1",NULL,"3","2025-07-28","25","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("327","1","2025","1",NULL,"3","2025-07-28","38","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("328","1","2025","1",NULL,"3","2025-07-28","37","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("329","1","2025","1",NULL,"3","2025-07-28","36","1753641337","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("330","1","2025","7","170","3","2025-07-30","44","1753882631","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("331","1","2025","7","170","3","2025-07-30","43","1753882631","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("332","1","2025","7","170","3","2025-07-30","42","1753882631","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("333","1","2025","7","170","3","2025-07-30","41","1753882631","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("334","1","2025","3",NULL,"3","2025-07-31","73","1753978940","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("335","1","2025","3",NULL,"3","2025-07-31","72","1753978940","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("336","1","2025","3",NULL,"3","2025-07-31","71","1753978940","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("337","1","2025","3",NULL,"3","2025-07-31","70","1753978940","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("338","1","2025","3",NULL,"3","2025-07-31","74","1753978940","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("339","1","2025","3",NULL,"3","2025-07-31","75","1753978940","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("340","1","2025","1","119","3","2025-07-31","1","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("341","1","2025","1","119","3","2025-07-31","3","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("342","1","2025","1","119","3","2025-07-31","4","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("343","1","2025","1","119","3","2025-07-31","5","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("344","1","2025","1","119","3","2025-07-31","6","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("345","1","2025","1","119","3","2025-07-31","8","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("346","1","2025","1","119","3","2025-07-31","7","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("347","1","2025","1","119","3","2025-07-31","9","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("348","1","2025","1","119","3","2025-07-31","10","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("349","1","2025","1","119","3","2025-07-31","11","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("350","1","2025","1","119","3","2025-07-31","16","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("351","1","2025","1","119","3","2025-07-31","15","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("352","1","2025","1","119","3","2025-07-31","14","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("353","1","2025","1","119","3","2025-07-31","13","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("354","1","2025","1","119","3","2025-07-31","12","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("355","1","2025","1","119","3","2025-07-31","22","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("356","1","2025","1","119","3","2025-07-31","21","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("357","1","2025","1","119","3","2025-07-31","20","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("358","1","2025","1","119","3","2025-07-31","19","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("359","1","2025","1","119","3","2025-07-31","18","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("360","1","2025","1","119","3","2025-07-31","17","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("361","1","2025","1","119","3","2025-07-31","24","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("362","1","2025","1","119","3","2025-07-31","23","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("363","1","2025","1","119","3","2025-07-31","30","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("364","1","2025","1","119","3","2025-07-31","29","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("365","1","2025","1","119","3","2025-07-31","28","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("366","1","2025","1","119","3","2025-07-31","27","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("367","1","2025","1","119","3","2025-07-31","26","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("368","1","2025","1","119","3","2025-07-31","25","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("369","1","2025","1","119","3","2025-07-31","38","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("370","1","2025","1","119","3","2025-07-31","37","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("371","1","2025","1","119","3","2025-07-31","36","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("372","1","2025","1","119","3","2025-07-31","20251001","1753979350","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("373","1","2025","7","170","3","2025-08-02","44","1754046346","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("374","1","2025","7","170","3","2025-08-02","43","1754046346","3",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("375","1","2025","7","170","3","2025-08-02","42","1754046346","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("376","1","2025","7","170","3","2025-08-02","41","1754046346","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("377","1","2025","1",NULL,"3","2025-08-03","1","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("378","1","2025","1",NULL,"3","2025-08-03","3","1754197775","1",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("379","1","2025","1",NULL,"3","2025-08-03","4","1754197775","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("380","1","2025","1",NULL,"3","2025-08-03","5","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("381","1","2025","1",NULL,"3","2025-08-03","6","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("382","1","2025","1",NULL,"3","2025-08-03","8","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("383","1","2025","1",NULL,"3","2025-08-03","7","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("384","1","2025","1",NULL,"3","2025-08-03","9","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("385","1","2025","1",NULL,"3","2025-08-03","10","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("386","1","2025","1",NULL,"3","2025-08-03","11","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("387","1","2025","1",NULL,"3","2025-08-03","16","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("388","1","2025","1",NULL,"3","2025-08-03","15","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("389","1","2025","1",NULL,"3","2025-08-03","14","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("390","1","2025","1",NULL,"3","2025-08-03","13","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("391","1","2025","1",NULL,"3","2025-08-03","12","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("392","1","2025","1",NULL,"3","2025-08-03","22","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("393","1","2025","1",NULL,"3","2025-08-03","21","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("394","1","2025","1",NULL,"3","2025-08-03","20","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("395","1","2025","1",NULL,"3","2025-08-03","19","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("396","1","2025","1",NULL,"3","2025-08-03","18","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("397","1","2025","1",NULL,"3","2025-08-03","17","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("398","1","2025","1",NULL,"3","2025-08-03","24","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("399","1","2025","1",NULL,"3","2025-08-03","23","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("400","1","2025","1",NULL,"3","2025-08-03","30","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("401","1","2025","1",NULL,"3","2025-08-03","29","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("402","1","2025","1",NULL,"3","2025-08-03","28","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("403","1","2025","1",NULL,"3","2025-08-03","27","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("404","1","2025","1",NULL,"3","2025-08-03","26","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("405","1","2025","1",NULL,"3","2025-08-03","25","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("406","1","2025","1",NULL,"3","2025-08-03","38","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("407","1","2025","1",NULL,"3","2025-08-03","37","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("408","1","2025","1",NULL,"3","2025-08-03","36","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("409","1","2025","1",NULL,"3","2025-08-03","80","1754197732","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("410","1","2025","1",NULL,"3","2025-08-03","32","1754197775","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("411","1","2025","1",NULL,"3","2025-08-03","42","1754197775","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("412","1","2025","1",NULL,"3","2025-08-03","48","1754197775","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("413","1","2025","1",NULL,"3","2025-08-03","60","1754197775","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("414","1","2025","1",NULL,"3","2025-08-03","71","1754197775","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("415","1","2025","2","122","3","2025-08-03","50","1754201550","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("416","1","2025","2","122","3","2025-08-03","49","1754201550","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("417","1","2025","2","122","3","2025-08-03","48","1754201550","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("418","1","2025","2","122","3","2025-08-03","47","1754201550","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("419","1","2025","2","122","3","2025-08-03","46","1754201550","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("420","1","2025","2","122","3","2025-08-03","45","1754201550","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("421","1","2025","2","122","3","2025-08-03","51","1754201550","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("422","1","2025","2","122","3","2025-08-03","57","1754201550","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("423","1","2025","2","122","3","2025-08-03","56","1754201550","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("424","1","2025","2","122","3","2025-08-03","55","1754201550","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("425","1","2025","2","122","3","2025-08-03","54","1754201550","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("426","1","2025","2","122","3","2025-08-03","53","1754201550","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("427","1","2025","2","122","3","2025-08-03","52","1754201550","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("428","1","2025","2","123","3","2025-08-03","50","1754201698","1",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("429","1","2025","2","123","3","2025-08-03","49","1754201698","1",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("430","1","2025","2","123","3","2025-08-03","48","1754201698","1",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("431","1","2025","2","123","3","2025-08-03","47","1754201698","1",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("432","1","2025","2","123","3","2025-08-03","46","1754201698","1",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("433","1","2025","2","123","3","2025-08-03","45","1754201698","1",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("434","1","2025","2","123","3","2025-08-03","51","1754201698","1",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("435","1","2025","2","123","3","2025-08-03","57","1754201698","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("436","1","2025","2","123","3","2025-08-03","56","1754201698","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("437","1","2025","2","123","3","2025-08-03","55","1754201698","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("438","1","2025","2","123","3","2025-08-03","54","1754201698","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("439","1","2025","2","123","3","2025-08-03","53","1754201698","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("440","1","2025","2","123","3","2025-08-03","52","1754201698","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("441","1","2025","7","170","3","2025-08-03","44","1754214132","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("442","1","2025","7","170","3","2025-08-03","43","1754214132","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("443","1","2025","7","170","3","2025-08-03","42","1754214132","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("444","1","2025","7","170","3","2025-08-03","41","1754214132","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("445","1","2025","1","120","3","2025-08-05","1","1754382057","1",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("446","1","2025","1","120","3","2025-08-05","3","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("447","1","2025","1","120","3","2025-08-05","4","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("448","1","2025","1","120","3","2025-08-05","5","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("449","1","2025","1","120","3","2025-08-05","6","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("450","1","2025","1","120","3","2025-08-05","8","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("451","1","2025","1","120","3","2025-08-05","7","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("452","1","2025","1","120","3","2025-08-05","9","1754382057","3",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("453","1","2025","1","120","3","2025-08-05","10","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("454","1","2025","1","120","3","2025-08-05","11","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("455","1","2025","1","120","3","2025-08-05","16","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("456","1","2025","1","120","3","2025-08-05","15","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("457","1","2025","1","120","3","2025-08-05","14","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("458","1","2025","1","120","3","2025-08-05","13","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("459","1","2025","1","120","3","2025-08-05","12","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("460","1","2025","1","120","3","2025-08-05","22","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("461","1","2025","1","120","3","2025-08-05","21","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("462","1","2025","1","120","3","2025-08-05","20","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("463","1","2025","1","120","3","2025-08-05","19","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("464","1","2025","1","120","3","2025-08-05","18","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("465","1","2025","1","120","3","2025-08-05","17","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("466","1","2025","1","120","3","2025-08-05","24","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("467","1","2025","1","120","3","2025-08-05","23","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("468","1","2025","1","120","3","2025-08-05","30","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("469","1","2025","1","120","3","2025-08-05","29","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("470","1","2025","1","120","3","2025-08-05","28","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("471","1","2025","1","120","3","2025-08-05","27","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("472","1","2025","1","120","3","2025-08-05","26","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("473","1","2025","1","120","3","2025-08-05","25","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("474","1","2025","1","120","3","2025-08-05","38","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("475","1","2025","1","120","3","2025-08-05","37","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("476","1","2025","1","120","3","2025-08-05","36","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("477","1","2025","1","120","3","2025-08-05","80","1754382057","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("478","1","2025","7","170","3","2025-08-05","44","1754391224","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("479","1","2025","7","170","3","2025-08-05","43","1754391224","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("480","1","2025","7","170","3","2025-08-05","42","1754391224","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("481","1","2025","7","170","3","2025-08-05","41","1754391224","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("482","1","2025","1",NULL,"3","2025-08-14","1","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("483","1","2025","1",NULL,"3","2025-08-14","3","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("484","1","2025","1",NULL,"3","2025-08-14","4","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("485","1","2025","1",NULL,"3","2025-08-14","5","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("486","1","2025","1",NULL,"3","2025-08-14","6","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("487","1","2025","1",NULL,"3","2025-08-14","8","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("488","1","2025","1",NULL,"3","2025-08-14","7","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("489","1","2025","1",NULL,"3","2025-08-14","9","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("490","1","2025","1",NULL,"3","2025-08-14","10","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("491","1","2025","1",NULL,"3","2025-08-14","11","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("492","1","2025","1",NULL,"3","2025-08-14","16","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("493","1","2025","1",NULL,"3","2025-08-14","15","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("494","1","2025","1",NULL,"3","2025-08-14","14","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("495","1","2025","1",NULL,"3","2025-08-14","13","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("496","1","2025","1",NULL,"3","2025-08-14","12","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("497","1","2025","1",NULL,"3","2025-08-14","22","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("498","1","2025","1",NULL,"3","2025-08-14","21","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("499","1","2025","1",NULL,"3","2025-08-14","20","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("500","1","2025","1",NULL,"3","2025-08-14","19","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("501","1","2025","1",NULL,"3","2025-08-14","18","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("502","1","2025","1",NULL,"3","2025-08-14","17","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("503","1","2025","1",NULL,"3","2025-08-14","24","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("504","1","2025","1",NULL,"3","2025-08-14","23","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("505","1","2025","1",NULL,"3","2025-08-14","30","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("506","1","2025","1",NULL,"3","2025-08-14","29","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("507","1","2025","1",NULL,"3","2025-08-14","28","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("508","1","2025","1",NULL,"3","2025-08-14","27","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("509","1","2025","1",NULL,"3","2025-08-14","26","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("510","1","2025","1",NULL,"3","2025-08-14","25","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("511","1","2025","1",NULL,"3","2025-08-14","38","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("512","1","2025","1",NULL,"3","2025-08-14","37","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("513","1","2025","1",NULL,"3","2025-08-14","36","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("514","1","2025","1",NULL,"3","2025-08-14","80","1755279799","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("515","1","2025","7","170","3","2025-08-23","44","1755937291","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("516","1","2025","7","170","3","2025-08-23","43","1755937291","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("517","1","2025","7","170","3","2025-08-23","42","1755937291","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("518","1","2025","7","170","3","2025-08-23","41","1755937291","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("519","1","2025","7",NULL,"3","2025-08-23","44","1755939542","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("520","1","2025","7",NULL,"3","2025-08-23","43","1755939542","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("521","1","2025","7",NULL,"3","2025-08-23","42","1755939542","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("522","1","2025","7",NULL,"3","2025-08-23","41","1755939542","2",NULL,"1","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("523","1","2025","1","119","3","2025-01-01","1","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("524","1","2025","1","119","3","2025-01-01","3","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("525","1","2025","1","119","3","2025-01-01","4","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("526","1","2025","1","119","3","2025-01-01","5","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("527","1","2025","1","119","3","2025-01-01","6","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("528","1","2025","1","119","3","2025-01-01","8","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("529","1","2025","1","119","3","2025-01-01","7","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("530","1","2025","1","119","3","2025-01-01","9","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("531","1","2025","1","119","3","2025-01-01","10","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("532","1","2025","1","119","3","2025-01-01","11","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("533","1","2025","1","119","3","2025-01-01","16","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("534","1","2025","1","119","3","2025-01-01","15","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("535","1","2025","1","119","3","2025-01-01","14","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("536","1","2025","1","119","3","2025-01-01","13","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("537","1","2025","1","119","3","2025-01-01","12","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("538","1","2025","1","119","3","2025-01-01","22","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("539","1","2025","1","119","3","2025-01-01","21","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("540","1","2025","1","119","3","2025-01-01","20","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("541","1","2025","1","119","3","2025-01-01","19","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("542","1","2025","1","119","3","2025-01-01","18","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("543","1","2025","1","119","3","2025-01-01","17","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("544","1","2025","1","119","3","2025-01-01","24","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("545","1","2025","1","119","3","2025-01-01","23","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("546","1","2025","1","119","3","2025-01-01","30","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("547","1","2025","1","119","3","2025-01-01","29","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("548","1","2025","1","119","3","2025-01-01","28","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("549","1","2025","1","119","3","2025-01-01","27","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("550","1","2025","1","119","3","2025-01-01","26","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("551","1","2025","1","119","3","2025-01-01","25","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("552","1","2025","1","119","3","2025-01-01","38","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("553","1","2025","1","119","3","2025-01-01","37","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("554","1","2025","1","119","3","2025-01-01","36","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("555","1","2025","1","119","3","2025-01-01","80","1761841103","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("556","1","2025","1","119","3","2025-01-02","1","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("557","1","2025","1","119","3","2025-01-02","3","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("558","1","2025","1","119","3","2025-01-02","4","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("559","1","2025","1","119","3","2025-01-02","5","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("560","1","2025","1","119","3","2025-01-02","6","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("561","1","2025","1","119","3","2025-01-02","8","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("562","1","2025","1","119","3","2025-01-02","7","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("563","1","2025","1","119","3","2025-01-02","9","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("564","1","2025","1","119","3","2025-01-02","10","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("565","1","2025","1","119","3","2025-01-02","11","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("566","1","2025","1","119","3","2025-01-02","16","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("567","1","2025","1","119","3","2025-01-02","15","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("568","1","2025","1","119","3","2025-01-02","14","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("569","1","2025","1","119","3","2025-01-02","13","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("570","1","2025","1","119","3","2025-01-02","12","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("571","1","2025","1","119","3","2025-01-02","22","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("572","1","2025","1","119","3","2025-01-02","21","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("573","1","2025","1","119","3","2025-01-02","20","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("574","1","2025","1","119","3","2025-01-02","19","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("575","1","2025","1","119","3","2025-01-02","18","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("576","1","2025","1","119","3","2025-01-02","17","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("577","1","2025","1","119","3","2025-01-02","24","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("578","1","2025","1","119","3","2025-01-02","23","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("579","1","2025","1","119","3","2025-01-02","30","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("580","1","2025","1","119","3","2025-01-02","29","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("581","1","2025","1","119","3","2025-01-02","28","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("582","1","2025","1","119","3","2025-01-02","27","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("583","1","2025","1","119","3","2025-01-02","26","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("584","1","2025","1","119","3","2025-01-02","25","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("585","1","2025","1","119","3","2025-01-02","38","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("586","1","2025","1","119","3","2025-01-02","37","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("587","1","2025","1","119","3","2025-01-02","36","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("588","1","2025","1","119","3","2025-01-02","80","1761841118","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("589","1","2025","1","119","3","2025-01-04","1","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("590","1","2025","1","119","3","2025-01-04","3","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("591","1","2025","1","119","3","2025-01-04","4","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("592","1","2025","1","119","3","2025-01-04","5","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("593","1","2025","1","119","3","2025-01-04","6","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("594","1","2025","1","119","3","2025-01-04","8","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("595","1","2025","1","119","3","2025-01-04","7","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("596","1","2025","1","119","3","2025-01-04","9","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("597","1","2025","1","119","3","2025-01-04","10","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("598","1","2025","1","119","3","2025-01-04","11","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("599","1","2025","1","119","3","2025-01-04","16","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("600","1","2025","1","119","3","2025-01-04","15","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("601","1","2025","1","119","3","2025-01-04","14","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("602","1","2025","1","119","3","2025-01-04","13","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("603","1","2025","1","119","3","2025-01-04","12","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("604","1","2025","1","119","3","2025-01-04","22","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("605","1","2025","1","119","3","2025-01-04","21","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("606","1","2025","1","119","3","2025-01-04","20","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("607","1","2025","1","119","3","2025-01-04","19","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("608","1","2025","1","119","3","2025-01-04","18","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("609","1","2025","1","119","3","2025-01-04","17","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("610","1","2025","1","119","3","2025-01-04","24","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("611","1","2025","1","119","3","2025-01-04","23","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("612","1","2025","1","119","3","2025-01-04","30","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("613","1","2025","1","119","3","2025-01-04","29","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("614","1","2025","1","119","3","2025-01-04","28","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("615","1","2025","1","119","3","2025-01-04","27","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("616","1","2025","1","119","3","2025-01-04","26","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("617","1","2025","1","119","3","2025-01-04","25","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("618","1","2025","1","119","3","2025-01-04","38","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("619","1","2025","1","119","3","2025-01-04","37","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("620","1","2025","1","119","3","2025-01-04","36","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("621","1","2025","1","119","3","2025-01-04","80","1761841145","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("622","1","2025","1","119","3","2025-01-05","1","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("623","1","2025","1","119","3","2025-01-05","3","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("624","1","2025","1","119","3","2025-01-05","4","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("625","1","2025","1","119","3","2025-01-05","5","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("626","1","2025","1","119","3","2025-01-05","6","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("627","1","2025","1","119","3","2025-01-05","8","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("628","1","2025","1","119","3","2025-01-05","7","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("629","1","2025","1","119","3","2025-01-05","9","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("630","1","2025","1","119","3","2025-01-05","10","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("631","1","2025","1","119","3","2025-01-05","11","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("632","1","2025","1","119","3","2025-01-05","16","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("633","1","2025","1","119","3","2025-01-05","15","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("634","1","2025","1","119","3","2025-01-05","14","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("635","1","2025","1","119","3","2025-01-05","13","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("636","1","2025","1","119","3","2025-01-05","12","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("637","1","2025","1","119","3","2025-01-05","22","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("638","1","2025","1","119","3","2025-01-05","21","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("639","1","2025","1","119","3","2025-01-05","20","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("640","1","2025","1","119","3","2025-01-05","19","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("641","1","2025","1","119","3","2025-01-05","18","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("642","1","2025","1","119","3","2025-01-05","17","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("643","1","2025","1","119","3","2025-01-05","24","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("644","1","2025","1","119","3","2025-01-05","23","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("645","1","2025","1","119","3","2025-01-05","30","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("646","1","2025","1","119","3","2025-01-05","29","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("647","1","2025","1","119","3","2025-01-05","28","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("648","1","2025","1","119","3","2025-01-05","27","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("649","1","2025","1","119","3","2025-01-05","26","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("650","1","2025","1","119","3","2025-01-05","25","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("651","1","2025","1","119","3","2025-01-05","38","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("652","1","2025","1","119","3","2025-01-05","37","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("653","1","2025","1","119","3","2025-01-05","36","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("654","1","2025","1","119","3","2025-01-05","80","1761841163","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("655","1","2025","1","119","3","2025-01-06","1","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("656","1","2025","1","119","3","2025-01-06","3","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("657","1","2025","1","119","3","2025-01-06","4","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("658","1","2025","1","119","3","2025-01-06","5","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("659","1","2025","1","119","3","2025-01-06","6","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("660","1","2025","1","119","3","2025-01-06","8","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("661","1","2025","1","119","3","2025-01-06","7","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("662","1","2025","1","119","3","2025-01-06","9","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("663","1","2025","1","119","3","2025-01-06","10","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("664","1","2025","1","119","3","2025-01-06","11","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("665","1","2025","1","119","3","2025-01-06","16","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("666","1","2025","1","119","3","2025-01-06","15","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("667","1","2025","1","119","3","2025-01-06","14","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("668","1","2025","1","119","3","2025-01-06","13","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("669","1","2025","1","119","3","2025-01-06","12","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("670","1","2025","1","119","3","2025-01-06","22","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("671","1","2025","1","119","3","2025-01-06","21","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("672","1","2025","1","119","3","2025-01-06","20","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("673","1","2025","1","119","3","2025-01-06","19","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("674","1","2025","1","119","3","2025-01-06","18","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("675","1","2025","1","119","3","2025-01-06","17","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("676","1","2025","1","119","3","2025-01-06","24","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("677","1","2025","1","119","3","2025-01-06","23","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("678","1","2025","1","119","3","2025-01-06","30","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("679","1","2025","1","119","3","2025-01-06","29","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("680","1","2025","1","119","3","2025-01-06","28","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("681","1","2025","1","119","3","2025-01-06","27","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("682","1","2025","1","119","3","2025-01-06","26","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("683","1","2025","1","119","3","2025-01-06","25","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("684","1","2025","1","119","3","2025-01-06","38","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("685","1","2025","1","119","3","2025-01-06","37","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("686","1","2025","1","119","3","2025-01-06","36","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("687","1","2025","1","119","3","2025-01-06","80","1761841180","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("688","1","2025","1","119","3","2025-01-07","1","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("689","1","2025","1","119","3","2025-01-07","3","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("690","1","2025","1","119","3","2025-01-07","4","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("691","1","2025","1","119","3","2025-01-07","5","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("692","1","2025","1","119","3","2025-01-07","6","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("693","1","2025","1","119","3","2025-01-07","8","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("694","1","2025","1","119","3","2025-01-07","7","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("695","1","2025","1","119","3","2025-01-07","9","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("696","1","2025","1","119","3","2025-01-07","10","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("697","1","2025","1","119","3","2025-01-07","11","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("698","1","2025","1","119","3","2025-01-07","16","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("699","1","2025","1","119","3","2025-01-07","15","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("700","1","2025","1","119","3","2025-01-07","14","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("701","1","2025","1","119","3","2025-01-07","13","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("702","1","2025","1","119","3","2025-01-07","12","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("703","1","2025","1","119","3","2025-01-07","22","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("704","1","2025","1","119","3","2025-01-07","21","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("705","1","2025","1","119","3","2025-01-07","20","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("706","1","2025","1","119","3","2025-01-07","19","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("707","1","2025","1","119","3","2025-01-07","18","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("708","1","2025","1","119","3","2025-01-07","17","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("709","1","2025","1","119","3","2025-01-07","24","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("710","1","2025","1","119","3","2025-01-07","23","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("711","1","2025","1","119","3","2025-01-07","30","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("712","1","2025","1","119","3","2025-01-07","29","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("713","1","2025","1","119","3","2025-01-07","28","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("714","1","2025","1","119","3","2025-01-07","27","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("715","1","2025","1","119","3","2025-01-07","26","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("716","1","2025","1","119","3","2025-01-07","25","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("717","1","2025","1","119","3","2025-01-07","38","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("718","1","2025","1","119","3","2025-01-07","37","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("719","1","2025","1","119","3","2025-01-07","36","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("720","1","2025","1","119","3","2025-01-07","80","1761841195","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("721","1","2025","1","119","3","2025-01-08","1","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("722","1","2025","1","119","3","2025-01-08","3","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("723","1","2025","1","119","3","2025-01-08","4","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("724","1","2025","1","119","3","2025-01-08","5","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("725","1","2025","1","119","3","2025-01-08","6","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("726","1","2025","1","119","3","2025-01-08","8","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("727","1","2025","1","119","3","2025-01-08","7","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("728","1","2025","1","119","3","2025-01-08","9","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("729","1","2025","1","119","3","2025-01-08","10","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("730","1","2025","1","119","3","2025-01-08","11","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("731","1","2025","1","119","3","2025-01-08","16","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("732","1","2025","1","119","3","2025-01-08","15","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("733","1","2025","1","119","3","2025-01-08","14","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("734","1","2025","1","119","3","2025-01-08","13","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("735","1","2025","1","119","3","2025-01-08","12","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("736","1","2025","1","119","3","2025-01-08","22","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("737","1","2025","1","119","3","2025-01-08","21","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("738","1","2025","1","119","3","2025-01-08","20","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("739","1","2025","1","119","3","2025-01-08","19","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("740","1","2025","1","119","3","2025-01-08","18","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("741","1","2025","1","119","3","2025-01-08","17","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("742","1","2025","1","119","3","2025-01-08","24","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("743","1","2025","1","119","3","2025-01-08","23","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("744","1","2025","1","119","3","2025-01-08","30","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("745","1","2025","1","119","3","2025-01-08","29","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("746","1","2025","1","119","3","2025-01-08","28","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("747","1","2025","1","119","3","2025-01-08","27","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("748","1","2025","1","119","3","2025-01-08","26","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("749","1","2025","1","119","3","2025-01-08","25","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("750","1","2025","1","119","3","2025-01-08","38","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("751","1","2025","1","119","3","2025-01-08","37","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("752","1","2025","1","119","3","2025-01-08","36","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("753","1","2025","1","119","3","2025-01-08","80","1761841212","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("754","1","2025","1","119","3","2025-01-09","1","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("755","1","2025","1","119","3","2025-01-09","3","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("756","1","2025","1","119","3","2025-01-09","4","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("757","1","2025","1","119","3","2025-01-09","5","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("758","1","2025","1","119","3","2025-01-09","6","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("759","1","2025","1","119","3","2025-01-09","8","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("760","1","2025","1","119","3","2025-01-09","7","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("761","1","2025","1","119","3","2025-01-09","9","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("762","1","2025","1","119","3","2025-01-09","10","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("763","1","2025","1","119","3","2025-01-09","11","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("764","1","2025","1","119","3","2025-01-09","16","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("765","1","2025","1","119","3","2025-01-09","15","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("766","1","2025","1","119","3","2025-01-09","14","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("767","1","2025","1","119","3","2025-01-09","13","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("768","1","2025","1","119","3","2025-01-09","12","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("769","1","2025","1","119","3","2025-01-09","22","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("770","1","2025","1","119","3","2025-01-09","21","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("771","1","2025","1","119","3","2025-01-09","20","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("772","1","2025","1","119","3","2025-01-09","19","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("773","1","2025","1","119","3","2025-01-09","18","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("774","1","2025","1","119","3","2025-01-09","17","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("775","1","2025","1","119","3","2025-01-09","24","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("776","1","2025","1","119","3","2025-01-09","23","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("777","1","2025","1","119","3","2025-01-09","30","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("778","1","2025","1","119","3","2025-01-09","29","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("779","1","2025","1","119","3","2025-01-09","28","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("780","1","2025","1","119","3","2025-01-09","27","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("781","1","2025","1","119","3","2025-01-09","26","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("782","1","2025","1","119","3","2025-01-09","25","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("783","1","2025","1","119","3","2025-01-09","38","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("784","1","2025","1","119","3","2025-01-09","37","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("785","1","2025","1","119","3","2025-01-09","36","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("786","1","2025","1","119","3","2025-01-09","80","1761841227","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("787","1","2025","1","119","3","2025-01-11","1","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("788","1","2025","1","119","3","2025-01-11","3","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("789","1","2025","1","119","3","2025-01-11","4","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("790","1","2025","1","119","3","2025-01-11","5","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("791","1","2025","1","119","3","2025-01-11","6","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("792","1","2025","1","119","3","2025-01-11","8","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("793","1","2025","1","119","3","2025-01-11","7","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("794","1","2025","1","119","3","2025-01-11","9","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("795","1","2025","1","119","3","2025-01-11","10","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("796","1","2025","1","119","3","2025-01-11","11","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("797","1","2025","1","119","3","2025-01-11","16","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("798","1","2025","1","119","3","2025-01-11","15","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("799","1","2025","1","119","3","2025-01-11","14","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("800","1","2025","1","119","3","2025-01-11","13","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("801","1","2025","1","119","3","2025-01-11","12","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("802","1","2025","1","119","3","2025-01-11","22","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("803","1","2025","1","119","3","2025-01-11","21","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("804","1","2025","1","119","3","2025-01-11","20","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("805","1","2025","1","119","3","2025-01-11","19","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("806","1","2025","1","119","3","2025-01-11","18","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("807","1","2025","1","119","3","2025-01-11","17","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("808","1","2025","1","119","3","2025-01-11","24","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("809","1","2025","1","119","3","2025-01-11","23","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("810","1","2025","1","119","3","2025-01-11","30","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("811","1","2025","1","119","3","2025-01-11","29","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("812","1","2025","1","119","3","2025-01-11","28","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("813","1","2025","1","119","3","2025-01-11","27","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("814","1","2025","1","119","3","2025-01-11","26","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("815","1","2025","1","119","3","2025-01-11","25","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("816","1","2025","1","119","3","2025-01-11","38","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("817","1","2025","1","119","3","2025-01-11","37","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("818","1","2025","1","119","3","2025-01-11","36","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("819","1","2025","1","119","3","2025-01-11","80","1761841239","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("820","1","2025","1","119","3","2025-01-12","1","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("821","1","2025","1","119","3","2025-01-12","3","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("822","1","2025","1","119","3","2025-01-12","4","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("823","1","2025","1","119","3","2025-01-12","5","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("824","1","2025","1","119","3","2025-01-12","6","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("825","1","2025","1","119","3","2025-01-12","8","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("826","1","2025","1","119","3","2025-01-12","7","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("827","1","2025","1","119","3","2025-01-12","9","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("828","1","2025","1","119","3","2025-01-12","10","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("829","1","2025","1","119","3","2025-01-12","11","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("830","1","2025","1","119","3","2025-01-12","16","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("831","1","2025","1","119","3","2025-01-12","15","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("832","1","2025","1","119","3","2025-01-12","14","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("833","1","2025","1","119","3","2025-01-12","13","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("834","1","2025","1","119","3","2025-01-12","12","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("835","1","2025","1","119","3","2025-01-12","22","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("836","1","2025","1","119","3","2025-01-12","21","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("837","1","2025","1","119","3","2025-01-12","20","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("838","1","2025","1","119","3","2025-01-12","19","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("839","1","2025","1","119","3","2025-01-12","18","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("840","1","2025","1","119","3","2025-01-12","17","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("841","1","2025","1","119","3","2025-01-12","24","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("842","1","2025","1","119","3","2025-01-12","23","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("843","1","2025","1","119","3","2025-01-12","30","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("844","1","2025","1","119","3","2025-01-12","29","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("845","1","2025","1","119","3","2025-01-12","28","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("846","1","2025","1","119","3","2025-01-12","27","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("847","1","2025","1","119","3","2025-01-12","26","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("848","1","2025","1","119","3","2025-01-12","25","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("849","1","2025","1","119","3","2025-01-12","38","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("850","1","2025","1","119","3","2025-01-12","37","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("851","1","2025","1","119","3","2025-01-12","36","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("852","1","2025","1","119","3","2025-01-12","80","1761841265","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("853","1","2025","1","119","3","2025-01-13","1","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("854","1","2025","1","119","3","2025-01-13","3","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("855","1","2025","1","119","3","2025-01-13","4","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("856","1","2025","1","119","3","2025-01-13","5","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("857","1","2025","1","119","3","2025-01-13","6","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("858","1","2025","1","119","3","2025-01-13","8","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("859","1","2025","1","119","3","2025-01-13","7","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("860","1","2025","1","119","3","2025-01-13","9","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("861","1","2025","1","119","3","2025-01-13","10","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("862","1","2025","1","119","3","2025-01-13","11","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("863","1","2025","1","119","3","2025-01-13","16","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("864","1","2025","1","119","3","2025-01-13","15","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("865","1","2025","1","119","3","2025-01-13","14","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("866","1","2025","1","119","3","2025-01-13","13","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("867","1","2025","1","119","3","2025-01-13","12","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("868","1","2025","1","119","3","2025-01-13","22","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("869","1","2025","1","119","3","2025-01-13","21","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("870","1","2025","1","119","3","2025-01-13","20","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("871","1","2025","1","119","3","2025-01-13","19","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("872","1","2025","1","119","3","2025-01-13","18","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("873","1","2025","1","119","3","2025-01-13","17","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("874","1","2025","1","119","3","2025-01-13","24","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("875","1","2025","1","119","3","2025-01-13","23","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("876","1","2025","1","119","3","2025-01-13","30","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("877","1","2025","1","119","3","2025-01-13","29","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("878","1","2025","1","119","3","2025-01-13","28","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("879","1","2025","1","119","3","2025-01-13","27","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("880","1","2025","1","119","3","2025-01-13","26","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("881","1","2025","1","119","3","2025-01-13","25","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("882","1","2025","1","119","3","2025-01-13","38","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("883","1","2025","1","119","3","2025-01-13","37","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("884","1","2025","1","119","3","2025-01-13","36","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("885","1","2025","1","119","3","2025-01-13","80","1761841278","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("886","1","2025","4","135","3","2025-11-16","2","1763308661","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("887","1","2025","4","135","3","2025-11-16","3","1763308661","2",NULL,"0","1");
INSERT INTO `attendance` (`id`, `group_std`, `year`, `class_std`, `subject`, `shift_id`, `atten_date`, `std_id`, `std_time`, `present_status`, `teacher_id`, `is_full_day`, `admin_id`) VALUES("888","1","2025","4","135","3","2025-11-16","72","1763308661","2",NULL,"0","1");


-- Table structure for table `attendance_custom_sms`
DROP TABLE IF EXISTS `attendance_custom_sms`;
CREATE TABLE `attendance_custom_sms` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `person_type` varchar(250) NOT NULL,
  `message_type` varchar(250) NOT NULL,
  `lan_type` varchar(250) NOT NULL,
  `message` varchar(250) NOT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `attendance_custom_sms`
INSERT INTO `attendance_custom_sms` (`id`, `person_type`, `message_type`, `lan_type`, `message`, `status`) VALUES("3","staff","present","en_bn","new message  ss","1");
INSERT INTO `attendance_custom_sms` (`id`, `person_type`, `message_type`, `lan_type`, `message`, `status`) VALUES("4","staff","late","en_bn","আমার সোনার বাংলা","1");
INSERT INTO `attendance_custom_sms` (`id`, `person_type`, `message_type`, `lan_type`, `message`, `status`) VALUES("5","staff","out","en_bn","আমার সোনার বাংলা student out","1");
INSERT INTO `attendance_custom_sms` (`id`, `person_type`, `message_type`, `lan_type`, `message`, `status`) VALUES("6","student","present","en_bn","প্রিয় অভিভাবক, আপনার সন্তান স্কুলে উপস্থিত হয়েছে। ","1");
INSERT INTO `attendance_custom_sms` (`id`, `person_type`, `message_type`, `lan_type`, `message`, `status`) VALUES("7","student","out","en_bn","প্রিয় অভিভাবক, আপনার সন্তান স্কুলে থেকে প্রস্থান করেছে।","1");


-- Table structure for table `attendance_history`
DROP TABLE IF EXISTS `attendance_history`;
CREATE TABLE `attendance_history` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `attendance_id` varchar(250) NOT NULL,
  `person_id` varchar(250) NOT NULL,
  `person_type` varchar(250) NOT NULL,
  `date_time` varchar(250) NOT NULL,
  `date` varchar(250) NOT NULL,
  `time` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=598333 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `attendance_history`
INSERT INTO `attendance_history` (`id`, `attendance_id`, `person_id`, `person_type`, `date_time`, `date`, `time`) VALUES("598332","955","172","student","2024-05-02T09:31:04","2024-05-02","09:31:04");


-- Table structure for table `attendance_holiday`
DROP TABLE IF EXISTS `attendance_holiday`;
CREATE TABLE `attendance_holiday` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `holiday_date` date NOT NULL,
  `holiday_type` enum('weekly','special') NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=245 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `attendance_holiday`
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("193","2025-01-03","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("194","2025-01-10","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("195","2025-01-17","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("196","2025-01-24","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("197","2025-01-31","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("198","2025-02-07","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("199","2025-02-14","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("200","2025-02-21","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("201","2025-02-28","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("202","2025-03-07","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("203","2025-03-14","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("204","2025-03-21","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("205","2025-03-28","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("206","2025-04-04","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("207","2025-04-11","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("208","2025-04-18","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("209","2025-04-25","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("210","2025-05-02","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("211","2025-05-09","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("212","2025-05-16","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("213","2025-05-23","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("214","2025-05-30","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("215","2025-06-06","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("216","2025-06-13","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("217","2025-06-20","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("218","2025-06-27","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("219","2025-07-04","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("220","2025-07-11","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("221","2025-07-18","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("222","2025-07-25","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("223","2025-08-01","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("224","2025-08-08","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("225","2025-08-15","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("226","2025-08-22","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("227","2025-08-29","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("228","2025-09-05","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("229","2025-09-12","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("230","2025-09-19","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("231","2025-09-26","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("232","2025-10-03","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("233","2025-10-10","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("234","2025-10-17","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("235","2025-10-24","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("236","2025-10-31","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("237","2025-11-07","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("238","2025-11-14","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("239","2025-11-21","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("240","2025-11-28","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("241","2025-12-05","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("242","2025-12-12","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("243","2025-12-19","weekly","2025-07-27 17:49:28");
INSERT INTO `attendance_holiday` (`id`, `holiday_date`, `holiday_type`, `created_at`) VALUES("244","2025-12-26","weekly","2025-07-27 17:49:28");


-- Table structure for table `attendance_holiday_student`
DROP TABLE IF EXISTS `attendance_holiday_student`;
CREATE TABLE `attendance_holiday_student` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` varchar(50) NOT NULL,
  `reason` text NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `attendance_holiday_student`
INSERT INTO `attendance_holiday_student` (`id`, `student_id`, `reason`, `start_date`, `end_date`, `created_at`) VALUES("7","20252011","20252011","2025-06-05","2025-06-10","2025-06-04 18:37:37");


-- Table structure for table `attendance_live_notice`
DROP TABLE IF EXISTS `attendance_live_notice`;
CREATE TABLE `attendance_live_notice` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `notice` varchar(250) NOT NULL,
  `date` varchar(250) DEFAULT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `attendance_live_notice`
INSERT INTO `attendance_live_notice` (`id`, `notice`, `date`, `status`) VALUES("7","শুভ উদ্বোধন ২০২৪  :: আপনারা দেখছেন ওয়েব বাজার বিডির ডিজিটাল হাজিরা মেশিন লাইভ সফটওয়্যার ডাসবোড......",NULL,"1");
INSERT INTO `attendance_live_notice` (`id`, `notice`, `date`, `status`) VALUES("8","শুভ উদ্বোধন ২০২৪ :: আপনারা দেখছেন ওয়েব বাজার বিডির ডিজিটাল হাজিরা মেশিন লাইভ সফটওয়্যার ডাসবোড......",NULL,"1");


-- Table structure for table `attendance_report`
DROP TABLE IF EXISTS `attendance_report`;
CREATE TABLE `attendance_report` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `history_id` varchar(250) NOT NULL,
  `person_id` varchar(250) NOT NULL,
  `person_type` varchar(250) NOT NULL,
  `date_time` varchar(250) NOT NULL,
  `date` varchar(250) NOT NULL,
  `time` varchar(250) NOT NULL,
  `in_out_status` varchar(250) NOT NULL,
  `sms_status` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `attendance_report`


-- Table structure for table `attendance_sms_config`
DROP TABLE IF EXISTS `attendance_sms_config`;
CREATE TABLE `attendance_sms_config` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(250) NOT NULL,
  `person_id` varchar(250) NOT NULL,
  `sms_status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `attendance_sms_config`
INSERT INTO `attendance_sms_config` (`id`, `type`, `person_id`, `sms_status`) VALUES("37","student","165","1");
INSERT INTO `attendance_sms_config` (`id`, `type`, `person_id`, `sms_status`) VALUES("40","student","169","0");
INSERT INTO `attendance_sms_config` (`id`, `type`, `person_id`, `sms_status`) VALUES("45","teacher","40","1");
INSERT INTO `attendance_sms_config` (`id`, `type`, `person_id`, `sms_status`) VALUES("46","teacher","48","1");
INSERT INTO `attendance_sms_config` (`id`, `type`, `person_id`, `sms_status`) VALUES("50","staff","11","1");
INSERT INTO `attendance_sms_config` (`id`, `type`, `person_id`, `sms_status`) VALUES("51","staff","12","1");
INSERT INTO `attendance_sms_config` (`id`, `type`, `person_id`, `sms_status`) VALUES("52","student","170","0");
INSERT INTO `attendance_sms_config` (`id`, `type`, `person_id`, `sms_status`) VALUES("53","student","171","0");
INSERT INTO `attendance_sms_config` (`id`, `type`, `person_id`, `sms_status`) VALUES("54","student","172","0");
INSERT INTO `attendance_sms_config` (`id`, `type`, `person_id`, `sms_status`) VALUES("55","student","173","0");
INSERT INTO `attendance_sms_config` (`id`, `type`, `person_id`, `sms_status`) VALUES("56","student","174","0");


-- Table structure for table `attendance_sms_log`
DROP TABLE IF EXISTS `attendance_sms_log`;
CREATE TABLE `attendance_sms_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `student_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `course` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `group` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `section` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `shift` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` date NOT NULL,
  `sms_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` enum('bn','en') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'bn',
  `sent_status` tinyint(1) NOT NULL DEFAULT 0,
  `error_message` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `date` (`date`),
  KEY `sent_status` (`sent_status`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `attendance_sms_log`
INSERT INTO `attendance_sms_log` (`id`, `student_id`, `student_name`, `contact`, `course`, `group`, `section`, `shift`, `status`, `date`, `sms_content`, `language`, `sent_status`, `error_message`, `created_at`) VALUES("1","","Md Ashraful Lton","01717452764","Play","General","A","Morning","Absent","2025-06-03","প্রিয় মেরিট , 2025-06-03 তারিখে আপনার উপস্থিতি: অনুপস্থিত। কোর্স: প্লে , গ্রুপ: সাধারন, সেকশন: এ, শিফট: সকাল। ইকরা মডেল একাডেমী","bn","1",NULL,"2025-06-05 22:46:05");
INSERT INTO `attendance_sms_log` (`id`, `student_id`, `student_name`, `contact`, `course`, `group`, `section`, `shift`, `status`, `date`, `sms_content`, `language`, `sent_status`, `error_message`, `created_at`) VALUES("2","","Md 22 Lton","01717452764","Play","General","A","Morning","Late","2025-06-03","প্রিয় মেরিট , 2025-06-03 তারিখে আপনার উপস্থিতি: বিলম্বিত। কোর্স: প্লে , গ্রুপ: সাধারন, সেকশন: এ, শিফট: সকাল। ইকরা মডেল একাডেমী","bn","1",NULL,"2025-06-05 22:46:05");
INSERT INTO `attendance_sms_log` (`id`, `student_id`, `student_name`, `contact`, `course`, `group`, `section`, `shift`, `status`, `date`, `sms_content`, `language`, `sent_status`, `error_message`, `created_at`) VALUES("3","20252011","Md Ashraful Lton","01717452764","Play","General","A","Morning","Absent","2025-06-03","প্রিয় মেরিট , 2025-06-03 তারিখে আপনার উপস্থিতি: অনুপস্থিত। কোর্স: প্লে , গ্রুপ: সাধারন, সেকশন: এ, শিফট: সকাল। ইকরা মডেল একাডেমী","bn","1",NULL,"2025-06-05 22:46:55");
INSERT INTO `attendance_sms_log` (`id`, `student_id`, `student_name`, `contact`, `course`, `group`, `section`, `shift`, `status`, `date`, `sms_content`, `language`, `sent_status`, `error_message`, `created_at`) VALUES("4","20252012","Md 22 Lton","01717452764","Play","General","A","Morning","Late","2025-06-03","প্রিয় মেরিট , 2025-06-03 তারিখে আপনার উপস্থিতি: বিলম্বিত। কোর্স: প্লে , গ্রুপ: সাধারন, সেকশন: এ, শিফট: সকাল। ইকরা মডেল একাডেমী","bn","1",NULL,"2025-06-05 22:46:55");
INSERT INTO `attendance_sms_log` (`id`, `student_id`, `student_name`, `contact`, `course`, `group`, `section`, `shift`, `status`, `date`, `sms_content`, `language`, `sent_status`, `error_message`, `created_at`) VALUES("5","20252012","Md 22 Lton","01717452764","Play","General","A","Morning","Absent","2025-06-06","প্রিয় মেরিট , ২০২৫২০১২, ০৬ জুন, ২০২৫ তারিখে আপনার উপস্থিতি: অনুপস্থিত। কোর্স: প্লে , গ্রুপ: সাধারন, সেকশন: এ, শিফট: সকাল। ইকরা মডেল একাডেমী","bn","1",NULL,"2025-06-06 18:00:36");
INSERT INTO `attendance_sms_log` (`id`, `student_id`, `student_name`, `contact`, `course`, `group`, `section`, `shift`, `status`, `date`, `sms_content`, `language`, `sent_status`, `error_message`, `created_at`) VALUES("6","20252013","Md 33 Lton","01717452764","Play","General","A","Morning","Present","2025-06-06","প্রিয় মেরিট , ২০২৫২০১৩, ০৬ জুন, ২০২৫ তারিখে আপনার উপস্থিতি: উপস্থিত। কোর্স: প্লে , গ্রুপ: সাধারন, সেকশন: এ, শিফট: সকাল। ইকরা মডেল একাডেমী","bn","1",NULL,"2025-06-06 18:00:36");
INSERT INTO `attendance_sms_log` (`id`, `student_id`, `student_name`, `contact`, `course`, `group`, `section`, `shift`, `status`, `date`, `sms_content`, `language`, `sent_status`, `error_message`, `created_at`) VALUES("7","20252011","Md Ashraful Lton","01717452764","Play","General","A","Morning","Absent","2025-06-11","প্রিয় মেরিট , ২০২৫২০১১, ১১ জুন, ২০২৫ তারিখে আপনার উপস্থিতি: অনুপস্থিত। কোর্স: প্লে , গ্রুপ: সাধারন, সেকশন: এ, শিফট: সকাল। ইকরা মডেল একাডেমী","bn","1",NULL,"2025-06-09 18:22:02");


-- Table structure for table `attendance_sms_settings`
DROP TABLE IF EXISTS `attendance_sms_settings`;
CREATE TABLE `attendance_sms_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sms_content_bn` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sms_content_en` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `school_name_bn` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `school_name_en` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active_language` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_bn` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_en` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `signature_1` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `signature_2` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `block_status` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `attendance_sms_settings`
INSERT INTO `attendance_sms_settings` (`id`, `sms_content_bn`, `sms_content_en`, `school_name_bn`, `school_name_en`, `active_language`, `address_bn`, `address_en`, `signature_1`, `signature_2`, `block_status`, `created_at`, `updated_at`) VALUES("1","প্রিয় `student_name_bn`, `student_id_bn`, `date_bn` তারিখে আপনার উপস্থিতি: `status_bn`। কোর্স: `course_bn`, গ্রুপ: `group_bn`, সেকশন: `section_bn`, শিফট: `shift_bn`। `school_name_bn`","Dear `student_name`, your attendance for `date`: `status`. Course: `course`, Group: `group`, Section: `section`, Shift: `shift`. `school_name`","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","Doubari Ideal public school ","bn","ডৌবাড়ী বাজারে পাশে মসজিদ মার্কেট ","ডৌবাড়ী,  গোয়াইনঘাট -সিলেট ","এক নাম্বার সিগনেচার ","দুই নাম্বার সিগনেচার","","2025-06-05 22:27:16","2025-06-06 17:55:11");


-- Table structure for table `baner`
DROP TABLE IF EXISTS `baner`;
CREATE TABLE `baner` (
  `id` int(10) NOT NULL,
  `banner_name` varchar(250) DEFAULT NULL,
  `logo_name` varchar(250) DEFAULT NULL,
  `title` varchar(250) DEFAULT NULL,
  `adminssion_form_baner_bn` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `adminssion_form_baner_en` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `favicon_icons` varchar(255) DEFAULT NULL,
  `headmaster_signature` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `baner`
INSERT INTO `baner` (`id`, `banner_name`, `logo_name`, `title`, `adminssion_form_baner_bn`, `adminssion_form_baner_en`, `favicon_icons`, `headmaster_signature`) VALUES("1","2.png","2logo.png","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","2.png","2.png","2logo.png","signature.png");


-- Table structure for table `baner_text`
DROP TABLE IF EXISTS `baner_text`;
CREATE TABLE `baner_text` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `baner` varchar(250) DEFAULT NULL,
  `text` varchar(250) DEFAULT NULL,
  `sms` text CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `baner_text`
INSERT INTO `baner_text` (`id`, `baner`, `text`, `sms`) VALUES("1","1719277867.jpg","ওয়েব বাজার বিডি স্মার্ট স্কুল","Your Payment Received: `amount_bn` TK, Unpaid Amount: `unpaid_amount_bn` TK, Invoice ID: `invoice_id_bn` . Student Name: `student_name_bn`,  Student ID: `student_id_bn` ,  Check Invoice: `url_check` ");


-- Table structure for table `bank_invoice`
DROP TABLE IF EXISTS `bank_invoice`;
CREATE TABLE `bank_invoice` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `bank_id` int(20) NOT NULL DEFAULT 0,
  `bank_name` varchar(100) DEFAULT NULL,
  `billing_type` varchar(100) DEFAULT NULL,
  `self_type` varchar(20) DEFAULT 'self',
  `ac_no` varchar(100) DEFAULT NULL,
  `name` varchar(250) DEFAULT NULL,
  `mobile` varchar(250) DEFAULT NULL,
  `discription` varchar(250) DEFAULT NULL,
  `reciept` varchar(250) DEFAULT NULL,
  `total_amount` int(20) DEFAULT 0,
  `discount` int(20) DEFAULT 0,
  `due` int(20) DEFAULT 0,
  `paid_amount` int(20) DEFAULT 0,
  `billing_time` varchar(100) DEFAULT NULL,
  `add_date` varchar(100) DEFAULT NULL,
  `update_date` varchar(100) DEFAULT NULL,
  `add_author` longtext DEFAULT NULL,
  `update_author` longtext DEFAULT NULL,
  `check_update` int(20) DEFAULT 0,
  `d_status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `bank_invoice`


-- Table structure for table `bank_list`
DROP TABLE IF EXISTS `bank_list`;
CREATE TABLE `bank_list` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `bank_name` varchar(200) DEFAULT NULL,
  `bank_account` varchar(200) DEFAULT NULL,
  `holder_name` varchar(100) DEFAULT NULL,
  `bank_mobile` varchar(250) DEFAULT NULL,
  `balance` int(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `bank_list`
INSERT INTO `bank_list` (`id`, `bank_name`, `bank_account`, `holder_name`, `bank_mobile`, `balance`) VALUES("2","Dutch-Bangla","44447854","WebBazarBD","01717452764","5335");


-- Table structure for table `batch`
DROP TABLE IF EXISTS `batch`;
CREATE TABLE `batch` (
  `betch_id` int(11) NOT NULL AUTO_INCREMENT,
  `batch_name` varchar(255) DEFAULT NULL,
  `start_end_time` varchar(255) CHARACTER SET utf8mb4 DEFAULT NULL,
  `end_time` varchar(255) CHARACTER SET utf8mb4 DEFAULT NULL,
  `status` int(11) DEFAULT NULL COMMENT '0= false, 1 start',
  PRIMARY KEY (`betch_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- Dumping data for table `batch`
INSERT INTO `batch` (`betch_id`, `batch_name`, `start_end_time`, `end_time`, `status`) VALUES("6","A1","09:00","10:00","1");


-- Table structure for table `billing_invoice`
DROP TABLE IF EXISTS `billing_invoice`;
CREATE TABLE `billing_invoice` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `billing_name` varchar(100) DEFAULT NULL,
  `billing_type` varchar(100) DEFAULT NULL,
  `billing_id` varchar(100) DEFAULT NULL,
  `name` varchar(250) DEFAULT NULL,
  `mobile` varchar(250) DEFAULT NULL,
  `discription` varchar(250) DEFAULT NULL,
  `reciept` varchar(250) DEFAULT NULL,
  `total_amount` varchar(100) DEFAULT NULL,
  `discount` varchar(100) DEFAULT '0',
  `due` int(20) DEFAULT 0,
  `paid_amount` varchar(100) DEFAULT '0',
  `billing_time` varchar(100) DEFAULT NULL,
  `add_date` varchar(100) DEFAULT NULL,
  `update_date` varchar(100) DEFAULT NULL,
  `add_author` longtext DEFAULT NULL,
  `update_author` longtext DEFAULT NULL,
  `check_update` varchar(100) DEFAULT '0',
  `d_status` varchar(100) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `billing_invoice`


-- Table structure for table `bkash_sendbox`
DROP TABLE IF EXISTS `bkash_sendbox`;
CREATE TABLE `bkash_sendbox` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `execute_data` text DEFAULT NULL,
  `token_data` text DEFAULT NULL,
  `careet_payment_data` text DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `bkash_sendbox`
INSERT INTO `bkash_sendbox` (`id`, `execute_data`, `token_data`, `careet_payment_data`, `date`) VALUES("1","{\"paymentID\":\"TR0011ygZC5B01757856575301\",\"trxID\":\"CIE20NFBY4\",\"transactionStatus\":\"Completed\",\"amount\":\"1\",\"currency\":\"BDT\",\"intent\":\"sale\",\"paymentExecuteTime\":\"2025-09-14T19:30:19:499 GMT+0600\",\"merchantInvoiceNumber\":\"Inv379117049\",\"payerType\":\"Customer\",\"payerReference\":\"554645\",\"customerMsisdn\":\"01770618575\",\"payerAccount\":\"01770618575\",\"maxRefundableAmount\":\"1\",\"statusCode\":\"0000\",\"statusMessage\":\"Successful\"}\n","{\"statusCode\": \"0000\", \"statusMessage\": \"Successful\", \"id_token\": \"eyJraWQiOiJvTVJzNU9ZY0wrUnRXQ2o3ZEJtdlc5VDBEcytrckw5M1NzY0VqUzlERXVzPSIsImFsZyI6IlJTMjU2In0.eyJzdWIiOiJlODNlMDkwMC1jY2ZmLTQzYTctODhiNy0wNjE5NDJkMTVmOTYiLCJhdWQiOiI2cDdhcWVzZmljZTAxazltNWdxZTJhMGlhaCIsImV2ZW50X2lkIjoiZGI4MDEyMjgtNjViZC00OTgwLTg5YmMtZTRhMDNmNzQyYzU4IiwidG9rZW5fdXNlIjoiaWQiLCJhdXRoX3RpbWUiOjE3NTc4NTY1NzQsImlzcyI6Imh0dHBzOlwvXC9jb2duaXRvLWlkcC5hcC1zb3V0aGVhc3QtMS5hbWF6b25hd3MuY29tXC9hcC1zb3V0aGVhc3QtMV9yYTNuUFkzSlMiLCJjb2duaXRvOnVzZXJuYW1lIjoic2FuZGJveFRva2VuaXplZFVzZXIwMiIsImV4cCI6MTc1Nzg2MDE3NCwiaWF0IjoxNzU3ODU2NTc0fQ.fDnMKx9N0gZqlw5BA309yu7TYUe3Ra1GKsIKgUbmFW3OYnr4U-u-QnTkbKs_ZvbEyplU51UNcfrKKrKIP_4KD8lI0izy2WnMeAcZIZZpYwMeDxzz8k_mWIDqOe5QD3ThgxSZwSj_5-ap5itQzvjiAkDtADqASHie-VLLct4GMX1-sRP_auPVHkHa0C62B-bjdwiePE7urive-ldL155SaiDv3hhVb0bcw-dhW7zCeV4wtpBslxnE3Kbt0HNEUUQyAzcmC1rHhL7eJMLZ2v6oTNni6A0XD00Nsr5C8UdlHxXbGQrCquV0r7SZZzcNz7EP4FWRz4zp5B-k8Pm9kFeigQ\", \"token_type\": \"Bearer\", \"expires_in\": 3600, \"refresh_token\": \"eyJjdHkiOiJKV1QiLCJlbmMiOiJBMjU2R0NNIiwiYWxnIjoiUlNBLU9BRVAifQ.qNaP7S-YeixtHiBY66Po3A7i51-bwkDPo6i8_98BsZ9qDDcFx4uy1Ee9FgyPbkDvUd6A4sl96fXJeBTfWU2L6Ay-88125yiTAGz4cNGpMC2NWpjR79GExZvpp5b9d30eRIz0Iv9yybPpPqU_7lUOzbiWbicff-zo_nOxhnMFuLj16crLMgK1KpeIf4RmcO11nh-iXl5551Uiqn9AqVql8f2nzleTlmWZzqBy-sfx4_oQs7i6xTSulelGHDk3CATFiCAyTnSwX6Kf51Qq3HRpiWJOwOQaPvf_4SBmvP5tv1KmDHUpLfyxmis7elXjOPNqrpHwYJvpCHj5_xUVxuFXew.eqPSQJ9qtKgrx5ds.yppCrRZFPm1jASYVzfb_Fol7ZgvZk-hQuvea9zIJSCXSFXn_lNls5bk0s0vXWUw8ABbzrWJr9RouWeBtG7REGK6N9m6JdfwVAMrLWAOPNyeG1GrfW-R5_LMYQyAbC9-BmRGnu-Bjh5xVnkwBCMJBprNqQf_SWSBC5FdJ5sJCVEESWmGFtYIsDd11c61tjmJ0_W-qsmXKyvI5dLPHhQvXgz42qtOyhJeTZNbJtuwG87_g_fI19mA6-3jI-dumoyBJUeWSZnBA6m-Yl05OPH6VD0jQpnrHaVOSRCUuB9cfmPsUYGlY0Cui4sCy8COd8dfFp3q6Tveahw94hWtTBftAYD5_Pj8b_qly_JmjRko-3jLZipT2POpIDlp-4orVn4lyH6nb22TrAdQRZy9Eic2LMtpQ-MvUE5ycPWBs8lOR8SWm8JHzbo1vD4comOOfh6DSjDb0fPbRZJxK0HpP382qwOL-0sJwfWgs9RneedpkUNPRlQw0lki8GOovZZoJcPnczxrLxoDHzUb02x2nkbz9lfxEbbw0W39Ci8CVcppmGgfNhMAlx3QWPMk5MqhkSta8Yf14AGbMllwxvfIJLCuTU9Y-BMRJ8KoXqZhKVc2h7sjk304Dp80QSfO4ZX4EAbzZjMAAASLOY0p4vIz1w1SQOeLYRNnMJfOmW7j2YPOSGUCSowMoa4xVpdjscY8dZaa3H45SZJztAN45khdt4TKtcohvRoa7tZyJ1prNcf05ty1G0TVa0RZRxV0MV3R2AfGEcI8-oQCM_npw80yTGWRTqUbH9weN22N5yge7i5fmwbYtsrWONIliCijDAkhr0F0oEHg0wv3UA4sAVoC3ZujDXH93TYC3JPR9yDkXrsyx1wb8NoQ-4ryrRAOLYZkSTu_rrbl1jIXyQu53ezlfz3wjs31LrFEVuVE2RLzI3tN1L8hxDlz4aeOO-c1k-kVjVfbNh7mIRVnBsC6MN690WfDDb3hUHgsbz3RJoc3kmkBPCHgtN0SuWU_M8c7-4AidCzsXd7NLZf_S61PHa4CFoc5J3GDtf-bwClmUb-ftgRjSyYPkkq5PXCYU47v5j2YhGl1j0PztKlz1kHwoW8cGOTEsiUEw5XMmxfNTkh1RNdDOdE_q7lz2o6y0tN1y5j13ijl4_bYuqu34MVLogMILOmUVPpDz8m13ZkjTd_VD8NMiP004NMmF5_jWV15tSo5hIqmmPOB11lwjHmXQcul-lRVebAO_COC1CkGvOGTwwArAJou9E6zmoibZEE1JYB_CFKpO0GNqGfjZhpA2Nl7BVPazeuHEqmLdOcgbapB_HMuShdv41MNe-Wg.7Fia0lU9QtnqIDU36eZ1hg\"}","{\"paymentID\":\"TR0011ygZC5B01757856575301\",\"bkashURL\":\"https://sandbox.payment.bkash.com/?paymentId=TR0011ygZC5B01757856575301&hash=(8r!RA91*BZzj0ijyfeHCq2eLrvlO6zoU3EijP6d90tyHB7cfG6TFf7J0V1thcMcKCkYjLUwfKc*Y4*2jGwT)Qfy(cQbGg8tDNsC1757856575301&mode=0011&apiVersion=v1.2.0-beta/\",\"callbackURL\":\"http://localhost/webbazar_smartschool_v1/module/bkash-v2/callback.php\",\"successCallbackURL\":\"http://localhost/webbazar_smartschool_v1/module/bkash-v2/callback.php?paymentID=TR0011ygZC5B01757856575301&status=success&signature=EDzbHFKgNc\",\"failureCallbackURL\":\"http://localhost/webbazar_smartschool_v1/module/bkash-v2/callback.php?paymentID=TR0011ygZC5B01757856575301&status=failure&signature=EDzbHFKgNc\",\"cancelledCallbackURL\":\"http://localhost/webbazar_smartschool_v1/module/bkash-v2/callback.php?paymentID=TR0011ygZC5B01757856575301&status=cancel&signature=EDzbHFKgNc\",\"amount\":\"1\",\"intent\":\"sale\",\"currency\":\"BDT\",\"paymentCreateTime\":\"2025-09-14T19:29:35:301 GMT+0600\",\"transactionStatus\":\"Initiated\",\"merchantInvoiceNumber\":\"Inv379117049\",\"statusCode\":\"0000\",\"statusMessage\":\"Successful\"}\n","2025-09-14 13:30:17");


-- Table structure for table `bkash_token`
DROP TABLE IF EXISTS `bkash_token`;
CREATE TABLE `bkash_token` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `token` longtext NOT NULL,
  `create_time` varchar(250) NOT NULL,
  `expire_time` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `bkash_token`
INSERT INTO `bkash_token` (`id`, `token`, `create_time`, `expire_time`) VALUES("49","eyJraWQiOiJEWXd6RU9Fd3h5Q3lkRVwvUnJZU1BOcGk5MENBQkVBeHZ0bUs1QXQ4XC9oaVk9IiwiYWxnIjoiUlMyNTYifQ.eyJzdWIiOiIxN2Y2NGVkNC0wMjkxLTRlNDUtYjlhYS1kMWVkYzQ5YWVmZTYiLCJhdWQiOiJrNW1xNmJlaWs0aWR2ZDkxcDRmdGV0cHYzIiwiZXZlbnRfaWQiOiI1Y2M1OWQwMS03MjM1LTRlZDAtOTMwZi0wNjlkOWYwNGZlNzAiLCJ0b2tlbl91c2UiOiJpZCIsImF1dGhfdGltZSI6MTc1NzkxMjMwNywiaXNzIjoiaHR0cHM6XC9cL2NvZ25pdG8taWRwLmFwLXNvdXRoZWFzdC0xLmFtYXpvbmF3cy5jb21cL2FwLXNvdXRoZWFzdC0xX1QzVktDZzJoeSIsImNvZ25pdG86dXNlcm5hbWUiOiIwMTcxMDQxNDMwOCIsImV4cCI6MTc1NzkxNTkwNywiaWF0IjoxNzU3OTEyMzA3fQ.R4llWqQycDF9ErHEhUelHCYugLzLXIeIXA0dRl5P_PqzoDY_NIvF4mFhK0MoNIcfWUVq26tdJf8rUjAcZs5unaA7NbSiLB9OhZFgjHDF4PkYhZP92V68DF7n8qCfnKXdtMsGY62B9zb3DfJEV1CPnrDN6DAu58jC43aA65jw4lQyOuYbi7G9k3c2Ug3VyuwKHuaF_JMB5l3YMlHAOtVG3fw7UHaShFx54hcjlnF_NKWnNa53SXbOoe-z-GOBr421nYEYe0VN0ZicD-ZIylBR-NyBLNCR_L5PYO0zaYupDm8Z7TvQMGqIIYdL1nSwGSrFmFNrAjNhWluyrpysZ1qCqg","1757912307","1757915787");


-- Table structure for table `bkash_transaction_admission`
DROP TABLE IF EXISTS `bkash_transaction_admission`;
CREATE TABLE `bkash_transaction_admission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admission_id` varchar(200) NOT NULL,
  `payment_id` varchar(200) NOT NULL,
  `trx_id` varchar(200) NOT NULL,
  `amount` varchar(200) NOT NULL,
  `status` varchar(200) NOT NULL,
  `payment_execute_time` datetime NOT NULL,
  `response` text NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `bkash_transaction_admission`


-- Table structure for table `board_name`
DROP TABLE IF EXISTS `board_name`;
CREATE TABLE `board_name` (
  `id` int(20) NOT NULL,
  `name` varchar(250) DEFAULT NULL,
  `bn_name` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `board_name`
INSERT INTO `board_name` (`id`, `name`, `bn_name`) VALUES("1","Barisal",NULL);
INSERT INTO `board_name` (`id`, `name`, `bn_name`) VALUES("2","Chattogram","");
INSERT INTO `board_name` (`id`, `name`, `bn_name`) VALUES("3","Cumilla",NULL);
INSERT INTO `board_name` (`id`, `name`, `bn_name`) VALUES("4","Dhaka",NULL);
INSERT INTO `board_name` (`id`, `name`, `bn_name`) VALUES("5","Dinajpur",NULL);
INSERT INTO `board_name` (`id`, `name`, `bn_name`) VALUES("6","Jashore",NULL);
INSERT INTO `board_name` (`id`, `name`, `bn_name`) VALUES("7","Mymensingh",NULL);
INSERT INTO `board_name` (`id`, `name`, `bn_name`) VALUES("8","Rajshahi",NULL);
INSERT INTO `board_name` (`id`, `name`, `bn_name`) VALUES("9","Sylhet",NULL);
INSERT INTO `board_name` (`id`, `name`, `bn_name`) VALUES("10","Madrasah",NULL);
INSERT INTO `board_name` (`id`, `name`, `bn_name`) VALUES("11","Technical",NULL);


-- Table structure for table `branch`
DROP TABLE IF EXISTS `branch`;
CREATE TABLE `branch` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `branch` varchar(255) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `detail` text DEFAULT NULL,
  `delete_status` enum('0','1') CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `group_n_bangla` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

-- Dumping data for table `branch`
INSERT INTO `branch` (`id`, `branch`, `address`, `detail`, `delete_status`, `group_n_bangla`) VALUES("1","General","","General","0","সাধারন");
INSERT INTO `branch` (`id`, `branch`, `address`, `detail`, `delete_status`, `group_n_bangla`) VALUES("5","Humanities",NULL,"Humanities","0","মানবিক");
INSERT INTO `branch` (`id`, `branch`, `address`, `detail`, `delete_status`, `group_n_bangla`) VALUES("6","Commerce",NULL,"Commerce","0","বাণিজ্য ");
INSERT INTO `branch` (`id`, `branch`, `address`, `detail`, `delete_status`, `group_n_bangla`) VALUES("7","Science",NULL,"Science","0","বিজ্ঞান ");


-- Table structure for table `categories`
DROP TABLE IF EXISTS `categories`;
CREATE TABLE `categories` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `c_name` varchar(250) DEFAULT NULL,
  `c_type` varchar(100) DEFAULT NULL,
  `c_amount` int(20) DEFAULT NULL,
  `c_add` varchar(100) DEFAULT NULL,
  `c_update` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `categories`
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("14","Official Stationary","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("15","Photocopy","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("16","Exam","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("17","Electricity","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("18","Travel","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("19","Mobile","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("20","Computer","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("21","Foundation","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("22","AC","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("23","Program","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("24","Dress","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("25","Edu.Equipment","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("26","Publication","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("27","Repair","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("28","House rent","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("29","Transport","expense","0","2024-06-14","2024-06-14");
INSERT INTO `categories` (`id`, `c_name`, `c_type`, `c_amount`, `c_add`, `c_update`) VALUES("30","Aca.Food","expense","0","2024-06-14","2024-06-14");


-- Table structure for table `category`
DROP TABLE IF EXISTS `category`;
CREATE TABLE `category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(250) DEFAULT NULL,
  `category_purpose` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- Dumping data for table `category`


-- Table structure for table `certificate_id_card_template`
DROP TABLE IF EXISTS `certificate_id_card_template`;
CREATE TABLE `certificate_id_card_template` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `card_image` varchar(250) DEFAULT NULL,
  `card_no` int(20) NOT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  `file_name` varchar(250) DEFAULT '0',
  `css_file_name` varchar(250) NOT NULL DEFAULT '0',
  `active_status` int(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

-- Dumping data for table `certificate_id_card_template`
INSERT INTO `certificate_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("1","image/template_1728454088_basic_certificate -01.png","1","1","0","0","0");
INSERT INTO `certificate_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("2","image/template_1728454092_basic_certificate -02.png","2","1","0","0","0");
INSERT INTO `certificate_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("3","image/template_1728454096_basic_certificate -03.png","3","1","0","0","0");
INSERT INTO `certificate_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("4","image/template_1728454099_basic_certificate -04.png","4","1","0","0","0");
INSERT INTO `certificate_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("6","image/template_1753327303_testimonialE.png","5","1","0","0","0");
INSERT INTO `certificate_id_card_template` (`id`, `card_image`, `card_no`, `status`, `file_name`, `css_file_name`, `active_status`) VALUES("7","image/template_1753327298_testimonialB.png","6","1","0","0","1");


-- Table structure for table `class_routine`
DROP TABLE IF EXISTS `class_routine`;
CREATE TABLE `class_routine` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `class` varchar(100) NOT NULL,
  `s_group` varchar(100) DEFAULT NULL,
  `s_section` varchar(100) DEFAULT NULL,
  `shift` varchar(100) DEFAULT NULL,
  `session` varchar(100) DEFAULT NULL,
  `year` varchar(100) DEFAULT NULL,
  `routine_headline` longtext DEFAULT NULL,
  `routine_file` varchar(250) DEFAULT NULL,
  `add_date` varchar(250) DEFAULT NULL,
  `update_date` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `class_routine`
INSERT INTO `class_routine` (`id`, `class`, `s_group`, `s_section`, `shift`, `session`, `year`, `routine_headline`, `routine_file`, `add_date`, `update_date`) VALUES("11","1","1","6","3","6","2025","ক্লাস রুটিন","w_222969be.jpg","2025-08-01 12:15:09",NULL);
INSERT INTO `class_routine` (`id`, `class`, `s_group`, `s_section`, `shift`, `session`, `year`, `routine_headline`, `routine_file`, `add_date`, `update_date`) VALUES("12","1","1","6","","","","ক্লাস রুটিন","w_222969be.jpg","2025-08-02 21:31:11",NULL);


-- Table structure for table `class_schedule_student`
DROP TABLE IF EXISTS `class_schedule_student`;
CREATE TABLE `class_schedule_student` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `t_id` varchar(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `contact` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `value_day` varchar(255) DEFAULT NULL,
  `value_time` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `room_name` varchar(255) DEFAULT NULL,
  `course` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `subject_time` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8;

-- Dumping data for table `class_schedule_student`
INSERT INTO `class_schedule_student` (`id`, `t_id`, `name`, `contact`, `value_day`, `value_time`, `room_name`, `course`, `subject`, `subject_time`) VALUES("62","48","Md Ashraful Islam","01717452764","Saturday,Sunday,Monday","4","1","12","26","00:00");
INSERT INTO `class_schedule_student` (`id`, `t_id`, `name`, `contact`, `value_day`, `value_time`, `room_name`, `course`, `subject`, `subject_time`) VALUES("64","48","Md Ashraful Islam","01717452764","Saturday,Sunday,Monday","6","1","5","27","09:00");


-- Table structure for table `class_section`
DROP TABLE IF EXISTS `class_section`;
CREATE TABLE `class_section` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_section_name` varchar(255) DEFAULT NULL,
  `class_section_name_bn` varchar(250) DEFAULT NULL,
  `delete_status` enum('0','1') CHARACTER SET latin1 NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

-- Dumping data for table `class_section`
INSERT INTO `class_section` (`id`, `class_section_name`, `class_section_name_bn`, `delete_status`) VALUES("6","A","এ","0");
INSERT INTO `class_section` (`id`, `class_section_name`, `class_section_name_bn`, `delete_status`) VALUES("8","B","বি","0");


-- Table structure for table `class_test_exam`
DROP TABLE IF EXISTS `class_test_exam`;
CREATE TABLE `class_test_exam` (
  `mark_id` int(11) NOT NULL AUTO_INCREMENT,
  `branch` int(11) DEFAULT NULL,
  `s_year` int(11) DEFAULT NULL,
  `course` int(11) DEFAULT NULL,
  `subject` int(11) DEFAULT NULL,
  `exam_name` varchar(255) DEFAULT NULL,
  `exam_key` varchar(100) DEFAULT NULL,
  `regi_ids` varchar(100) DEFAULT NULL,
  `std_mark` float DEFAULT NULL,
  `exam_status` int(11) DEFAULT NULL,
  `subject_mark` float DEFAULT NULL,
  `class_section_name` int(11) DEFAULT NULL,
  `shift_name` int(11) DEFAULT NULL,
  `academic_year_name_bn` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`mark_id`)
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `class_test_exam`
INSERT INTO `class_test_exam` (`mark_id`, `branch`, `s_year`, `course`, `subject`, `exam_name`, `exam_key`, `regi_ids`, `std_mark`, `exam_status`, `subject_mark`, `class_section_name`, `shift_name`, `academic_year_name_bn`, `created_at`) VALUES("48","1","2024","12","26","Modal","1711350705_544418686","1","85",NULL,"100","6","1","4","2024-03-25 07:11:57");
INSERT INTO `class_test_exam` (`mark_id`, `branch`, `s_year`, `course`, `subject`, `exam_name`, `exam_key`, `regi_ids`, `std_mark`, `exam_status`, `subject_mark`, `class_section_name`, `shift_name`, `academic_year_name_bn`, `created_at`) VALUES("49","1","2024","3","15","Modal Test Bangla 1","1718324871_1643069253","8","95",NULL,"100","6","1","4","2024-06-14 00:28:40");
INSERT INTO `class_test_exam` (`mark_id`, `branch`, `s_year`, `course`, `subject`, `exam_name`, `exam_key`, `regi_ids`, `std_mark`, `exam_status`, `subject_mark`, `class_section_name`, `shift_name`, `academic_year_name_bn`, `created_at`) VALUES("50","1","2024","3","15","Modal Test Bangla 1","1718324871_1643069253","9","85",NULL,"100","6","1","4","2024-06-14 00:28:40");
INSERT INTO `class_test_exam` (`mark_id`, `branch`, `s_year`, `course`, `subject`, `exam_name`, `exam_key`, `regi_ids`, `std_mark`, `exam_status`, `subject_mark`, `class_section_name`, `shift_name`, `academic_year_name_bn`, `created_at`) VALUES("51","1","2024","3","15","Modal Test Bangla 1","1718324871_1643069253","7","90",NULL,"100","6","1","4","2024-06-14 00:28:40");
INSERT INTO `class_test_exam` (`mark_id`, `branch`, `s_year`, `course`, `subject`, `exam_name`, `exam_key`, `regi_ids`, `std_mark`, `exam_status`, `subject_mark`, `class_section_name`, `shift_name`, `academic_year_name_bn`, `created_at`) VALUES("52","1","2024","3","15","Modal Test Bangla 1","1718324871_1643069253","6","85",NULL,"100","6","1","4","2024-06-14 00:28:40");
INSERT INTO `class_test_exam` (`mark_id`, `branch`, `s_year`, `course`, `subject`, `exam_name`, `exam_key`, `regi_ids`, `std_mark`, `exam_status`, `subject_mark`, `class_section_name`, `shift_name`, `academic_year_name_bn`, `created_at`) VALUES("53","1","2024","3","15","Modal Test Bangla 1","1718324871_1643069253","5","80",NULL,"100","6","1","4","2024-06-14 00:28:40");
INSERT INTO `class_test_exam` (`mark_id`, `branch`, `s_year`, `course`, `subject`, `exam_name`, `exam_key`, `regi_ids`, `std_mark`, `exam_status`, `subject_mark`, `class_section_name`, `shift_name`, `academic_year_name_bn`, `created_at`) VALUES("54","1","2024","3","15","Modal Test Bangla 1","1718324871_1643069253","4","85",NULL,"100","6","1","4","2024-06-14 00:28:40");
INSERT INTO `class_test_exam` (`mark_id`, `branch`, `s_year`, `course`, `subject`, `exam_name`, `exam_key`, `regi_ids`, `std_mark`, `exam_status`, `subject_mark`, `class_section_name`, `shift_name`, `academic_year_name_bn`, `created_at`) VALUES("55","1","2024","3","15","Modal Test Bangla 1","1718324871_1643069253","3","35",NULL,"100","6","1","4","2024-06-14 00:28:40");
INSERT INTO `class_test_exam` (`mark_id`, `branch`, `s_year`, `course`, `subject`, `exam_name`, `exam_key`, `regi_ids`, `std_mark`, `exam_status`, `subject_mark`, `class_section_name`, `shift_name`, `academic_year_name_bn`, `created_at`) VALUES("56","1","2024","3","15","Modal Test Bangla 1","1718324871_1643069253","1","30",NULL,"100","6","1","4","2024-06-14 00:28:40");
INSERT INTO `class_test_exam` (`mark_id`, `branch`, `s_year`, `course`, `subject`, `exam_name`, `exam_key`, `regi_ids`, `std_mark`, `exam_status`, `subject_mark`, `class_section_name`, `shift_name`, `academic_year_name_bn`, `created_at`) VALUES("57","1","2024","3","15","Modal Test Bangla 1","1718324871_1643069253","2","70",NULL,"100","6","1","4","2024-06-14 00:28:40");
INSERT INTO `class_test_exam` (`mark_id`, `branch`, `s_year`, `course`, `subject`, `exam_name`, `exam_key`, `regi_ids`, `std_mark`, `exam_status`, `subject_mark`, `class_section_name`, `shift_name`, `academic_year_name_bn`, `created_at`) VALUES("58","1","2024","1","43","Test Resuls-2024","1731770658_846665122","15","80",NULL,"100","6","3","4","2024-11-16 15:24:49");


-- Table structure for table `color_picker`
DROP TABLE IF EXISTS `color_picker`;
CREATE TABLE `color_picker` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `left_ber_bg` varchar(250) NOT NULL,
  `left_ber_text` varchar(250) NOT NULL,
  `top_ber_bg` varchar(250) NOT NULL,
  `top_ber_text` varchar(250) NOT NULL,
  `card1_gradient1` varchar(7) DEFAULT '#FF416C',
  `card1_gradient2` varchar(7) DEFAULT '#FF4B2B',
  `card1_text` varchar(7) DEFAULT '#FFFFFF',
  `card2_gradient1` varchar(7) DEFAULT '#f2994a',
  `card2_gradient2` varchar(7) DEFAULT '#f2c94c',
  `card2_text` varchar(7) DEFAULT '#FFFFFF',
  `card3_gradient1` varchar(7) DEFAULT '#00b09b',
  `card3_gradient2` varchar(7) DEFAULT '#96c93d',
  `card3_text` varchar(7) DEFAULT '#FFFFFF',
  `card4_gradient1` varchar(7) DEFAULT '#4776E6',
  `card4_gradient2` varchar(7) DEFAULT '#8E54E9',
  `card4_text` varchar(7) DEFAULT '#FFFFFF',
  `card5_gradient1` varchar(7) DEFAULT '#834d9b',
  `card5_gradient2` varchar(7) DEFAULT '#d04ed6',
  `card5_text` varchar(7) DEFAULT '#FFFFFF',
  `card6_gradient1` varchar(7) DEFAULT '#11998e',
  `card6_gradient2` varchar(7) DEFAULT '#38ef7d',
  `card6_text` varchar(7) DEFAULT '#FFFFFF',
  `card7_gradient1` varchar(7) DEFAULT '#eb3349',
  `card7_gradient2` varchar(7) DEFAULT '#f45c43',
  `card7_text` varchar(7) DEFAULT '#FFFFFF',
  `card8_gradient1` varchar(7) DEFAULT '#6B73FF',
  `card8_gradient2` varchar(7) DEFAULT '#000DFF',
  `card8_text` varchar(7) DEFAULT '#FFFFFF',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `color_picker`
INSERT INTO `color_picker` (`id`, `left_ber_bg`, `left_ber_text`, `top_ber_bg`, `top_ber_text`, `card1_gradient1`, `card1_gradient2`, `card1_text`, `card2_gradient1`, `card2_gradient2`, `card2_text`, `card3_gradient1`, `card3_gradient2`, `card3_text`, `card4_gradient1`, `card4_gradient2`, `card4_text`, `card5_gradient1`, `card5_gradient2`, `card5_text`, `card6_gradient1`, `card6_gradient2`, `card6_text`, `card7_gradient1`, `card7_gradient2`, `card7_text`, `card8_gradient1`, `card8_gradient2`, `card8_text`) VALUES("1","#2e43b8","#ffffff","#bc1edc","#ebebeb","#ff4000","#5c5c5c","#ffffff","#f2994a","#f2c94c","#ffffff","#00b09b","#96c93d","#ffffff","#4776e6","#8e54e9","#ffffff","#834d9b","#d04ed6","#ffffff","#11998e","#38ef7d","#ffffff","#eb3349","#f45c43","#ffffff","#ff6b89","#000dff","#ffffff");


-- Table structure for table `computer_office_application`
DROP TABLE IF EXISTS `computer_office_application`;
CREATE TABLE `computer_office_application` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `std_id` int(11) NOT NULL,
  `mcq` int(11) NOT NULL,
  `viva` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- Dumping data for table `computer_office_application`
INSERT INTO `computer_office_application` (`id`, `std_id`, `mcq`, `viva`, `status`) VALUES("1","1","90","80","0");
INSERT INTO `computer_office_application` (`id`, `std_id`, `mcq`, `viva`, `status`) VALUES("2","0","0","0","0");


-- Table structure for table `correction_text`
DROP TABLE IF EXISTS `correction_text`;
CREATE TABLE `correction_text` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `correction_key` varchar(255) NOT NULL,
  `correction_name` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `correction_text`
INSERT INTO `correction_text` (`id`, `correction_key`, `correction_name`, `created_at`) VALUES("1","Course","Class","2025-05-27 04:56:19");
INSERT INTO `correction_text` (`id`, `correction_key`, `correction_name`, `created_at`) VALUES("7","Group","Group","2025-06-02 04:50:19");
INSERT INTO `correction_text` (`id`, `correction_key`, `correction_name`, `created_at`) VALUES("11","Present School Name","Previous School Name","2025-06-17 03:13:35");
INSERT INTO `correction_text` (`id`, `correction_key`, `correction_name`, `created_at`) VALUES("12","Session","Session","2025-06-27 04:18:45");
INSERT INTO `correction_text` (`id`, `correction_key`, `correction_name`, `created_at`) VALUES("13","Section","Section","2025-06-27 04:18:58");
INSERT INTO `correction_text` (`id`, `correction_key`, `correction_name`, `created_at`) VALUES("14","Shift","Shift","2025-06-27 04:19:08");
INSERT INTO `correction_text` (`id`, `correction_key`, `correction_name`, `created_at`) VALUES("16","ক্লাস","ক্লাস","2025-07-02 17:08:20");
INSERT INTO `correction_text` (`id`, `correction_key`, `correction_name`, `created_at`) VALUES("17","গ্রুপ/বিভাগ","গ্রুপ","2025-07-02 17:08:30");
INSERT INTO `correction_text` (`id`, `correction_key`, `correction_name`, `created_at`) VALUES("18","ক্লাস সেকশন","ক্লাস সেকশন","2025-07-02 17:08:39");
INSERT INTO `correction_text` (`id`, `correction_key`, `correction_name`, `created_at`) VALUES("19","ক্লাস শিফট","ক্লাস শিফট","2025-07-02 17:08:48");
INSERT INTO `correction_text` (`id`, `correction_key`, `correction_name`, `created_at`) VALUES("20","শিক্ষাবর্ষ","শিক্ষাবর্ষ","2025-07-02 17:08:55");
INSERT INTO `correction_text` (`id`, `correction_key`, `correction_name`, `created_at`) VALUES("21","Add Class","Add Class","2025-07-02 23:30:38");
INSERT INTO `correction_text` (`id`, `correction_key`, `correction_name`, `created_at`) VALUES("22","Class,Group,Session,Section,Shift","Class,Group,Session,Section,Shift","2025-07-02 23:35:58");
INSERT INTO `correction_text` (`id`, `correction_key`, `correction_name`, `created_at`) VALUES("23","Add Group","Add Group","2025-07-02 23:36:25");
INSERT INTO `correction_text` (`id`, `correction_key`, `correction_name`, `created_at`) VALUES("24","Add Session","Add Session","2025-07-02 23:36:45");
INSERT INTO `correction_text` (`id`, `correction_key`, `correction_name`, `created_at`) VALUES("25","Add Section","Add Section","2025-07-02 23:37:02");
INSERT INTO `correction_text` (`id`, `correction_key`, `correction_name`, `created_at`) VALUES("26","Add Shift","Add Shift","2025-07-02 23:37:24");
INSERT INTO `correction_text` (`id`, `correction_key`, `correction_name`, `created_at`) VALUES("27","পেমেন্ট","টিউশন ফি","2025-07-06 14:25:58");


-- Table structure for table `course`
DROP TABLE IF EXISTS `course`;
CREATE TABLE `course` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course` varchar(255) DEFAULT NULL,
  `course_n_bangla` varchar(255) DEFAULT NULL,
  `c_amount` int(5) DEFAULT NULL,
  `detail` text DEFAULT NULL,
  `delete_status` enum('0','1') CHARACTER SET latin1 NOT NULL DEFAULT '0',
  `course_code` int(11) DEFAULT NULL,
  `minimum_payment` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_course_lookup` (`id`,`course`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

-- Dumping data for table `course`
INSERT INTO `course` (`id`, `course`, `course_n_bangla`, `c_amount`, `detail`, `delete_status`, `course_code`, `minimum_payment`) VALUES("1","Play","প্লে ","0","","0","100","");
INSERT INTO `course` (`id`, `course`, `course_n_bangla`, `c_amount`, `detail`, `delete_status`, `course_code`, `minimum_payment`) VALUES("2","Nursery","নার্সারী ","6000","নার্সারী শ্রেণী","0","202","");
INSERT INTO `course` (`id`, `course`, `course_n_bangla`, `c_amount`, `detail`, `delete_status`, `course_code`, `minimum_payment`) VALUES("3","One","প্রথম ","9000","প্রথম শ্রেণী","0","203","");
INSERT INTO `course` (`id`, `course`, `course_n_bangla`, `c_amount`, `detail`, `delete_status`, `course_code`, `minimum_payment`) VALUES("4","Two","দ্বিতীয়","4000","দ্বিতীয় শ্রেণী","0","204","");
INSERT INTO `course` (`id`, `course`, `course_n_bangla`, `c_amount`, `detail`, `delete_status`, `course_code`, `minimum_payment`) VALUES("5","Three","তৃতীয় ","5000","তৃতীয় শ্রেণী","0","205","");
INSERT INTO `course` (`id`, `course`, `course_n_bangla`, `c_amount`, `detail`, `delete_status`, `course_code`, `minimum_payment`) VALUES("6","Four","চতুর্থ ","6000","চতুর্থ শ্রেণীর","0","206","");
INSERT INTO `course` (`id`, `course`, `course_n_bangla`, `c_amount`, `detail`, `delete_status`, `course_code`, `minimum_payment`) VALUES("7","Five","পঞ্চম","7000","পঞ্চম শ্রেণীর","0","207","");
INSERT INTO `course` (`id`, `course`, `course_n_bangla`, `c_amount`, `detail`, `delete_status`, `course_code`, `minimum_payment`) VALUES("8","Six","ষষ্ঠ","12000","ষষ্ঠ শ্রেণীর","0","208","");


-- Table structure for table `course_subject`
DROP TABLE IF EXISTS `course_subject`;
CREATE TABLE `course_subject` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` varchar(11) DEFAULT NULL,
  `religion` varchar(200) DEFAULT NULL,
  `subject_name` varchar(255) DEFAULT NULL,
  `subject_name_bn` varchar(250) DEFAULT NULL,
  `subject_code` varchar(20) DEFAULT NULL,
  `subject_code_bn` varchar(250) DEFAULT NULL,
  `group_id` varchar(30) DEFAULT NULL,
  `picture` varchar(100) DEFAULT NULL,
  `status` varchar(11) NOT NULL DEFAULT '1',
  `written` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `4th_subject` varchar(200) DEFAULT NULL,
  `two_in_one` varchar(200) DEFAULT NULL,
  `two_in_one_2` varchar(200) DEFAULT NULL,
  `viva` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `total` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `priority` varchar(255) DEFAULT NULL,
  `two_in_one_3` varchar(255) DEFAULT NULL,
  `two_in_one_4` varchar(255) DEFAULT NULL,
  `two_in_one_5` varchar(255) DEFAULT NULL,
  `two_in_one_6` varchar(255) DEFAULT NULL,
  `class_time` varchar(255) DEFAULT NULL,
  `room_no` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=176 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `course_subject`
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("15","13",NULL,"Bangla","বাংলা","101","১০১","",NULL,"1","","","","","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("29","13",NULL,"বাংলা","n/a","3103","n/a","",NULL,"1",NULL,"","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("32","13",NULL,"ইসলামের ইতিহাস","n/a","3106","n/a","",NULL,"1",NULL,"","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("33","13",NULL,"সাধারণ জ্ঞান","n/a","3107","n/a","",NULL,"1",NULL,"","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("40","13",NULL,"Quaran","কোরআন","11111"," ১১১১১","",NULL,"1",NULL,"","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("41","13",NULL,"Quaran","কোরআন","111111"," ১১১১১","",NULL,"1",NULL,"","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("42","13",NULL,"Quaran 5","কোরআন 5","11111 5"," ১১১১১5","",NULL,"1","","","","","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("119","1","","Bangla","বাংলা","101","১০১","General",NULL,"1",NULL,"0","","",NULL,NULL,"1","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("120","1","","English","ইংলিশ","102","১০২","General",NULL,"1",NULL,"0","","",NULL,NULL,"2","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("121","1","","Math","গণিত","103","১০৩","General",NULL,"1",NULL,"0","","",NULL,NULL,"3","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("122","2","","Bangla","বাংলা","201","২০১","General",NULL,"1",NULL,"0","","",NULL,NULL,"4","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("123","2","","My  Learning English","My  Learning English","202","২০২","General",NULL,"1",NULL,"0","","",NULL,NULL,"5","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("124","2","","Math","গণিত","203","২০৩","General",NULL,"1",NULL,"0","","",NULL,NULL,"6","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("125","2","","Word Book","Word Book","204","২০৪","General",NULL,"1",NULL,"0","","",NULL,NULL,"7","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("126","2","","সাধারণ জ্ঞান","সাধারণ জ্ঞান","205","২০৫","General",NULL,"1",NULL,"0","","",NULL,NULL,"8","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("127","3","","Bangla","বাংলা","301","৩০১","General",NULL,"1",NULL,"0","","",NULL,NULL,"9","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("129","3","","English","ইংলিশ","303","৩০৩","General",NULL,"1",NULL,"0","","",NULL,NULL,"11","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("130","3","","My Smart English Grammar","My Smart English Grammar","304","৩০৪","General",NULL,"1",NULL,"0","","",NULL,NULL,"12","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("131","3","","Math","গণিত","305","৩০৫","General",NULL,"1",NULL,"0","","",NULL,NULL,"13","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("132","3","","Word Book","Word Book","306","৩০৬","General",NULL,"1",NULL,"0","","",NULL,NULL,"14","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("133","3","","My Active English Book","My Active English Book","307","৩০৭","General",NULL,"1",NULL,"0","","",NULL,NULL,"15","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("134","3","","সাধারণ জ্ঞান","সাধারণ জ্ঞান","308","৩০৮","General",NULL,"1",NULL,"0","","",NULL,NULL,"16","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("135","4","","Bangla","বাংলা","401","৪০১","General",NULL,"1",NULL,"0","","",NULL,NULL,"17","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("136","4","","Bangla  Grammar","বাংলা  ব্যাকরণ","402","৪০২","General",NULL,"1",NULL,"0","","",NULL,NULL,"18","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("137","4","","English","ইংলিশ","403","৪০৩","General",NULL,"1",NULL,"0","","",NULL,NULL,"19","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("138","4","","My Smart English Grammar","My Smart English Grammar","404","৪০৪","General",NULL,"1",NULL,"0","","",NULL,NULL,"20","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("139","4","","Math","Math","405","৪০৫","General",NULL,"1",NULL,"0","","",NULL,NULL,"21","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("140","4","","My Picture Word Book","My Picture Word Book","407","৪০৭","General",NULL,"1",NULL,"0","","",NULL,NULL,"22","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("141","4","","ছোটদের সাধারণ জ্ঞান","ছোটদের সাধারণ জ্ঞান","408","৪০৮","General",NULL,"1",NULL,"0","","",NULL,NULL,"23","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("142","4","","ছোটদের কম্পিউটার শিক্ষা","ছোটদের কম্পিউটার শিক্ষা","409","৪০৯","General",NULL,"1",NULL,"0","","",NULL,NULL,"24","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("143","4","","My Active English Book","My Active English Book","406","৪০৬","General",NULL,"1",NULL,"0","","",NULL,NULL,"25","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("144","5","","Bangla","বাংলা","501","501","General",NULL,"1",NULL,"0","","",NULL,NULL,"26","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("145","5","","Bangla  Grammar","বাংলা  ব্যাকরণ","502","৫০২","General",NULL,"1",NULL,"0","","",NULL,NULL,"26","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("146","5","","English","ইংলিশ","503","৫০৩","General",NULL,"1",NULL,"0","","",NULL,NULL,"27","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("147","5","","My Smart English Grammar","My Smart English Grammar","504","৫০৪","General",NULL,"1",NULL,"0","","",NULL,NULL,"28","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("148","5","","Mathematics","Mathematics","505","৫০৫","General",NULL,"1",NULL,"0","","",NULL,NULL,"30","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("149","5","","science","বিজ্ঞান","506","৫০৬","General",NULL,"1",NULL,"0","","",NULL,NULL,"31","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("150","5","","বাংলাদেশ ও বিশ্ব পরিচয়","বাংলাদেশ ও বিশ্ব পরিচয়","507","৫০৭","General",NULL,"1",NULL,"0","","",NULL,NULL,"32","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("151","5","","ইসলাম শিক্ষা","ইসলাম শিক্ষা","508","৫০৮","General",NULL,"1",NULL,"0","","",NULL,NULL,"33","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("152","5","","ছোটদের কম্পিউটার শিক্ষা","ছোটদের কম্পিউটার শিক্ষা","509","৫০৯","General",NULL,"1",NULL,"0","","",NULL,NULL,"34","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("153","5","","ছোটদের সাধারণ জ্ঞান","ছোটদের সাধারণ জ্ঞান","510","৫১০","General",NULL,"1",NULL,"0","","",NULL,NULL,"35","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("155","5","","Word Book","Word Book","511","৫১১","General",NULL,"1",NULL,"0","","",NULL,NULL,"36","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("156","6","","Bangla","বাংলা","601","৬০১","General",NULL,"1",NULL,"0","","",NULL,NULL,"37","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("157","6","","Bangla  Grammar","বাংলা  ব্যাকরণ","602","৬০২","General",NULL,"1",NULL,"0","","",NULL,NULL,"38","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("158","6","","English","ইংলিশ","603","৬০৩","General",NULL,"1",NULL,"0","","",NULL,NULL,"39","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("159","6","","My Smart English Grammar","My Smart English Grammar","604","৬০৪","General",NULL,"1",NULL,"0","","",NULL,NULL,"40","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("160","6","","Mathematics","গণিত","605","৬০৫","General",NULL,"1",NULL,"0","","",NULL,NULL,"41","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("161","6","","science","বিজ্ঞান","606","৬০৬","General",NULL,"1",NULL,"0","","",NULL,NULL,"42","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("162","6","","বাংলাদেশ ও বিশ্ব পরিচয়","বাংলাদেশ ও বিশ্ব পরিচয়","607","৬০৭","General",NULL,"1",NULL,"0","","",NULL,NULL,"44","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("163","6","","ইসলাম শিক্ষা","ইসলাম শিক্ষা","608","৬০৮","General",NULL,"1",NULL,"0","","",NULL,NULL,"45","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("164","6","","ছোটদের কম্পিউটার শিক্ষা","ছোটদের কম্পিউটার শিক্ষা","609","৬০৯","General",NULL,"1",NULL,"0","","",NULL,NULL,"46","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("165","6","","ছোটদের সাধারণ জ্ঞান","ছোটদের সাধারণ জ্ঞান","610","৬১০","General",NULL,"1",NULL,"0","","",NULL,NULL,"47","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("166","7","","Bangla","বাংলা","701","৭০১","General",NULL,"1",NULL,"0","","",NULL,NULL,"47","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("167","7","","Bangla  Grammar","বাংলা  ব্যাকরণ","702","৭০২","General",NULL,"1",NULL,"0","","",NULL,NULL,"48","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("168","7","","English","ইংলিশ","703","৭০৩","General",NULL,"1",NULL,"0","","",NULL,NULL,"48","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("169","7","","My Smart English Grammar","My Smart English Grammar","704","৭০৪","General",NULL,"1",NULL,"0","","",NULL,NULL,"49","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("170","7","","Mathematics","গণিত","705","৭০৫","General",NULL,"1",NULL,"0","","",NULL,NULL,"50","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("171","7","","science","বিজ্ঞান","706","৭০৬","General",NULL,"1",NULL,"0","","",NULL,NULL,"51","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("172","7","","বাংলাদেশ ও বিশ্ব পরিচয়","বাংলাদেশ ও বিশ্ব পরিচয়","707","৭০৭","General",NULL,"1",NULL,"0","","",NULL,NULL,"53","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("173","7","","ইসলাম শিক্ষা","ইসলাম শিক্ষা","708","৭০৮","General",NULL,"1",NULL,"0","","",NULL,NULL,"53","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("174","7","","ছোটদের কম্পিউটার শিক্ষা","ছোটদের কম্পিউটার শিক্ষা","709","৭০৯","General",NULL,"1",NULL,"0","","",NULL,NULL,"55","","","","",NULL,NULL);
INSERT INTO `course_subject` (`id`, `course_id`, `religion`, `subject_name`, `subject_name_bn`, `subject_code`, `subject_code_bn`, `group_id`, `picture`, `status`, `written`, `4th_subject`, `two_in_one`, `two_in_one_2`, `viva`, `total`, `priority`, `two_in_one_3`, `two_in_one_4`, `two_in_one_5`, `two_in_one_6`, `class_time`, `room_no`) VALUES("175","7","","ছোটদের সাধারণ জ্ঞান","ছোটদের সাধারণ জ্ঞান","710","৭১০","General",NULL,"1",NULL,"0","","",NULL,NULL,"56","","","","",NULL,NULL);


-- Table structure for table `custom_sms`
DROP TABLE IF EXISTS `custom_sms`;
CREATE TABLE `custom_sms` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` varchar(250) DEFAULT NULL,
  `status` varchar(250) NOT NULL DEFAULT '1',
  `sms` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `custom_sms`
INSERT INTO `custom_sms` (`id`, `type`, `status`, `sms`) VALUES("2","teacher","1","এখানে কাষ্টম এসএমএস লিখতে পারবেন");
INSERT INTO `custom_sms` (`id`, `type`, `status`, `sms`) VALUES("3","student","1","Dear  `student_name` ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  `student_id`");
INSERT INTO `custom_sms` (`id`, `type`, `status`, `sms`) VALUES("4","user","1","আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান । একজন অভিভাবক হিসাবে আপনার প্রধান দায়িত্ব।");


-- Table structure for table `daily_study_v3`
DROP TABLE IF EXISTS `daily_study_v3`;
CREATE TABLE `daily_study_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course` int(11) NOT NULL,
  `branch` int(11) NOT NULL,
  `course_subject` int(11) NOT NULL,
  `date` date NOT NULL,
  `topic` varchar(300) NOT NULL,
  `details` text NOT NULL,
  `type` varchar(200) NOT NULL,
  `attachment` varchar(500) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `daily_study_v3`
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("1","3","1","18","2025-01-02","fdxgbfcx","gcxfbvcbn111111111111111111111","Home Work","4679862551download.png");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("8","3","5","21","2025-01-02","xzv","xvxcv","","Screenshot_5.png");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("9","3","5","21","2025-01-02","xzv","xvxcv","","168666445Screenshot_5.png");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("10","3","1","23","2025-01-02","fdxgbfcx","dxfdf","","479888102Screenshot_5.png");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("11","3","1","23","2025-01-02","fdxgbfcx","dxfdf","","1134187533Screenshot_5.png");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("12","3","1","23","2025-01-02","fdxgbfcx","fdsf","","");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("13","3","5","22","2025-01-02","sdaasda","dasd","","1418517119Screenshot_2.png");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("16","3","7","21","2025-01-02","fdxgbfcx","cxfgh","Class Test","1838744830_20_frd_1690101871.jpg");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("17","3","7","21","2025-01-02","fdxgbfcx","cxfgh","Home Work","1090605998_20_frd_1690101871.jpg");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("18","3","1","17","2025-01-07","fdxgbfcx","hhh","Home Work","14264393391download.png");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("19","3","1","17","2025-01-11","টেস্ট করার জন্য","বই -৩১ পিষ্টা","Class Test","185822426088.png");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("20","3","1","44","2025-04-04","function con($query) {     global $con;     return mysqli_query($con, $query); }  function row($query) {     return mysqli_fetch_assoc($query); }","function con($query)
\n{
\n    global $con;
\n    return mysqli_query($con, $query);
\n}
\n
\nfunction row($query)
\n{
\n    return mysqli_fetch_assoc($query);
\n}
\n","Home Work","342010631LMC_20250331_140847_COLOUR BOOST x GCAMTHEBOSS jpeg .jpg");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("21","3","1","44","2025-04-06","Add Daily Study","Add Daily Study
\nAdd Daily Study
\nAdd Daily Study
\nAdd Daily Study
\nAdd Daily Study
\nAdd Daily Study
\n","Class Test","1223499674Screenshot_2-removebg-preview.png");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("22","3","1","23","2025-04-07","Add Daily Study","Add Daily Study
\n","Home Work","");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("23","7","1","170","2025-08-02","গণিগ","গণিত অ্যাধায় ৭ম ","Home Work","");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("24","7","1","170","2025-08-13","অধ্যায় ১.১","গণিত অংক ১,২,৩,","Home Work","");
INSERT INTO `daily_study_v3` (`id`, `course`, `branch`, `course_subject`, `date`, `topic`, `details`, `type`, `attachment`) VALUES("25","4","1","121","2025-11-16","অধ্যায় ৩","১, ২ নম্বার","Home Work","");


-- Table structure for table `description_list`
DROP TABLE IF EXISTS `description_list`;
CREATE TABLE `description_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description_name` varchar(255) DEFAULT NULL,
  `status` varchar(11) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `des_fee` varchar(11) DEFAULT NULL,
  `payment_limited` varchar(11) DEFAULT NULL COMMENT '0= Unlomite, 1=Limite',
  `course_id` varchar(11) DEFAULT NULL,
  `course_year` varchar(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8;

-- Dumping data for table `description_list`
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("14","Admission Fee","0","","200","0","3","2024");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("15","Session Fee","0","","300","1","3","2024");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("16","Stationary/Certificate/TC","0","","500","1","3","2024");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("17","Dress/hijab/cap","0","","500","1","3","2024");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("18","Exam Fee",NULL,"","300","0","3","2024");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("19","Monthly Fee",NULL,"","10","0","3","2024");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("20","Edu.epuipment",NULL,"","300","1","3","2024");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("22","Admit Card Fee",NULL,"12","20","0","3","2024");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("23","Admission Fee",NULL,"","200","0","1","2024");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("30","Course & Tuition Fees",NULL,"102","500","1","3","2024");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("31","tttt",NULL,"","300","0","3","2024");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("32","Admission Fee",NULL,"","300","0","4","2025");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("34","ভর্তি ফি",NULL,"","200","","5","2025");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("35","সেশন ফি",NULL,"","300","","5","2025");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("36","মাসিক বেতন",NULL,"","500","","5","2025");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("37","প্রথম সাময়িক পরীক্ষার ফি",NULL,"","300","","5","2025");
INSERT INTO `description_list` (`id`, `description_name`, `status`, `key`, `des_fee`, `payment_limited`, `course_id`, `course_year`) VALUES("38","প্রবেশ ফি",NULL,"","150","","5","2025");


-- Table structure for table `device_connect`
DROP TABLE IF EXISTS `device_connect`;
CREATE TABLE `device_connect` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `person_name` varchar(250) DEFAULT NULL,
  `gender` varchar(250) DEFAULT NULL,
  `contact` varchar(250) DEFAULT NULL,
  `person_id` int(20) DEFAULT NULL,
  `person_type` varchar(100) DEFAULT NULL,
  `card_no` varchar(250) DEFAULT NULL,
  `uni_id` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `device_connect`
INSERT INTO `device_connect` (`id`, `person_name`, `gender`, `contact`, `person_id`, `person_type`, `card_no`, `uni_id`) VALUES("70","Md Aminur Rahman","1","01","170","student","","3");
INSERT INTO `device_connect` (`id`, `person_name`, `gender`, `contact`, `person_id`, `person_type`, `card_no`, `uni_id`) VALUES("71","Md Ashraful Islam","1","01","169","student","","2");
INSERT INTO `device_connect` (`id`, `person_name`, `gender`, `contact`, `person_id`, `person_type`, `card_no`, `uni_id`) VALUES("72","Md Rofiqul Islam","1","01","173","student","","6");
INSERT INTO `device_connect` (`id`, `person_name`, `gender`, `contact`, `person_id`, `person_type`, `card_no`, `uni_id`) VALUES("73","Md Shagor Islam","1","01","174","student","","7");
INSERT INTO `device_connect` (`id`, `person_name`, `gender`, `contact`, `person_id`, `person_type`, `card_no`, `uni_id`) VALUES("74","Mst Amina Begum","1","01","172","student","","5");
INSERT INTO `device_connect` (`id`, `person_name`, `gender`, `contact`, `person_id`, `person_type`, `card_no`, `uni_id`) VALUES("75","Mst Janatul Mina","1","01","171","student","0013855409","4");
INSERT INTO `device_connect` (`id`, `person_name`, `gender`, `contact`, `person_id`, `person_type`, `card_no`, `uni_id`) VALUES("77","Mst Amina Begum","1","01","172","student","5240485","5");


-- Table structure for table `discount`
DROP TABLE IF EXISTS `discount`;
CREATE TABLE `discount` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `student_id` int(10) DEFAULT NULL,
  `description_id` int(20) NOT NULL,
  `percent` varchar(100) DEFAULT NULL,
  `amount` varchar(250) DEFAULT NULL,
  `date` varchar(250) DEFAULT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `discount`


-- Table structure for table `donar`
DROP TABLE IF EXISTS `donar`;
CREATE TABLE `donar` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `mobile` varchar(100) DEFAULT NULL,
  `duration` varchar(100) DEFAULT NULL,
  `address` varchar(150) DEFAULT NULL,
  `add_date` varchar(100) DEFAULT NULL,
  `update_date` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `donar`
INSERT INTO `donar` (`id`, `name`, `mobile`, `duration`, `address`, `add_date`, `update_date`) VALUES("4","জিয়ারুল ইসলাম ভাই-পিরগঞ্জ","01717452764","0","রংপুর","2023-11-15","2024-01-22");


-- Table structure for table `exam_publish_date`
DROP TABLE IF EXISTS `exam_publish_date`;
CREATE TABLE `exam_publish_date` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(100) DEFAULT NULL,
  `exam_year` varchar(100) DEFAULT NULL,
  `publish_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `exam_name` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `exam_publish_date`


-- Table structure for table `exam_result_v3`
DROP TABLE IF EXISTS `exam_result_v3`;
CREATE TABLE `exam_result_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` varchar(11) DEFAULT NULL,
  `course` varchar(200) DEFAULT NULL,
  `subject` varchar(200) DEFAULT NULL,
  `year` varchar(200) DEFAULT NULL,
  `exam_id` varchar(200) DEFAULT NULL,
  `cq` varchar(200) DEFAULT NULL,
  `mcq` varchar(200) DEFAULT NULL,
  `practical` varchar(200) DEFAULT NULL,
  `oral` varchar(20) DEFAULT NULL,
  `total` varchar(200) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  `regi_id` varchar(255) DEFAULT NULL,
  `attendance` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=893 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `exam_result_v3`
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("1","1","1","51","2025","1","32","30","20","0","82","2025-06-09 03:44:12",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("2","2","1","51","2025","1","35","30","20","0","85","2025-06-09 03:44:12",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("3","3","1","51","2025","1","30","30","20","0","80","2025-06-09 03:44:12",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("4","1","1","52","2025","1","32","30","20","0","82","2025-06-09 03:44:36",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("5","2","1","52","2025","1","35","30","20","0","85","2025-06-09 03:44:36",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("6","3","1","52","2025","1","30","30","20","0","80","2025-06-09 03:44:36",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("7","20","4","70","2025","1","0","0","0","80","80","2025-07-25 12:25:56","2","1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("8","20","4","71","2025","1","1","0","0","0","51","2025-07-25 12:25:56","2","0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("9","23","1","63","2025","1","0","0","0","33","33","2025-07-25 18:29:41",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("10","32","1","63","2025","1","0","0","0","40","40","2025-07-25 18:29:41",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("11","33","1","63","2025","1","0","0","0","0","0","2025-07-25 18:29:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("12","34","1","63","2025","1","0","0","0","0","0","2025-07-25 18:29:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("13","35","1","63","2025","1","0","0","0","0","0","2025-07-25 18:29:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("14","36","1","63","2025","1","0","0","0","0","0","2025-07-25 18:29:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("15","37","1","63","2025","1","0","0","0","0","0","2025-07-25 18:29:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("16","38","1","63","2025","1","0","0","0","0","0","2025-07-25 18:29:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("17","39","1","63","2025","1","0","0","0","0","0","2025-07-25 18:29:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("18","40","1","63","2025","1","0","0","0","0","0","2025-07-25 18:29:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("19","24","1","63","2025","1","0","0","0","0","0","2025-07-25 18:29:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("20","41","1","63","2025","1","0","0","0","0","0","2025-07-25 18:29:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("21","42","1","63","2025","1","0","0","0","0","0","2025-07-25 18:29:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("22","43","1","63","2025","1","0","0","0","0","0","2025-07-25 18:29:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("23","44","1","63","2025","1","0","0","0","0","0","2025-07-25 18:29:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("24","45","1","63","2025","1","0","0","0","0","0","2025-07-25 18:29:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("25","25","1","63","2025","1","0","0","0","0","0","2025-07-25 18:29:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("26","26","1","63","2025","1","0","0","0","0","0","2025-07-25 18:29:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("27","27","1","63","2025","1","0","0","0","0","0","2025-07-25 18:29:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("28","28","1","63","2025","1","0","0","0","0","0","2025-07-25 18:29:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("29","29","1","63","2025","1","0","0","0","0","0","2025-07-25 18:29:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("30","30","1","63","2025","1","0","0","0","0","0","2025-07-25 18:29:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("31","31","1","63","2025","1","0","0","0","0","0","2025-07-25 18:29:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("32","23","1","51","2025","2","0","0","0","50","50","2025-07-27 11:22:04",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("33","32","1","51","2025","2","0","0","0","33","33","2025-07-27 11:22:04",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("34","33","1","51","2025","2","0","0","0","55","55","2025-07-27 11:22:04",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("35","34","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("36","35","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("37","36","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("38","37","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("39","38","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("40","39","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("41","40","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("42","24","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("43","41","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("44","42","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("45","43","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("46","44","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("47","45","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("48","46","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("49","47","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("50","48","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("51","49","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("52","50","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("53","25","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("54","51","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("55","57","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("56","58","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("57","59","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("58","26","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("59","27","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("60","28","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("61","29","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("62","30","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("63","31","1","51","2025","2","0","0","0","0","0","2025-07-27 11:22:04",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("64","23","1","52","2025","2","0","0","0","50","50","2025-07-27 11:22:38",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("65","32","1","52","2025","2","0","0","0","80","80","2025-07-27 11:22:38",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("66","33","1","52","2025","2","0","0","0","55","55","2025-07-27 11:22:38",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("67","34","1","52","2025","2","0","0","0","30","30","2025-07-27 11:22:38",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("68","35","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("69","36","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("70","37","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("71","38","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("72","39","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("73","40","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("74","24","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("75","41","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("76","42","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("77","43","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("78","44","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("79","45","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("80","46","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("81","47","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("82","48","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("83","49","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("84","50","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("85","25","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("86","51","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("87","57","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("88","58","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("89","59","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("90","26","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("91","27","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("92","28","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("93","29","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("94","30","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("95","31","1","52","2025","2","0","0","0","0","0","2025-07-27 11:22:38",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("96","23","1","63","2025","2","0","0","0","33","33","2025-07-27 11:23:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("97","32","1","63","2025","2","0","0","0","50","50","2025-07-27 11:23:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("98","33","1","63","2025","2","0","0","0","40","40","2025-07-27 11:23:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("99","34","1","63","2025","2","0","0","0","30","30","2025-07-27 11:23:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("100","35","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("101","36","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("102","37","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("103","38","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("104","39","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("105","40","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("106","24","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("107","41","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("108","42","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("109","43","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("110","44","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("111","45","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("112","46","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("113","47","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("114","48","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("115","49","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("116","50","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("117","25","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("118","51","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("119","57","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("120","58","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("121","59","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("122","26","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("123","27","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("124","28","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("125","29","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("126","30","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("127","31","1","63","2025","2","0","0","0","0","0","2025-07-27 11:23:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("128","23","1","119","2025","2","0","0","0","80","80","2025-07-28 14:17:53",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("129","32","1","119","2025","2","0","0","0","90","90","2025-07-28 14:17:53",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("130","33","1","119","2025","2","0","0","0","78","78","2025-07-28 14:17:53",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("131","34","1","119","2025","2","0","0","0","78","78","2025-07-28 14:17:53",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("132","35","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("133","36","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("134","37","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("135","38","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("136","39","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("137","40","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("138","24","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("139","41","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("140","42","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("141","43","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("142","44","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("143","45","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("144","46","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("145","47","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("146","48","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("147","49","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("148","50","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("149","25","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("150","51","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("151","57","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("152","58","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("153","59","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("154","26","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("155","27","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("156","28","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("157","29","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("158","30","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("159","31","1","119","2025","2","0","0","0","0","0","2025-07-28 14:17:53",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("160","23","1","120","2025","2","0","0","0","40","40","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("161","32","1","120","2025","2","0","0","0","56","56","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("162","33","1","120","2025","2","0","0","0","80","80","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("163","34","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("164","35","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("165","36","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("166","37","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("167","38","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("168","39","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("169","40","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("170","24","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("171","41","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("172","42","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("173","43","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("174","44","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("175","45","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("176","46","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("177","47","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("178","48","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("179","49","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("180","50","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("181","25","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("182","51","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("183","57","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("184","58","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("185","59","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("186","26","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("187","27","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("188","28","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("189","29","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("190","30","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("191","31","1","120","2025","2","0","0","0","0","0","2025-07-28 14:18:19",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("192","23","1","121","2025","2","0","0","0","48","48","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("193","32","1","121","2025","2","0","0","0","50","50","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("194","33","1","121","2025","2","0","0","0","80","80","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("195","34","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("196","35","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("197","36","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("198","37","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("199","38","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("200","39","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("201","40","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("202","24","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("203","41","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("204","42","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("205","43","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("206","44","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("207","45","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("208","46","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("209","47","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("210","48","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("211","49","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("212","50","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("213","25","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("214","51","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("215","57","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("216","58","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("217","59","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("218","26","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("219","27","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("220","28","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("221","29","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("222","30","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("223","31","1","121","2025","2","0","0","0","0","0","2025-07-28 14:18:41",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("224","97","1","119","2025","2","0","0","0","0","0","2025-07-31 16:08:34",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("225","20","4","135","2025","2","0","0","0","90","90","2025-08-01 08:19:58",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("226","52","4","135","2025","2","0","0","0","99","99","2025-08-01 08:19:58",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("227","53","4","135","2025","2","0","0","0","0","0","2025-08-01 08:19:58",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("228","54","4","135","2025","2","0","0","0","0","0","2025-08-01 08:19:58",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("229","60","4","135","2025","2","0","0","0","0","0","2025-08-01 08:19:58",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("230","61","4","135","2025","2","0","0","0","0","0","2025-08-01 08:19:58",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("231","20","4","136","2025","2","0","0","0","99","99","2025-08-01 08:21:46",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("232","52","4","136","2025","2","0","0","0","0","0","2025-08-01 08:21:46",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("233","53","4","136","2025","2","0","0","0","0","0","2025-08-01 08:21:46",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("234","54","4","136","2025","2","0","0","0","0","0","2025-08-01 08:21:46",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("235","60","4","136","2025","2","0","0","0","0","0","2025-08-01 08:21:46",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("236","61","4","136","2025","2","0","0","0","0","0","2025-08-01 08:21:46",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("237","20","4","137","2025","2","0","0","0","99","99","2025-08-01 08:22:06",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("238","52","4","137","2025","2","0","0","0","0","0","2025-08-01 08:22:06",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("239","53","4","137","2025","2","0","0","0","0","0","2025-08-01 08:22:06",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("240","54","4","137","2025","2","0","0","0","0","0","2025-08-01 08:22:06",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("241","60","4","137","2025","2","0","0","0","0","0","2025-08-01 08:22:06",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("242","61","4","137","2025","2","0","0","0","0","0","2025-08-01 08:22:06",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("243","20","4","139","2025","2","0","0","0","86","86","2025-08-01 08:22:56",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("244","52","4","139","2025","2","0","0","0","0","0","2025-08-01 08:22:56",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("245","53","4","139","2025","2","0","0","0","0","0","2025-08-01 08:22:56",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("246","54","4","139","2025","2","0","0","0","0","0","2025-08-01 08:22:56",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("247","60","4","139","2025","2","0","0","0","0","0","2025-08-01 08:22:56",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("248","61","4","139","2025","2","0","0","0","0","0","2025-08-01 08:22:56",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("249","20","4","143","2025","2","0","0","0","60","60","2025-08-01 17:32:17",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("250","52","4","143","2025","2","0","0","0","90","90","2025-08-01 17:32:17",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("251","53","4","143","2025","2","0","0","0","80","80","2025-08-01 17:32:17",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("252","54","4","143","2025","2","0","0","0","53","53","2025-08-01 17:32:17",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("253","60","4","143","2025","2","0","0","0","8","8","2025-08-01 17:32:17",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("254","61","4","143","2025","2","0","0","0","0","0","2025-08-01 17:32:17",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("255","62","7","166","2025","6","0","0","0","80","80","2025-08-05 07:59:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("256","63","7","166","2025","6","0","0","0","60","60","2025-08-05 07:59:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("257","64","7","166","2025","6","0","0","0","0","0","2025-08-05 07:59:27",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("258","65","7","166","2025","6","0","0","0","0","0","2025-08-05 07:59:27",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("259","62","7","170","2025","6","0","0","0","50","50","2025-08-05 10:52:21",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("260","63","7","170","2025","6","0","0","0","30","30","2025-08-05 10:52:21",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("261","64","7","170","2025","6","0","0","0","56","56","2025-08-05 10:52:21",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("262","65","7","170","2025","6","0","0","0","90","90","2025-08-05 10:52:21",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("263","20","4","141","2025","2","0","0","0","80","80","2025-09-22 16:03:35",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("264","54","4","141","2025","2","0","0","0","0","0","2025-09-22 16:03:35",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("265","53","4","141","2025","2","0","0","0","0","0","2025-09-22 16:03:35",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("266","52","4","141","2025","2","0","0","0","0","0","2025-09-22 16:03:35",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("267","61","4","141","2025","2","0","0","0","0","0","2025-09-22 16:03:35",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("268","60","4","141","2025","2","0","0","0","0","0","2025-09-22 16:03:35",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("269","23","1","119","2025","6","0","0","0","22","22","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("270","24","1","119","2025","6","0","0","0","74","74","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("271","25","1","119","2025","6","0","0","0","74","74","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("272","26","1","119","2025","6","0","0","0","72","72","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("273","27","1","119","2025","6","0","0","0","73","73","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("274","29","1","119","2025","6","0","0","0","67","67","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("275","28","1","119","2025","6","0","0","0","75","75","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("276","30","1","119","2025","6","0","0","0","76","76","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("277","31","1","119","2025","6","0","0","0","29","29","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("278","32","1","119","2025","6","0","0","0","70","70","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("279","37","1","119","2025","6","0","0","0","69","69","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("280","36","1","119","2025","6","0","0","0","22","22","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("281","35","1","119","2025","6","0","0","0","42","42","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("282","34","1","119","2025","6","0","0","0","22","22","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("283","33","1","119","2025","6","0","0","0","68","68","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("284","43","1","119","2025","6","0","0","0","57","57","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("285","42","1","119","2025","6","0","0","0","33","33","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("286","41","1","119","2025","6","0","0","0","70","70","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("287","40","1","119","2025","6","0","0","0","75","75","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("288","39","1","119","2025","6","0","0","0","74","74","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("289","38","1","119","2025","6","0","0","0","75","75","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("290","45","1","119","2025","6","0","0","0","76","76","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("291","44","1","119","2025","6","0","0","0","0","0","2025-11-01 07:32:09",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("292","51","1","119","2025","6","0","0","0","33","33","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("293","50","1","119","2025","6","0","0","0","75","75","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("294","49","1","119","2025","6","0","0","0","74","74","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("295","48","1","119","2025","6","0","0","0","0","0","2025-11-01 07:32:09",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("296","47","1","119","2025","6","0","0","0","0","0","2025-11-01 07:32:09",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("297","46","1","119","2025","6","0","0","0","50","50","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("298","59","1","119","2025","6","0","0","0","41","41","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("299","58","1","119","2025","6","0","0","0","76","76","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("300","57","1","119","2025","6","0","0","0","73","73","2025-11-01 07:32:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("301","97","1","119","2025","6","0","0","0","0","0","2025-11-01 07:32:09",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("302","23","1","120","2025","6","0","0","0","33","33","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("303","24","1","120","2025","6","0","0","0","27","27","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("304","25","1","120","2025","6","0","0","0","74","74","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("305","26","1","120","2025","6","0","0","0","69","69","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("306","27","1","120","2025","6","0","0","0","70","70","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("307","29","1","120","2025","6","0","0","0","64","64","2025-11-01 08:05:48",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("308","28","1","120","2025","6","0","0","0","46","46","2025-11-01 08:05:48",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("309","30","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("310","31","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("311","32","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("312","37","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("313","36","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("314","35","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("315","34","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("316","33","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("317","43","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("318","42","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("319","41","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("320","40","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("321","39","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("322","38","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("323","45","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("324","44","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("325","51","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("326","50","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("327","49","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("328","48","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("329","47","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("330","46","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("331","59","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("332","58","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("333","57","1","120","2025","6","0","0","0","52","52","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("334","97","1","120","2025","6","0","0","0","0","0","2025-11-01 08:05:48",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("335","23","1","121","2025","6","0","0","0","33","33","2025-11-01 08:06:14",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("336","24","1","121","2025","6","0","0","0","41","41","2025-11-01 08:06:14",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("337","25","1","121","2025","6","0","0","0","77","77","2025-11-01 08:06:14",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("338","26","1","121","2025","6","0","0","0","73","73","2025-11-01 08:06:14",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("339","27","1","121","2025","6","0","0","0","59","59","2025-11-01 08:06:14",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("340","29","1","121","2025","6","0","0","0","54","54","2025-11-01 08:06:14",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("341","28","1","121","2025","6","0","0","0","75","75","2025-11-01 08:06:14",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("342","30","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("343","31","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("344","32","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("345","37","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("346","36","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("347","35","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("348","34","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("349","33","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("350","43","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("351","42","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("352","41","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("353","40","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("354","39","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("355","38","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("356","45","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("357","44","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("358","51","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("359","50","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("360","49","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("361","48","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("362","47","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("363","46","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("364","59","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("365","58","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("366","57","1","121","2025","6","0","0","0","66","66","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("367","97","1","121","2025","6","0","0","0","0","0","2025-11-01 08:06:14",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("368","94","3","127","2025","2","0","0","0","33","33","2025-11-16 17:33:58",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("369","93","3","127","2025","2","0","0","0","33","33","2025-11-16 17:33:58",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("370","92","3","127","2025","2","0","0","0","33","33","2025-11-16 17:33:58",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("371","95","3","127","2025","2","0","0","0","33","33","2025-11-16 17:33:58",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("372","96","3","127","2025","2","0","0","0","33","33","2025-11-16 17:33:58",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("373","101","3","127","2025","2","0","0","0","33","33","2025-11-16 17:33:58",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("374","155","1","119","2025","2","0","0","0","85","85","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("375","153","1","119","2025","2","0","0","0","0","0","2025-11-24 05:14:27",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("376","151","1","119","2025","2","0","0","0","0","0","2025-11-24 05:14:27",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("377","149","1","119","2025","2","0","0","0","99","99","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("378","157","1","119","2025","2","0","0","0","99","99","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("379","147","1","119","2025","2","0","0","0","99","99","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("380","145","1","119","2025","2","0","0","0","99","99","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("381","142","1","119","2025","2","0","0","0","72","72","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("382","141","1","119","2025","2","0","0","0","98","98","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("383","138","1","119","2025","2","0","0","0","99","99","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("384","136","1","119","2025","2","0","0","0","97","97","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("385","158","1","119","2025","2","0","0","0","95","95","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("386","161","1","119","2025","2","0","0","0","48","48","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("387","159","1","119","2025","2","0","0","0","63","63","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("388","162","1","119","2025","2","0","0","0","99","99","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("389","160","1","119","2025","2","0","0","0","85","85","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("390","200","1","119","2025","2","0","0","0","94","94","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("391","199","1","119","2025","2","0","0","0","0","0","2025-11-24 05:14:27",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("392","198","1","119","2025","2","0","0","0","0","0","2025-11-24 05:14:27",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("393","197","1","119","2025","2","0","0","0","97","97","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("394","196","1","119","2025","2","0","0","0","97","97","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("395","195","1","119","2025","2","0","0","0","99","99","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("396","194","1","119","2025","2","0","0","0","85","85","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("397","193","1","119","2025","2","0","0","0","99","99","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("398","192","1","119","2025","2","0","0","0","0","0","2025-11-24 05:14:27",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("399","190","1","119","2025","2","0","0","0","97","97","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("400","187","1","119","2025","2","0","0","0","92","92","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("401","185","1","119","2025","2","0","0","0","95","95","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("402","184","1","119","2025","2","0","0","0","87","87","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("403","183","1","119","2025","2","0","0","0","99","99","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("404","182","1","119","2025","2","0","0","0","97","97","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("405","181","1","119","2025","2","0","0","0","98","98","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("406","191","1","119","2025","2","0","0","0","80","80","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("407","189","1","119","2025","2","0","0","0","99","99","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("408","188","1","119","2025","2","0","0","0","97","97","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("409","180","1","119","2025","2","0","0","0","99","99","2025-11-24 05:14:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("410","167","4","135","2025","2","0","0","0","93","93","2025-11-24 07:30:38",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("411","166","4","135","2025","2","0","0","0","92","92","2025-11-24 07:30:38",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("412","164","4","135","2025","2","0","0","0","75","75","2025-11-24 07:30:38",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("413","163","4","135","2025","2","0","0","0","79","79","2025-11-24 07:30:38",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("414","165","4","135","2025","2","0","0","0","97","97","2025-11-24 07:30:38",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("415","186","4","135","2025","2","0","0","0","79","79","2025-11-24 07:30:38",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("416","155","1","121","2025","2","0","0","0","94","94","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("417","153","1","121","2025","2","0","0","0","0","0","2025-11-25 15:39:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("418","151","1","121","2025","2","0","0","0","0","0","2025-11-25 15:39:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("419","149","1","121","2025","2","0","0","0","97","97","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("420","157","1","121","2025","2","0","0","0","99","99","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("421","147","1","121","2025","2","0","0","0","94","94","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("422","145","1","121","2025","2","0","0","0","99","99","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("423","142","1","121","2025","2","0","0","0","86","86","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("424","141","1","121","2025","2","0","0","0","96","96","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("425","138","1","121","2025","2","0","0","0","99","99","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("426","136","1","121","2025","2","0","0","0","99","99","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("427","158","1","121","2025","2","0","0","0","72","72","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("428","161","1","121","2025","2","0","0","0","53","53","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("429","159","1","121","2025","2","0","0","0","60","60","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("430","162","1","121","2025","2","0","0","0","52","52","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("431","160","1","121","2025","2","0","0","0","94","94","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("432","200","1","121","2025","2","0","0","0","97","97","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("433","199","1","121","2025","2","0","0","0","0","0","2025-11-25 15:39:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("434","198","1","121","2025","2","0","0","0","0","0","2025-11-25 15:39:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("435","197","1","121","2025","2","0","0","0","96","96","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("436","196","1","121","2025","2","0","0","0","96","96","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("437","195","1","121","2025","2","0","0","0","99","99","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("438","194","1","121","2025","2","0","0","0","89","89","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("439","193","1","121","2025","2","0","0","0","98","98","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("440","192","1","121","2025","2","0","0","0","0","0","2025-11-25 15:39:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("441","190","1","121","2025","2","0","0","0","99","99","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("442","187","1","121","2025","2","0","0","0","93","93","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("443","185","1","121","2025","2","0","0","0","99","99","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("444","184","1","121","2025","2","0","0","0","90","90","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("445","183","1","121","2025","2","0","0","0","98","98","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("446","182","1","121","2025","2","0","0","0","98","98","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("447","181","1","121","2025","2","0","0","0","96","96","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("448","191","1","121","2025","2","0","0","0","80","80","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("449","189","1","121","2025","2","0","0","0","98","98","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("450","188","1","121","2025","2","0","0","0","96","96","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("451","180","1","121","2025","2","0","0","0","98","98","2025-11-25 15:39:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("452","203","1","121","2025","2","0","0","0","0","0","2025-11-25 15:39:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("453","204","1","121","2025","2","0","0","0","0","0","2025-11-25 15:39:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("454","205","1","121","2025","2","0","0","0","0","0","2025-11-25 15:39:07",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("455","155","1","120","2025","2","0","0","0","85","85","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("456","153","1","120","2025","2","0","0","0","0","0","2025-11-25 15:55:33",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("457","151","1","120","2025","2","0","0","0","0","0","2025-11-25 15:55:33",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("458","149","1","120","2025","2","0","0","0","99","99","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("459","157","1","120","2025","2","0","0","0","99","99","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("460","147","1","120","2025","2","0","0","0","99","99","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("461","145","1","120","2025","2","0","0","0","99","99","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("462","142","1","120","2025","2","0","0","0","63","63","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("463","141","1","120","2025","2","0","0","0","98","98","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("464","138","1","120","2025","2","0","0","0","99","99","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("465","136","1","120","2025","2","0","0","0","97","97","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("466","158","1","120","2025","2","0","0","0","95","95","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("467","161","1","120","2025","2","0","0","0","48","48","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("468","159","1","120","2025","2","0","0","0","63","63","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("469","162","1","120","2025","2","0","0","0","74","74","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("470","160","1","120","2025","2","0","0","0","85","85","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("471","200","1","120","2025","2","0","0","0","94","94","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("472","199","1","120","2025","2","0","0","0","0","0","2025-11-25 15:55:33",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("473","198","1","120","2025","2","0","0","0","0","0","2025-11-25 15:55:33",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("474","197","1","120","2025","2","0","0","0","99","99","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("475","196","1","120","2025","2","0","0","0","99","99","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("476","195","1","120","2025","2","0","0","0","99","99","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("477","194","1","120","2025","2","0","0","0","85","85","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("478","193","1","120","2025","2","0","0","0","99","99","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("479","192","1","120","2025","2","0","0","0","0","0","2025-11-25 15:55:33",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("480","190","1","120","2025","2","0","0","0","97","97","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("481","187","1","120","2025","2","0","0","0","92","92","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("482","185","1","120","2025","2","0","0","0","95","95","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("483","184","1","120","2025","2","0","0","0","92","92","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("484","183","1","120","2025","2","0","0","0","99","99","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("485","182","1","120","2025","2","0","0","0","96","96","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("486","181","1","120","2025","2","0","0","0","98","98","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("487","191","1","120","2025","2","0","0","0","75","75","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("488","189","1","120","2025","2","0","0","0","99","99","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("489","188","1","120","2025","2","0","0","0","97","97","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("490","180","1","120","2025","2","0","0","0","99","99","2025-11-25 15:55:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("491","203","1","120","2025","2","0","0","0","0","0","2025-11-25 15:55:33",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("492","204","1","120","2025","2","0","0","0","0","0","2025-11-25 15:55:33",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("493","205","1","120","2025","2","0","0","0","0","0","2025-11-25 15:55:33",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("494","203","1","119","2025","2","0","0","0","0","0","2025-11-25 15:57:57",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("495","204","1","119","2025","2","0","0","0","0","0","2025-11-25 15:57:57",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("496","205","1","119","2025","2","0","0","0","0","0","2025-11-25 15:57:57",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("497","208","1","119","2025","2","0","0","0","91","91","2025-11-27 13:45:50",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("498","207","1","119","2025","2","0","0","0","65","65","2025-11-27 13:45:50",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("499","206","1","119","2025","2","0","0","0","72","72","2025-11-27 13:45:50",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("500","167","4","141","2025","2","0","0","0","98","98","2025-11-27 13:48:46",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("501","166","4","141","2025","2","0","0","0","97","97","2025-11-27 13:48:46",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("502","164","4","141","2025","2","0","0","0","72","72","2025-11-27 13:48:46",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("503","163","4","141","2025","2","0","0","0","93","93","2025-11-27 13:48:46",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("504","165","4","141","2025","2","0","0","0","99","99","2025-11-27 13:48:46",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("505","186","4","141","2025","2","0","0","0","69","69","2025-11-27 13:48:46",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("506","156","2","125","2025","2","0","0","0","25","25","2025-11-27 13:57:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("507","154","2","125","2025","2","0","0","0","30","30","2025-11-27 13:57:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("508","152","2","125","2025","2","0","0","0","27","27","2025-11-27 13:57:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("509","150","2","125","2025","2","0","0","0","27","27","2025-11-27 13:57:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("510","148","2","125","2025","2","0","0","0","28","28","2025-11-27 13:57:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("511","146","2","125","2025","2","0","0","0","20","20","2025-11-27 13:57:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("512","144","2","125","2025","2","0","0","0","27","27","2025-11-27 13:57:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("513","143","2","125","2025","2","0","0","0","28","28","2025-11-27 13:57:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("514","140","2","125","2025","2","0","0","0","30","30","2025-11-27 13:57:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("515","139","2","125","2025","2","0","0","0","28","28","2025-11-27 13:57:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("516","137","2","125","2025","2","0","0","0","20","20","2025-11-27 13:57:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("517","134","2","125","2025","2","0","0","0","24","24","2025-11-27 13:57:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("518","135","2","125","2025","2","0","0","0","26","26","2025-11-27 13:57:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("519","201","2","125","2025","2","0","0","0","26","26","2025-11-27 13:57:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("520","209","2","125","2025","2","0","0","0","27","27","2025-11-27 13:57:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("521","156","2","126","2025","2","0","0","0","74","74","2025-11-27 14:07:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("522","154","2","126","2025","2","0","0","0","99","99","2025-11-27 14:07:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("523","152","2","126","2025","2","0","0","0","95","95","2025-11-27 14:07:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("524","150","2","126","2025","2","0","0","0","84","84","2025-11-27 14:07:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("525","148","2","126","2025","2","0","0","0","91","91","2025-11-27 14:07:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("526","146","2","126","2025","2","0","0","0","80","80","2025-11-27 14:07:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("527","144","2","126","2025","2","0","0","0","92","92","2025-11-27 14:07:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("528","143","2","126","2025","2","0","0","0","95","95","2025-11-27 14:07:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("529","140","2","126","2025","2","0","0","0","99","99","2025-11-27 14:07:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("530","139","2","126","2025","2","0","0","0","94","94","2025-11-27 14:07:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("531","137","2","126","2025","2","0","0","0","78","78","2025-11-27 14:07:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("532","134","2","126","2025","2","0","0","0","93","93","2025-11-27 14:07:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("533","135","2","126","2025","2","0","0","0","77","77","2025-11-27 14:07:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("534","201","2","126","2025","2","0","0","0","99","99","2025-11-27 14:07:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("535","209","2","126","2025","2","0","0","0","90","90","2025-11-27 14:07:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("536","156","2","122","2025","2","0","0","0","93","93","2025-11-27 14:13:02",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("537","154","2","122","2025","2","0","0","0","98","98","2025-11-27 14:13:02",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("538","152","2","122","2025","2","0","0","0","97","97","2025-11-27 14:13:02",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("539","150","2","122","2025","2","0","0","0","95","95","2025-11-27 14:13:02",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("540","148","2","122","2025","2","0","0","0","96","96","2025-11-27 14:13:02",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("541","146","2","122","2025","2","0","0","0","86","86","2025-11-27 14:13:02",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("542","144","2","122","2025","2","0","0","0","97","97","2025-11-27 14:13:02",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("543","143","2","122","2025","2","0","0","0","97","97","2025-11-27 14:13:02",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("544","140","2","122","2025","2","0","0","0","99","99","2025-11-27 14:13:02",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("545","139","2","122","2025","2","0","0","0","97","97","2025-11-27 14:13:02",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("546","137","2","122","2025","2","0","0","0","89","89","2025-11-27 14:13:02",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("547","134","2","122","2025","2","0","0","0","88","88","2025-11-27 14:13:02",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("548","135","2","122","2025","2","0","0","0","93","93","2025-11-27 14:13:02",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("549","201","2","122","2025","2","0","0","0","95","95","2025-11-27 14:13:02",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("550","209","2","122","2025","2","0","0","0","94","94","2025-11-27 14:13:02",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("551","211","7","172","2025","2","0","0","0","53","53","2025-11-29 08:49:00",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("552","210","7","172","2025","2","0","0","0","86","86","2025-11-29 08:49:00",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("553","212","7","172","2025","2","0","0","0","51","51","2025-11-29 08:49:00",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("554","211","7","166","2025","2","0","0","0","75","75","2025-11-29 08:50:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("555","210","7","166","2025","2","0","0","0","88","88","2025-11-29 08:50:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("556","212","7","166","2025","2","0","0","0","67","67","2025-11-29 08:50:09",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("557","211","7","168","2025","2","0","0","0","61","61","2025-11-29 08:51:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("558","210","7","168","2025","2","0","0","0","78","78","2025-11-29 08:51:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("559","212","7","168","2025","2","0","0","0","33","33","2025-11-29 08:51:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("560","211","7","169","2025","2","0","0","0","70","70","2025-11-29 08:52:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("561","210","7","169","2025","2","0","0","0","84","84","2025-11-29 08:52:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("562","212","7","169","2025","2","0","0","0","49","49","2025-11-29 08:52:07",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("563","179","5","146","2025","2","0","0","0","84","84","2025-11-29 08:57:57",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("564","178","5","146","2025","2","0","0","0","42","42","2025-11-29 08:57:57",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("565","177","5","146","2025","2","0","0","0","71","71","2025-11-29 08:57:57",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("566","174","5","146","2025","2","0","0","0","96","96","2025-11-29 08:57:57",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("567","171","5","146","2025","2","0","0","0","86","86","2025-11-29 08:57:57",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("568","170","5","146","2025","2","0","0","0","95","95","2025-11-29 08:57:57",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("569","169","5","146","2025","2","0","0","0","49","49","2025-11-29 08:57:57",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("570","168","5","146","2025","2","0","0","0","96","96","2025-11-29 08:57:57",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("571","176","5","146","2025","2","0","0","0","79","79","2025-11-29 08:57:57",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("572","175","5","146","2025","2","0","0","0","80","80","2025-11-29 08:57:57",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("573","173","5","146","2025","2","0","0","0","76","76","2025-11-29 08:57:57",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("574","172","5","146","2025","2","0","0","0","48","48","2025-11-29 08:57:57",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("575","202","5","146","2025","2","0","0","0","49","49","2025-11-29 08:57:57",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("576","179","5","147","2025","2","0","0","0","88","88","2025-11-29 09:01:11",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("577","178","5","147","2025","2","0","0","0","40","40","2025-11-29 09:01:11",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("578","177","5","147","2025","2","0","0","0","55","55","2025-11-29 09:01:11",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("579","174","5","147","2025","2","0","0","0","87","87","2025-11-29 09:01:11",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("580","171","5","147","2025","2","0","0","0","91","91","2025-11-29 09:01:11",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("581","170","5","147","2025","2","0","0","0","93","93","2025-11-29 09:01:11",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("582","169","5","147","2025","2","0","0","0","69","69","2025-11-29 09:01:11",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("583","168","5","147","2025","2","0","0","0","90","90","2025-11-29 09:01:11",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("584","176","5","147","2025","2","0","0","0","87","87","2025-11-29 09:01:11",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("585","175","5","147","2025","2","0","0","0","42","42","2025-11-29 09:01:11",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("586","173","5","147","2025","2","0","0","0","87","87","2025-11-29 09:01:11",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("587","172","5","147","2025","2","0","0","0","69","69","2025-11-29 09:01:11",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("588","202","5","147","2025","2","0","0","0","69","69","2025-11-29 09:01:11",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("589","179","5","153","2025","2","0","0","0","80","80","2025-11-29 09:07:22",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("590","178","5","153","2025","2","0","0","0","46","46","2025-11-29 09:07:22",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("591","177","5","153","2025","2","0","0","0","35","35","2025-11-29 09:07:22",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("592","174","5","153","2025","2","0","0","0","93","93","2025-11-29 09:07:22",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("593","171","5","153","2025","2","0","0","0","78","78","2025-11-29 09:07:22",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("594","170","5","153","2025","2","0","0","0","94","94","2025-11-29 09:07:22",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("595","169","5","153","2025","2","0","0","0","58","58","2025-11-29 09:07:22",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("596","168","5","153","2025","2","0","0","0","87","87","2025-11-29 09:07:22",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("597","176","5","153","2025","2","0","0","0","79","79","2025-11-29 09:07:22",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("598","175","5","153","2025","2","0","0","0","73","73","2025-11-29 09:07:22",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("599","173","5","153","2025","2","0","0","0","41","41","2025-11-29 09:07:22",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("600","172","5","153","2025","2","0","0","0","39","39","2025-11-29 09:07:22",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("601","202","5","153","2025","2","0","0","0","58","58","2025-11-29 09:07:22",NULL,"0");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("602","179","5","155","2025","2","0","0","0","91","91","2025-11-29 09:11:06",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("603","178","5","155","2025","2","0","0","0","47","47","2025-11-29 09:11:06",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("604","177","5","155","2025","2","0","0","0","48","48","2025-11-29 09:11:06",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("605","174","5","155","2025","2","0","0","0","96","96","2025-11-29 09:11:06",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("606","171","5","155","2025","2","0","0","0","96","96","2025-11-29 09:11:06",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("607","170","5","155","2025","2","0","0","0","99","99","2025-11-29 09:11:06",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("608","169","5","155","2025","2","0","0","0","72","72","2025-11-29 09:11:06",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("609","168","5","155","2025","2","0","0","0","98","98","2025-11-29 09:11:06",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("610","176","5","155","2025","2","0","0","0","88","88","2025-11-29 09:11:06",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("611","175","5","155","2025","2","0","0","0","90","90","2025-11-29 09:11:06",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("612","173","5","155","2025","2","0","0","0","89","89","2025-11-29 09:11:06",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("613","172","5","155","2025","2","0","0","0","58","58","2025-11-29 09:11:06",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("614","202","5","155","2025","2","0","0","0","72","72","2025-11-29 09:11:06",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("615","167","4","137","2025","2","0","0","0","94","94","2025-11-29 12:04:10",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("616","166","4","137","2025","2","0","0","0","95","95","2025-11-29 12:04:10",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("617","164","4","137","2025","2","0","0","0","59","59","2025-11-29 12:04:10",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("618","163","4","137","2025","2","0","0","0","95","95","2025-11-29 12:04:10",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("619","165","4","137","2025","2","0","0","0","98","98","2025-11-29 12:04:10",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("620","186","4","137","2025","2","0","0","0","79","79","2025-11-29 12:04:10",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("621","213","4","137","2025","2","0","0","0","76","76","2025-11-29 12:12:10",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("622","167","4","138","2025","2","0","0","0","95","95","2025-11-29 12:14:02",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("623","166","4","138","2025","2","0","0","0","86","86","2025-11-29 12:14:02",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("624","164","4","138","2025","2","0","0","0","63","63","2025-11-29 12:14:02",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("625","163","4","138","2025","2","0","0","0","87","87","2025-11-29 12:14:02",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("626","165","4","138","2025","2","0","0","0","96","96","2025-11-29 12:14:02",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("627","186","4","138","2025","2","0","0","0","75","75","2025-11-29 12:14:02",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("628","213","4","138","2025","2","0","0","0","87","87","2025-11-29 12:14:02",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("629","167","4","140","2025","2","0","0","0","94","94","2025-11-29 12:15:30",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("630","166","4","140","2025","2","0","0","0","94","94","2025-11-29 12:15:30",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("631","164","4","140","2025","2","0","0","0","76","76","2025-11-29 12:15:30",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("632","163","4","140","2025","2","0","0","0","95","95","2025-11-29 12:15:30",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("633","165","4","140","2025","2","0","0","0","99","99","2025-11-29 12:15:30",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("634","186","4","140","2025","2","0","0","0","93","93","2025-11-29 12:15:30",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("635","213","4","140","2025","2","0","0","0","95","95","2025-11-29 12:15:30",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("636","167","4","139","2025","2","0","0","0","96","96","2025-11-29 12:17:50",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("637","166","4","139","2025","2","0","0","0","84","84","2025-11-29 12:17:50",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("638","164","4","139","2025","2","0","0","0","91","91","2025-11-29 12:17:50",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("639","163","4","139","2025","2","0","0","0","96","96","2025-11-29 12:17:50",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("640","165","4","139","2025","2","0","0","0","99","99","2025-11-29 12:17:50",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("641","186","4","139","2025","2","0","0","0","97","97","2025-11-29 12:17:50",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("642","213","4","139","2025","2","0","0","0","89","89","2025-11-29 12:17:50",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("643","211","7","175","2025","2","0","0","0","56","56","2025-11-29 12:19:19",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("644","210","7","175","2025","2","0","0","0","77","77","2025-11-29 12:19:19",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("645","212","7","175","2025","2","0","0","0","53","53","2025-11-29 12:19:19",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("646","156","2","124","2025","2","0","0","0","69","69","2025-11-29 12:28:23",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("647","154","2","124","2025","2","0","0","0","98","98","2025-11-29 12:28:23",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("648","152","2","124","2025","2","0","0","0","85","85","2025-11-29 12:28:23",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("649","150","2","124","2025","2","0","0","0","83","83","2025-11-29 12:28:23",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("650","148","2","124","2025","2","0","0","0","93","93","2025-11-29 12:28:23",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("651","146","2","124","2025","2","0","0","0","76","76","2025-11-29 12:28:23",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("652","144","2","124","2025","2","0","0","0","83","83","2025-11-29 12:28:23",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("653","143","2","124","2025","2","0","0","0","98","98","2025-11-29 12:28:23",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("654","140","2","124","2025","2","0","0","0","99","99","2025-11-29 12:28:23",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("655","139","2","124","2025","2","0","0","0","95","95","2025-11-29 12:28:23",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("656","137","2","124","2025","2","0","0","0","72","72","2025-11-29 12:28:23",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("657","134","2","124","2025","2","0","0","0","85","85","2025-11-29 12:28:23",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("658","135","2","124","2025","2","0","0","0","94","94","2025-11-29 12:28:23",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("659","201","2","124","2025","2","0","0","0","99","99","2025-11-29 12:28:23",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("660","209","2","124","2025","2","0","0","0","98","98","2025-11-29 12:28:23",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("661","179","5","151","2025","2","0","0","0","95","95","2025-12-02 03:56:39",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("662","178","5","151","2025","2","0","0","0","69","69","2025-12-02 03:56:39",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("663","177","5","151","2025","2","0","0","0","57","57","2025-12-02 03:56:39",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("664","174","5","151","2025","2","0","0","0","90","90","2025-12-02 03:56:39",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("665","171","5","151","2025","2","0","0","0","86","86","2025-12-02 03:56:39",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("666","170","5","151","2025","2","0","0","0","98","98","2025-12-02 03:56:39",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("667","169","5","151","2025","2","0","0","0","84","84","2025-12-02 03:56:39",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("668","168","5","151","2025","2","0","0","0","86","86","2025-12-02 03:56:39",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("669","176","5","151","2025","2","0","0","0","67","67","2025-12-02 03:56:39",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("670","175","5","151","2025","2","0","0","0","40","40","2025-12-02 03:56:39",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("671","173","5","151","2025","2","0","0","0","56","56","2025-12-02 03:56:39",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("672","172","5","151","2025","2","0","0","0","42","42","2025-12-02 03:56:39",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("673","202","5","151","2025","2","0","0","0","84","84","2025-12-02 03:56:39",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("674","179","5","148","2025","2","0","0","0","60","60","2025-12-02 04:01:25",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("675","178","5","148","2025","2","0","0","0","55","55","2025-12-02 04:01:25",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("676","177","5","148","2025","2","0","0","0","35","35","2025-12-02 04:01:25",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("677","174","5","148","2025","2","0","0","0","95","95","2025-12-02 04:01:25",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("678","171","5","148","2025","2","0","0","0","97","97","2025-12-02 04:01:25",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("679","170","5","148","2025","2","0","0","0","94","94","2025-12-02 04:01:25",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("680","169","5","148","2025","2","0","0","0","57","57","2025-12-02 04:01:25",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("681","168","5","148","2025","2","0","0","0","90","90","2025-12-02 04:01:25",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("682","176","5","148","2025","2","0","0","0","87","87","2025-12-02 04:01:25",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("683","175","5","148","2025","2","0","0","0","79","79","2025-12-02 04:01:25",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("684","173","5","148","2025","2","0","0","0","89","89","2025-12-02 04:01:25",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("685","172","5","148","2025","2","0","0","0","42","42","2025-12-02 04:01:25",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("686","202","5","148","2025","2","0","0","0","57","57","2025-12-02 04:01:25",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("687","211","7","173","2025","2","0","0","0","50","50","2025-12-02 04:03:13",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("688","210","7","173","2025","2","0","0","0","84","84","2025-12-02 04:03:13",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("689","212","7","173","2025","2","0","0","0","54","54","2025-12-02 04:03:13",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("690","214","7","173","2025","2","0","0","0","95","95","2025-12-02 04:03:13",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("691","167","4","136","2025","2","0","0","0","98","98","2025-12-02 04:06:20",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("692","166","4","136","2025","2","0","0","0","93","93","2025-12-02 04:06:20",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("693","164","4","136","2025","2","0","0","0","87","87","2025-12-02 04:06:20",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("694","163","4","136","2025","2","0","0","0","93","93","2025-12-02 04:06:20",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("695","165","4","136","2025","2","0","0","0","99","99","2025-12-02 04:06:20",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("696","186","4","136","2025","2","0","0","0","87","87","2025-12-02 04:06:20",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("697","213","4","136","2025","2","0","0","0","98","98","2025-12-02 04:06:20",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("698","211","7","174","2025","2","0","0","0","47","47","2025-12-02 04:09:54",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("699","210","7","174","2025","2","0","0","0","64","64","2025-12-02 04:09:54",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("700","212","7","174","2025","2","0","0","0","43","43","2025-12-02 04:09:54",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("701","214","7","174","2025","2","0","0","0","80","80","2025-12-02 04:09:54",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("702","216","6","164","2025","2","0","0","0","80","80","2025-12-02 14:30:01",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("703","215","6","164","2025","2","0","0","0","80","80","2025-12-02 14:30:01",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("704","216","6","163","2025","2","0","0","0","93","93","2025-12-02 14:30:46",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("705","215","6","163","2025","2","0","0","0","85","85","2025-12-02 14:30:46",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("706","167","4","142","2025","2","0","0","0","57","57","2025-12-02 14:36:20",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("707","166","4","142","2025","2","0","0","0","40","40","2025-12-02 14:36:20",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("708","164","4","142","2025","2","0","0","0","37","37","2025-12-02 14:36:20",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("709","163","4","142","2025","2","0","0","0","37","37","2025-12-02 14:36:20",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("710","165","4","142","2025","2","0","0","0","58","58","2025-12-02 14:36:20",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("711","186","4","142","2025","2","0","0","0","30","30","2025-12-02 14:36:20",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("712","213","4","142","2025","2","0","0","0","36","36","2025-12-02 14:36:20",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("713","179","5","152","2025","2","0","0","0","73","73","2025-12-02 14:41:10",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("714","178","5","152","2025","2","0","0","0","43","43","2025-12-02 14:41:10",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("715","177","5","152","2025","2","0","0","0","38","38","2025-12-02 14:41:10",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("716","174","5","152","2025","2","0","0","0","93","93","2025-12-02 14:41:10",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("717","171","5","152","2025","2","0","0","0","60","60","2025-12-02 14:41:10",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("718","170","5","152","2025","2","0","0","0","90","90","2025-12-02 14:41:10",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("719","169","5","152","2025","2","0","0","0","48","48","2025-12-02 14:41:10",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("720","168","5","152","2025","2","0","0","0","80","80","2025-12-02 14:41:10",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("721","176","5","152","2025","2","0","0","0","60","60","2025-12-02 14:41:10",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("722","175","5","152","2025","2","0","0","0","78","78","2025-12-02 14:41:10",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("723","173","5","152","2025","2","0","0","0","50","50","2025-12-02 14:41:10",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("724","172","5","152","2025","2","0","0","0","47","47","2025-12-02 14:41:10",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("725","211","7","171","2025","2","0","0","0","38","38","2025-12-02 14:42:45",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("726","210","7","171","2025","2","0","0","0","81","81","2025-12-02 14:42:45",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("727","212","7","171","2025","2","0","0","0","68","68","2025-12-02 14:42:45",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("728","214","7","171","2025","2","0","0","0","88","88","2025-12-02 14:42:45",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("729","216","6","157","2025","2","0","0","0","96","96","2025-12-03 08:54:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("730","215","6","157","2025","2","0","0","0","93","93","2025-12-03 08:54:27",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("731","179","5","150","2025","2","0","0","0","94","94","2025-12-03 08:58:34",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("732","178","5","150","2025","2","0","0","0","77","77","2025-12-03 08:58:34",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("733","177","5","150","2025","2","0","0","0","37","37","2025-12-03 08:58:34",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("734","174","5","150","2025","2","0","0","0","98","98","2025-12-03 08:58:34",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("735","171","5","150","2025","2","0","0","0","95","95","2025-12-03 08:58:34",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("736","170","5","150","2025","2","0","0","0","99","99","2025-12-03 08:58:34",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("737","169","5","150","2025","2","0","0","0","63","63","2025-12-03 08:58:34",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("738","168","5","150","2025","2","0","0","0","97","97","2025-12-03 08:58:34",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("739","176","5","150","2025","2","0","0","0","96","96","2025-12-03 08:58:34",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("740","175","5","150","2025","2","0","0","0","98","98","2025-12-03 08:58:34",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("741","173","5","150","2025","2","0","0","0","88","88","2025-12-03 08:58:34",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("742","172","5","150","2025","2","0","0","0","82","82","2025-12-03 08:58:34",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("743","208","1","120","2025","2","0","0","0","87","87","2025-12-03 09:09:11",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("744","207","1","120","2025","2","0","0","0","89","89","2025-12-03 09:09:11",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("745","206","1","120","2025","2","0","0","0","63","63","2025-12-03 09:09:11",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("746","208","1","121","2025","2","0","0","0","91","91","2025-12-03 09:11:37",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("747","207","1","121","2025","2","0","0","0","91","91","2025-12-03 09:11:37",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("748","206","1","121","2025","2","0","0","0","86","86","2025-12-03 09:11:37",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("749","216","6","159","2025","2","0","0","0","80","80","2025-12-03 14:45:31",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("750","215","6","159","2025","2","0","0","0","79","79","2025-12-03 14:45:31",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("751","216","6","162","2025","2","0","0","0","99","99","2025-12-03 14:45:58",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("752","215","6","162","2025","2","0","0","0","96","96","2025-12-03 14:45:58",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("753","216","6","158","2025","2","0","0","0","80","80","2025-12-03 14:48:20",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("754","215","6","158","2025","2","0","0","0","79","79","2025-12-03 14:48:20",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("755","216","6","160","2025","2","0","0","0","61","61","2025-12-03 14:48:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("756","215","6","160","2025","2","0","0","0","99","99","2025-12-03 14:48:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("757","216","6","156","2025","2","0","0","0","94","94","2025-12-03 14:50:00",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("758","215","6","156","2025","2","0","0","0","94","94","2025-12-03 14:50:00",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("759","216","6","165","2025","2","0","0","0","89","89","2025-12-03 14:50:32",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("760","215","6","165","2025","2","0","0","0","90","90","2025-12-03 14:50:32",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("761","216","6","161","2025","2","0","0","0","81","81","2025-12-03 14:51:01",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("762","215","6","161","2025","2","0","0","0","71","71","2025-12-03 14:51:01",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("763","223","3","134","2025","2","0","0","0","95","95","2025-12-03 14:55:13",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("764","221","3","134","2025","2","0","0","0","99","99","2025-12-03 14:55:13",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("765","219","3","134","2025","2","0","0","0","98","98","2025-12-03 14:55:13",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("766","217","3","134","2025","2","0","0","0","96","96","2025-12-03 14:55:13",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("767","222","3","134","2025","2","0","0","0","99","99","2025-12-03 14:55:13",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("768","220","3","134","2025","2","0","0","0","98","98","2025-12-03 14:55:13",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("769","218","3","134","2025","2","0","0","0","99","99","2025-12-03 14:55:13",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("770","223","3","132","2025","2","0","0","0","97","97","2025-12-03 14:56:54",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("771","221","3","132","2025","2","0","0","0","97","97","2025-12-03 14:56:54",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("772","219","3","132","2025","2","0","0","0","92","92","2025-12-03 14:56:54",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("773","217","3","132","2025","2","0","0","0","81","81","2025-12-03 14:56:54",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("774","222","3","132","2025","2","0","0","0","91","91","2025-12-03 14:56:54",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("775","220","3","132","2025","2","0","0","0","84","84","2025-12-03 14:56:54",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("776","218","3","132","2025","2","0","0","0","97","97","2025-12-03 14:56:54",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("777","223","3","133","2025","2","0","0","0","94","94","2025-12-03 14:58:12",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("778","221","3","133","2025","2","0","0","0","98","98","2025-12-03 14:58:12",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("779","219","3","133","2025","2","0","0","0","99","99","2025-12-03 14:58:12",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("780","217","3","133","2025","2","0","0","0","90","90","2025-12-03 14:58:12",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("781","222","3","133","2025","2","0","0","0","98","98","2025-12-03 14:58:12",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("782","220","3","133","2025","2","0","0","0","98","98","2025-12-03 14:58:12",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("783","218","3","133","2025","2","0","0","0","98","98","2025-12-03 14:58:12",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("784","223","3","127","2025","2","0","0","0","87","87","2025-12-03 14:59:29",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("785","221","3","127","2025","2","0","0","0","98","98","2025-12-03 14:59:29",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("786","219","3","127","2025","2","0","0","0","98","98","2025-12-03 14:59:29",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("787","217","3","127","2025","2","0","0","0","90","90","2025-12-03 14:59:29",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("788","222","3","127","2025","2","0","0","0","97","97","2025-12-03 14:59:29",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("789","220","3","127","2025","2","0","0","0","98","98","2025-12-03 14:59:29",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("790","218","3","127","2025","2","0","0","0","98","98","2025-12-03 14:59:29",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("791","223","3","131","2025","2","0","0","0","90","90","2025-12-03 15:00:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("792","221","3","131","2025","2","0","0","0","98","98","2025-12-03 15:00:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("793","219","3","131","2025","2","0","0","0","99","99","2025-12-03 15:00:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("794","217","3","131","2025","2","0","0","0","95","95","2025-12-03 15:00:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("795","222","3","131","2025","2","0","0","0","99","99","2025-12-03 15:00:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("796","220","3","131","2025","2","0","0","0","95","95","2025-12-03 15:00:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("797","218","3","131","2025","2","0","0","0","98","98","2025-12-03 15:00:55",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("798","156","2","123","2025","2","0","0","0","89","89","2025-12-03 16:02:30",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("799","154","2","123","2025","2","0","0","0","96","96","2025-12-03 16:02:30",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("800","152","2","123","2025","2","0","0","0","87","87","2025-12-03 16:02:30",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("801","150","2","123","2025","2","0","0","0","85","85","2025-12-03 16:02:30",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("802","148","2","123","2025","2","0","0","0","85","85","2025-12-03 16:02:30",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("803","146","2","123","2025","2","0","0","0","83","83","2025-12-03 16:02:30",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("804","144","2","123","2025","2","0","0","0","92","92","2025-12-03 16:02:30",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("805","143","2","123","2025","2","0","0","0","95","95","2025-12-03 16:02:30",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("806","140","2","123","2025","2","0","0","0","99","99","2025-12-03 16:02:30",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("807","139","2","123","2025","2","0","0","0","87","87","2025-12-03 16:02:30",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("808","137","2","123","2025","2","0","0","0","77","77","2025-12-03 16:02:30",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("809","134","2","123","2025","2","0","0","0","84","84","2025-12-03 16:02:30",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("810","135","2","123","2025","2","0","0","0","93","93","2025-12-03 16:02:30",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("811","201","2","123","2025","2","0","0","0","91","91","2025-12-03 16:02:30",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("812","209","2","123","2025","2","0","0","0","90","90","2025-12-03 16:02:30",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("813","179","5","144","2025","2","0","0","0","93","93","2025-12-04 02:59:53",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("814","178","5","144","2025","2","0","0","0","48","48","2025-12-04 02:59:53",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("815","177","5","144","2025","2","0","0","0","44","44","2025-12-04 02:59:53",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("816","174","5","144","2025","2","0","0","0","93","93","2025-12-04 02:59:53",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("817","171","5","144","2025","2","0","0","0","80","80","2025-12-04 02:59:53",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("818","170","5","144","2025","2","0","0","0","96","96","2025-12-04 02:59:53",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("819","169","5","144","2025","2","0","0","0","82","82","2025-12-04 02:59:53",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("820","168","5","144","2025","2","0","0","0","94","94","2025-12-04 02:59:53",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("821","176","5","144","2025","2","0","0","0","88","88","2025-12-04 02:59:53",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("822","175","5","144","2025","2","0","0","0","81","81","2025-12-04 02:59:53",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("823","173","5","144","2025","2","0","0","0","65","65","2025-12-04 02:59:53",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("824","172","5","144","2025","2","0","0","0","54","54","2025-12-04 02:59:53",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("825","179","5","149","2025","2","0","0","0","73","73","2025-12-04 03:03:26",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("826","178","5","149","2025","2","0","0","0","33","33","2025-12-04 03:03:26",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("827","177","5","149","2025","2","0","0","0","33","33","2025-12-04 03:03:26",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("828","174","5","149","2025","2","0","0","0","72","72","2025-12-04 03:03:26",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("829","171","5","149","2025","2","0","0","0","50","50","2025-12-04 03:03:26",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("830","170","5","149","2025","2","0","0","0","81","81","2025-12-04 03:03:26",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("831","169","5","149","2025","2","0","0","0","36","36","2025-12-04 03:03:26",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("832","168","5","149","2025","2","0","0","0","72","72","2025-12-04 03:03:26",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("833","176","5","149","2025","2","0","0","0","55","55","2025-12-04 03:03:26",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("834","175","5","149","2025","2","0","0","0","80","80","2025-12-04 03:03:26",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("835","173","5","149","2025","2","0","0","0","41","41","2025-12-04 03:03:26",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("836","172","5","149","2025","2","0","0","0","33","33","2025-12-04 03:03:26",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("837","167","4","143","2025","2","0","0","0","88","88","2025-12-04 03:10:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("838","166","4","143","2025","2","0","0","0","87","87","2025-12-04 03:10:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("839","164","4","143","2025","2","0","0","0","74","74","2025-12-04 03:10:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("840","163","4","143","2025","2","0","0","0","92","92","2025-12-04 03:10:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("841","165","4","143","2025","2","0","0","0","95","95","2025-12-04 03:10:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("842","186","4","143","2025","2","0","0","0","84","84","2025-12-04 03:10:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("843","213","4","143","2025","2","0","0","0","84","84","2025-12-04 03:10:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("844","213","4","135","2025","2","0","0","0","94","94","2025-12-04 03:11:41",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("845","213","4","141","2025","2","0","0","0","96","96","2025-12-04 03:12:35",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("846","214","7","166","2025","2","0","0","0","89","89","2025-12-04 03:18:01",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("847","214","7","168","2025","2","0","0","0","62","62","2025-12-04 03:18:59",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("848","214","7","169","2025","2","0","0","0","86","86","2025-12-04 03:19:33",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("849","214","7","172","2025","2","0","0","0","88","88","2025-12-04 03:20:08",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("850","214","7","175","2025","2","0","0","0","75","75","2025-12-04 03:20:59",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("851","179","5","145","2025","2","0","0","0","94","94","2025-12-04 08:56:24",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("852","178","5","145","2025","2","0","0","0","66","66","2025-12-04 08:56:24",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("853","177","5","145","2025","2","0","0","0","46","46","2025-12-04 08:56:24",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("854","174","5","145","2025","2","0","0","0","98","98","2025-12-04 08:56:24",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("855","171","5","145","2025","2","0","0","0","95","95","2025-12-04 08:56:24",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("856","170","5","145","2025","2","0","0","0","98","98","2025-12-04 08:56:24",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("857","169","5","145","2025","2","0","0","0","64","64","2025-12-04 08:56:24",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("858","168","5","145","2025","2","0","0","0","98","98","2025-12-04 08:56:24",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("859","176","5","145","2025","2","0","0","0","94","94","2025-12-04 08:56:24",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("860","175","5","145","2025","2","0","0","0","94","94","2025-12-04 08:56:24",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("861","173","5","145","2025","2","0","0","0","88","88","2025-12-04 08:56:24",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("862","172","5","145","2025","2","0","0","0","79","79","2025-12-04 08:56:24",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("863","211","7","167","2025","2","0","0","0","66","66","2025-12-04 08:57:51",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("864","210","7","167","2025","2","0","0","0","97","97","2025-12-04 08:57:51",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("865","212","7","167","2025","2","0","0","0","71","71","2025-12-04 08:57:51",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("866","214","7","167","2025","2","0","0","0","96","96","2025-12-04 08:57:51",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("867","223","3","130","2025","2","0","0","0","89","89","2025-12-04 09:25:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("868","221","3","130","2025","2","0","0","0","98","98","2025-12-04 09:25:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("869","219","3","130","2025","2","0","0","0","92","92","2025-12-04 09:25:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("870","217","3","130","2025","2","0","0","0","85","85","2025-12-04 09:25:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("871","222","3","130","2025","2","0","0","0","87","87","2025-12-04 09:25:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("872","220","3","130","2025","2","0","0","0","91","91","2025-12-04 09:25:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("873","218","3","130","2025","2","0","0","0","98","98","2025-12-04 09:25:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("874","223","3","129","2025","2","0","0","0","97","97","2025-12-04 09:26:52",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("875","221","3","129","2025","2","0","0","0","99","99","2025-12-04 09:26:52",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("876","219","3","129","2025","2","0","0","0","99","99","2025-12-04 09:26:52",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("877","217","3","129","2025","2","0","0","0","93","93","2025-12-04 09:26:52",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("878","222","3","129","2025","2","0","0","0","98","98","2025-12-04 09:26:52",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("879","220","3","129","2025","2","0","0","0","96","96","2025-12-04 09:26:52",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("880","218","3","129","2025","2","0","0","0","99","99","2025-12-04 09:26:52",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("881","211","7","170","2025","2","0","0","0","33","33","2025-12-04 10:04:54",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("882","210","7","170","2025","2","0","0","0","40","40","2025-12-04 10:04:54",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("883","212","7","170","2025","2","0","0","0","33","33","2025-12-04 10:04:54",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("884","214","7","170","2025","2","0","0","0","40","40","2025-12-04 10:04:54",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("885","225","2","126","2025","2","0","0","0","92","92","2025-12-06 11:06:16",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("886","225","2","124","2025","2","0","0","0","85","85","2025-12-06 11:07:18",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("887","225","2","122","2025","2","0","0","0","96","96","2025-12-06 11:09:58",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("888","225","2","125","2025","2","0","0","0","27","27","2025-12-06 11:11:01",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("889","225","2","123","2025","2","0","0","0","92","92","2025-12-06 11:11:43",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("890","224","1","121","2025","2","0","0","0","71","71","2025-12-06 11:15:23",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("891","224","1","119","2025","2","0","0","0","76","76","2025-12-06 11:16:36",NULL,"1");
INSERT INTO `exam_result_v3` (`id`, `student_id`, `course`, `subject`, `year`, `exam_id`, `cq`, `mcq`, `practical`, `oral`, `total`, `date`, `regi_id`, `attendance`) VALUES("892","224","1","120","2025","2","0","0","0","66","66","2025-12-06 11:17:44",NULL,"1");


-- Table structure for table `exam_v3`
DROP TABLE IF EXISTS `exam_v3`;
CREATE TABLE `exam_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` varchar(200) DEFAULT NULL,
  `exam_name` varchar(500) DEFAULT NULL,
  `exam_name_bn` varchar(200) NOT NULL,
  `priority` varchar(11) DEFAULT NULL,
  `publish_date` date DEFAULT NULL,
  `publish_time` varchar(200) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `exam_v3`
INSERT INTO `exam_v3` (`id`, `year`, `exam_name`, `exam_name_bn`, `priority`, `publish_date`, `publish_time`, `date`) VALUES("2","2025","Annual Examination 2025","বার্ষিক পরিক্ষা ২০২৫","3","2025-12-03","21:00","2025-07-27 07:37:53");
INSERT INTO `exam_v3` (`id`, `year`, `exam_name`, `exam_name_bn`, `priority`, `publish_date`, `publish_time`, `date`) VALUES("6","2025","১ম সাময়িক পরিক্ষা","১ম সাময়িক পরিক্ষা","1","2025-07-03","18:00","2025-08-03 16:25:41");


-- Table structure for table `examination_name`
DROP TABLE IF EXISTS `examination_name`;
CREATE TABLE `examination_name` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `exam_name` varchar(200) DEFAULT NULL,
  `exam_center_name` varchar(255) DEFAULT NULL,
  `exam_key` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table `examination_name`


-- Table structure for table `expense`
DROP TABLE IF EXISTS `expense`;
CREATE TABLE `expense` (
  `expense_id` int(11) NOT NULL AUTO_INCREMENT,
  `expense_amount` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `expense_details` varchar(250) NOT NULL,
  `expense_receipt` varchar(250) NOT NULL,
  `expense_date` varchar(255) NOT NULL,
  `expense_month` varchar(250) NOT NULL,
  `expense_year` varchar(250) NOT NULL,
  PRIMARY KEY (`expense_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

-- Dumping data for table `expense`
INSERT INTO `expense` (`expense_id`, `expense_amount`, `category_id`, `expense_details`, `expense_receipt`, `expense_date`, `expense_month`, `expense_year`) VALUES("8","100","1","","","2022-11-08","01","2023");
INSERT INTO `expense` (`expense_id`, `expense_amount`, `category_id`, `expense_details`, `expense_receipt`, `expense_date`, `expense_month`, `expense_year`) VALUES("9","6000","1","","","2023-05-11","05","2023");


-- Table structure for table `grad_point_v3`
DROP TABLE IF EXISTS `grad_point_v3`;
CREATE TABLE `grad_point_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) NOT NULL,
  `points_grades` text NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `grad_point_v3`
INSERT INTO `grad_point_v3` (`id`, `name`, `points_grades`, `date`) VALUES("8","GPA Calculator2","[{\"point\":\"5.00\",\"grad\":\"A+\"},{\"point\":\"4.00\",\"grad\":\"A\"},{\"point\":\"3.50\",\"grad\":\"A-\"},{\"point\":\"3.00\",\"grad\":\"B\"},{\"point\":\"2.00\",\"grad\":\"C\"},{\"point\":\"1.00\",\"grad\":\"D\"},{\"point\":\"0.00\",\"grad\":\"F\"}]","2025-01-11 04:05:37");


-- Table structure for table `grading_v3`
DROP TABLE IF EXISTS `grading_v3`;
CREATE TABLE `grading_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` varchar(200) DEFAULT NULL,
  `class_id` varchar(11) DEFAULT NULL,
  `subject_id` varchar(11) DEFAULT NULL,
  `exam_id` varchar(11) DEFAULT NULL,
  `conditions` text DEFAULT NULL,
  `max_mark` varchar(50) DEFAULT NULL,
  `pass_mark` varchar(200) DEFAULT NULL,
  `class_id_hidden` varchar(500) DEFAULT NULL,
  `status` varchar(200) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  `cq_pass_mark` varchar(255) DEFAULT NULL,
  `mcq_pass_mark` varchar(255) DEFAULT NULL,
  `practical_pass_mark` varchar(255) DEFAULT NULL,
  `final_pass_mark` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=121 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `grading_v3`
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("1","2025","1","51","1","[{\"max\":\"100\",\"min\":\"80\",\"grade\":\"A+\",\"point\":\"5.00\"},{\"max\":\"80\",\"min\":\"50\",\"grade\":\"A\",\"point\":\"4.00\"},{\"max\":\"50\",\"min\":\"33\",\"grade\":\"C\",\"point\":\"2.50\"}]","100","30","1",NULL,"2025-06-09 03:43:14","","","","");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("2","2025","1","52","1","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":80,\"min\":50,\"grade\":\"A\",\"point\":4},{\"max\":50,\"min\":33,\"grade\":\"C\",\"point\":2.5}]","100","33","1",NULL,"2025-06-09 03:43:19","","","","");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("5","2025","1","63","1","[{\"max\":\"33\",\"min\":\"39\",\"grade\":\"D\",\"point\":\"1.00\"},{\"max\":\"40\",\"min\":\"49\",\"grade\":\"C\",\"point\":\"2.00\"},{\"max\":\"50\",\"min\":\"59\",\"grade\":\"B\",\"point\":\"3.00\"},{\"max\":\"60\",\"min\":\"69\",\"grade\":\"A-\",\"point\":\"3.50\"},{\"max\":\"70\",\"min\":\"79\",\"grade\":\"A\",\"point\":\"4.00\"},{\"max\":\"80\",\"min\":\"100\",\"grade\":\"A+\",\"point\":\"5.00\"}]","100","33","1",NULL,"2025-07-25 18:13:45","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("13","2025","1","119","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":59,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","1",NULL,"2025-07-28 15:06:19","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("15","2025","1","120","2","[{\"max\":\"100\",\"min\":\"80\",\"grade\":\"A+\",\"point\":\"5.00\"},{\"max\":\"79\",\"min\":\"70\",\"grade\":\"A\",\"point\":\"4.00\"},{\"max\":\"69\",\"min\":\"60\",\"grade\":\"A-\",\"point\":\"3.50\"},{\"max\":\"59\",\"min\":\"50\",\"grade\":\"B\",\"point\":\"3.00\"},{\"max\":\"49\",\"min\":\"40\",\"grade\":\"C\",\"point\":\"2.00\"},{\"max\":\"39\",\"min\":\"33\",\"grade\":\"D\",\"point\":\"1.00\"},{\"max\":\"32\",\"min\":\"0\",\"grade\":\"F\",\"point\":\"0.8\"}]","100","33","1",NULL,"2025-07-28 15:28:11","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("16","2025","1","121","2","[{\"max\":\"100\",\"min\":\"80\",\"grade\":\"A+\",\"point\":\"5.00\"},{\"max\":\"79\",\"min\":\"70\",\"grade\":\"A\",\"point\":\"4.00\"},{\"max\":\"69\",\"min\":\"60\",\"grade\":\"A-\",\"point\":\"3.50\"},{\"max\":\"59\",\"min\":\"50\",\"grade\":\"B\",\"point\":\"3.00\"},{\"max\":\"49\",\"min\":\"40\",\"grade\":\"C\",\"point\":\"2.00\"},{\"max\":\"39\",\"min\":\"33\",\"grade\":\"D\",\"point\":\"1.00\"},{\"max\":\"32\",\"min\":\"0\",\"grade\":\"F\",\"point\":\"0.0\"}]","100","33","1",NULL,"2025-07-28 15:39:47","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("17","2025","2","122","2","[{\"max\":\"100\",\"min\":\"80\",\"grade\":\"A+\",\"point\":\"5.00\"},{\"max\":\"79\",\"min\":\"70\",\"grade\":\"A\",\"point\":\"4.00\"},{\"max\":\"69\",\"min\":\"60\",\"grade\":\"A-\",\"point\":\"3.50\"},{\"max\":\"59\",\"min\":\"50\",\"grade\":\"B\",\"point\":\"3.00\"},{\"max\":\"49\",\"min\":\"40\",\"grade\":\"C\",\"point\":\"2.00\"},{\"max\":\"39\",\"min\":\"33\",\"grade\":\"D\",\"point\":\"1.00\"},{\"max\":\"32\",\"min\":\"0\",\"grade\":\"F\",\"point\":\"0.0\"}]","100","33","2",NULL,"2025-07-29 01:49:18","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("18","2025","2","123","2","[{\"max\":\"100\",\"min\":\"80\",\"grade\":\"A+\",\"point\":\"5.00\"},{\"max\":\"79\",\"min\":\"70\",\"grade\":\"A\",\"point\":\"4.00\"},{\"max\":\"69\",\"min\":\"60\",\"grade\":\"A-\",\"point\":\"3.50\"},{\"max\":\"59\",\"min\":\"50\",\"grade\":\"B\",\"point\":\"3.00\"},{\"max\":\"49\",\"min\":\"40\",\"grade\":\"C\",\"point\":\"2.00\"},{\"max\":\"39\",\"min\":\"33\",\"grade\":\"D\",\"point\":\"1.00\"},{\"max\":\"32\",\"min\":\"0\",\"grade\":\"F\",\"point\":\"0.0\"}]","100","33","2",NULL,"2025-07-29 01:51:30","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("29","2025","2","124","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","2",NULL,"2025-07-29 16:26:47","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("30","2025","2","125","2","[{\"max\":\"30\",\"min\":\"27\",\"grade\":\"A+\",\"point\":\"5.00\"},{\"max\":\"26\",\"min\":\"24\",\"grade\":\"A\",\"point\":\"4.00\"},{\"max\":\"23\",\"min\":\"21\",\"grade\":\"A-\",\"point\":\"3.50\"},{\"max\":\"20\",\"min\":\"18\",\"grade\":\"B\",\"point\":\"3.00\"},{\"max\":\"17\",\"min\":\"15\",\"grade\":\"C\",\"point\":\"2.00\"},{\"max\":\"14\",\"min\":\"10\",\"grade\":\"D\",\"point\":\"1.00\"},{\"max\":\"9\",\"min\":\"0\",\"grade\":\"F\",\"point\":\"0.00\"}]","30","10","2",NULL,"2025-07-29 16:31:22","","","","10");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("31","2025","2","126","2","[{\"max\":\"100\",\"min\":\"80\",\"grade\":\"A+\",\"point\":\"5.00\"},{\"max\":\"79\",\"min\":\"70\",\"grade\":\"A\",\"point\":\"4.00\"},{\"max\":\"69\",\"min\":\"60\",\"grade\":\"A-\",\"point\":\"3.50\"},{\"max\":\"59\",\"min\":\"50\",\"grade\":\"B\",\"point\":\"3.00\"},{\"max\":\"49\",\"min\":\"40\",\"grade\":\"C\",\"point\":\"2.00\"},{\"max\":\"39\",\"min\":\"33\",\"grade\":\"D\",\"point\":\"1.00\"},{\"max\":\"32\",\"min\":\"0\",\"grade\":\"F\",\"point\":\"0.00\"}]","100","33","2",NULL,"2025-07-29 16:31:57","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("32","2025","3","127","2","[{\"max\":\"100\",\"min\":\"80\",\"grade\":\"A+\",\"point\":\"5.00\"},{\"max\":\"79\",\"min\":\"70\",\"grade\":\"A\",\"point\":\"4.00\"},{\"max\":\"69\",\"min\":\"60\",\"grade\":\"A-\",\"point\":\"3.50\"},{\"max\":\"59\",\"min\":\"50\",\"grade\":\"B\",\"point\":\"3.00\"},{\"max\":\"49\",\"min\":\"40\",\"grade\":\"C\",\"point\":\"2.00\"},{\"max\":\"39\",\"min\":\"33\",\"grade\":\"D\",\"point\":\"1.00\"},{\"max\":\"32\",\"min\":\"0\",\"grade\":\"F\",\"point\":\"00\"}]","100","33","3",NULL,"2025-07-29 16:34:37","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("33","2025","3","128","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3",NULL,"2025-07-29 16:34:44","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("34","2025","3","129","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3",NULL,"2025-07-29 16:35:22","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("35","2025","3","130","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3",NULL,"2025-07-29 16:35:57","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("36","2025","3","131","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3",NULL,"2025-07-29 16:36:28","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("37","2025","3","132","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3",NULL,"2025-07-29 16:37:04","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("38","2025","3","133","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3",NULL,"2025-07-29 16:37:37","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("39","2025","3","134","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3",NULL,"2025-07-29 16:38:12","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("40","2025","4","135","2","[{\"max\":\"100\",\"min\":\"80\",\"grade\":\"A+\",\"point\":\"5.00\"},{\"max\":\"79\",\"min\":\"70\",\"grade\":\"A\",\"point\":\"4.00\"},{\"max\":\"69\",\"min\":\"60\",\"grade\":\"A-\",\"point\":\"3.50\"},{\"max\":\"59\",\"min\":\"50\",\"grade\":\"B\",\"point\":\"3.00\"},{\"max\":\"49\",\"min\":\"40\",\"grade\":\"C\",\"point\":\"2.00\"},{\"max\":\"39\",\"min\":\"33\",\"grade\":\"D\",\"point\":\"1.00\"},{\"max\":\"32\",\"min\":\"0\",\"grade\":\"F\",\"point\":\"0.00\"}]","100","33","4",NULL,"2025-07-30 14:37:09","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("41","2025","4","136","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","4",NULL,"2025-07-30 14:37:17","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("42","2025","4","137","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","4",NULL,"2025-07-30 14:37:46","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("43","2025","4","138","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","4",NULL,"2025-07-30 14:38:52","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("44","2025","4","139","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","4",NULL,"2025-07-30 14:39:21","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("45","2025","4","140","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","4",NULL,"2025-07-30 14:39:56","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("46","2025","4","141","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","4",NULL,"2025-07-30 14:40:25","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("47","2025","4","142","2","[{\"max\":\"60\",\"min\":\"54\",\"grade\":\"A+\",\"point\":\"5.00\"},{\"max\":\"53\",\"min\":\"48\",\"grade\":\"A\",\"point\":\"4.00\"},{\"max\":\"47\",\"min\":\"42\",\"grade\":\"A-\",\"point\":\"3.50\"},{\"max\":\"41\",\"min\":\"36\",\"grade\":\"B\",\"point\":\"3.00\"},{\"max\":\"35\",\"min\":\"30\",\"grade\":\"C\",\"point\":\"2.00\"},{\"max\":\"29\",\"min\":\"24\",\"grade\":\"D\",\"point\":\"1.00\"},{\"max\":\"23\",\"min\":\"0\",\"grade\":\"F\",\"point\":\"0.00\"}]","60","24","4",NULL,"2025-07-30 14:40:57","","","","24");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("48","2025","4","143","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","4",NULL,"2025-07-30 14:41:26","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("50","2025","5","144","2","[{\"max\":\"100\",\"min\":\"80\",\"grade\":\"A+\",\"point\":\"5.00\"},{\"max\":\"79\",\"min\":\"70\",\"grade\":\"A\",\"point\":\"4.00\"},{\"max\":\"69\",\"min\":\"60\",\"grade\":\"A-\",\"point\":\"3.50\"},{\"max\":\"59\",\"min\":\"50\",\"grade\":\"B\",\"point\":\"3.00\"},{\"max\":\"49\",\"min\":\"40\",\"grade\":\"C\",\"point\":\"2.00\"},{\"max\":\"39\",\"min\":\"33\",\"grade\":\"D\",\"point\":\"1.00\"},{\"max\":\"32\",\"min\":\"0\",\"grade\":\"F\",\"point\":\"0.00\"}]","100","33","5",NULL,"2025-07-30 14:53:01","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("51","2025","5","145","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","5",NULL,"2025-07-30 14:53:11","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("52","2025","5","146","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","5",NULL,"2025-07-30 14:53:41","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("53","2025","5","147","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","5",NULL,"2025-07-30 15:18:49","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("54","2025","5","148","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","5",NULL,"2025-07-30 15:19:23","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("55","2025","5","149","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","5",NULL,"2025-07-30 15:20:05","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("56","2025","5","150","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","5",NULL,"2025-07-30 15:20:38","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("57","2025","5","151","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","5",NULL,"2025-07-30 15:21:12","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("58","2025","5","152","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","5",NULL,"2025-07-30 15:21:47","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("59","2025","5","153","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","5",NULL,"2025-07-30 15:22:27","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("60","2025","5","155","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","5",NULL,"2025-07-30 15:23:00","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("61","2025","6","156","2","[{\"max\":\"100\",\"min\":\"80\",\"grade\":\"A+\",\"point\":\"5.00\"},{\"max\":\"79\",\"min\":\"70\",\"grade\":\"A\",\"point\":\"4.00\"},{\"max\":\"69\",\"min\":\"60\",\"grade\":\"A-\",\"point\":\"3.50\"},{\"max\":\"59\",\"min\":\"50\",\"grade\":\"B\",\"point\":\"3.00\"},{\"max\":\"49\",\"min\":\"40\",\"grade\":\"C\",\"point\":\"2.00\"},{\"max\":\"39\",\"min\":\"33\",\"grade\":\"D\",\"point\":\"1.00\"},{\"max\":\"32\",\"min\":\"0\",\"grade\":\"F\",\"point\":\"0.00\"}]","100","33","6",NULL,"2025-08-01 04:20:26","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("62","2025","6","157","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","6",NULL,"2025-08-01 04:20:44","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("63","2025","6","158","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","6",NULL,"2025-08-01 04:21:32","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("64","2025","6","159","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","6",NULL,"2025-08-01 04:22:20","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("65","2025","6","160","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","6",NULL,"2025-08-01 04:23:14","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("66","2025","6","161","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","6",NULL,"2025-08-01 04:24:12","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("67","2025","6","162","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","6",NULL,"2025-08-01 04:24:58","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("68","2025","6","163","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","6",NULL,"2025-08-01 04:25:41","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("69","2025","6","164","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","6",NULL,"2025-08-01 04:26:43","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("70","2025","6","165","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","6",NULL,"2025-08-01 04:27:30","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("71","2025","7","166","2","[{\"max\":\"100\",\"min\":\"80\",\"grade\":\"A+\",\"point\":\"5.00\"},{\"max\":\"79\",\"min\":\"70\",\"grade\":\"A\",\"point\":\"4.00\"},{\"max\":\"69\",\"min\":\"60\",\"grade\":\"A-\",\"point\":\"3.50\"},{\"max\":\"59\",\"min\":\"50\",\"grade\":\"B\",\"point\":\"3.00\"},{\"max\":\"49\",\"min\":\"40\",\"grade\":\"C\",\"point\":\"2.00\"},{\"max\":\"39\",\"min\":\"33\",\"grade\":\"D\",\"point\":\"1.00\"},{\"max\":\"32\",\"min\":\"0\",\"grade\":\"F\",\"point\":\"0.00\"}]","100","33","7",NULL,"2025-08-01 04:32:14","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("72","2025","7","167","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","7",NULL,"2025-08-01 04:32:32","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("73","2025","7","168","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","7",NULL,"2025-08-01 04:33:14","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("74","2025","7","169","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","7",NULL,"2025-08-01 04:33:55","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("75","2025","7","170","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","7",NULL,"2025-08-01 04:36:37","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("76","2025","7","171","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","7",NULL,"2025-08-01 04:37:25","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("77","2025","7","172","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","7",NULL,"2025-08-01 04:38:50","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("78","2025","7","173","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","7",NULL,"2025-08-01 04:39:38","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("79","2025","7","174","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","7",NULL,"2025-08-01 04:40:15","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("80","2025","7","175","2","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","7",NULL,"2025-08-01 04:40:46","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("81","2025","1","119","6","[{\"max\":\"100\",\"min\":\"80\",\"grade\":\"A+\",\"point\":\"5.00\"},{\"max\":\"70\",\"min\":\"70\",\"grade\":\"A\",\"point\":\"4.00\"},{\"max\":\"69\",\"min\":\"60\",\"grade\":\"A-\",\"point\":\"3.50\"},{\"max\":\"59\",\"min\":\"50\",\"grade\":\"B\",\"point\":\"3.00\"},{\"max\":\"49\",\"min\":\"40\",\"grade\":\"C\",\"point\":\"2.00\"},{\"max\":\"39\",\"min\":\"33\",\"grade\":\"D\",\"point\":\"1.00\"},{\"max\":\"32\",\"min\":\"0\",\"grade\":\"F\",\"point\":\"0.0\"}]","100","33","1",NULL,"2025-08-24 11:28:28","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("82","2025","1","120","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":70,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","1",NULL,"2025-08-24 11:28:36","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("83","2025","1","121","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":70,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","1",NULL,"2025-08-24 11:28:44","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("84","2025","1","121","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":70,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]",NULL,NULL,"1",NULL,"2025-08-24 11:29:31","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("85","2025","2","122","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","2",NULL,"2025-08-24 11:30:11","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("86","2025","2","123","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","2",NULL,"2025-08-24 11:30:47","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("87","2025","2","124","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","2",NULL,"2025-08-24 11:30:54","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("88","2025","2","125","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","2",NULL,"2025-08-24 11:31:01","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("89","2025","2","126","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","2",NULL,"2025-08-24 11:32:26","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("90","2025","3","127","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3",NULL,"2025-08-24 11:32:59","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("91","2025","3","128","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3",NULL,"2025-08-24 11:33:06","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("93","2025","3","129","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3",NULL,"2025-08-24 11:33:32","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("94","2025","3","130","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3",NULL,"2025-08-24 11:33:38","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("95","2025","3","131","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3",NULL,"2025-08-24 11:33:44","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("96","2025","3","132","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3",NULL,"2025-08-24 11:33:53","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("97","2025","3","133","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3",NULL,"2025-08-24 11:36:51","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("98","2025","3","134","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","3",NULL,"2025-08-24 11:36:58","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("99","2025","4","135","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","4",NULL,"2025-08-24 11:38:35","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("100","2025","4","136","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","4",NULL,"2025-08-24 11:39:04","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("101","2025","4","137","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","4",NULL,"2025-08-24 11:39:10","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("102","2025","4","138","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","4",NULL,"2025-08-24 11:39:17","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("103","2025","4","139","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","4",NULL,"2025-08-24 11:39:24","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("104","2025","4","140","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","4",NULL,"2025-08-24 11:39:31","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("105","2025","4","141","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","4",NULL,"2025-08-24 11:39:37","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("106","2025","4","142","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","4",NULL,"2025-08-24 11:39:46","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("107","2025","4","143","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","4",NULL,"2025-08-24 11:39:52","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("110","2025","5","144","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","5",NULL,"2025-08-26 15:05:57","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("111","2025","5","145","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","5",NULL,"2025-08-26 15:06:55","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("112","2025","5","146","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","5",NULL,"2025-08-26 15:07:06","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("113","2025","5","147","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","5",NULL,"2025-08-26 15:07:27","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("114","2025","5","148","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","5",NULL,"2025-08-26 15:07:27","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("115","2025","5","149","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","5",NULL,"2025-08-26 15:07:35","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("116","2025","5","150","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","5",NULL,"2025-08-26 15:07:47","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("117","2025","5","151","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","5",NULL,"2025-08-26 15:07:53","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("118","2025","5","152","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","5",NULL,"2025-08-26 15:08:03","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("119","2025","5","153","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","5",NULL,"2025-08-26 15:08:09","","","","33");
INSERT INTO `grading_v3` (`id`, `year`, `class_id`, `subject_id`, `exam_id`, `conditions`, `max_mark`, `pass_mark`, `class_id_hidden`, `status`, `date`, `cq_pass_mark`, `mcq_pass_mark`, `practical_pass_mark`, `final_pass_mark`) VALUES("120","2025","5","155","6","[{\"max\":100,\"min\":80,\"grade\":\"A+\",\"point\":5},{\"max\":79,\"min\":70,\"grade\":\"A\",\"point\":4},{\"max\":69,\"min\":60,\"grade\":\"A-\",\"point\":3.5},{\"max\":59,\"min\":50,\"grade\":\"B\",\"point\":3},{\"max\":49,\"min\":40,\"grade\":\"C\",\"point\":2},{\"max\":39,\"min\":33,\"grade\":\"D\",\"point\":1},{\"max\":32,\"min\":0,\"grade\":\"F\",\"point\":0}]","100","33","5",NULL,"2025-08-26 15:08:17","","","","33");


-- Table structure for table `guardian_card_expiry`
DROP TABLE IF EXISTS `guardian_card_expiry`;
CREATE TABLE `guardian_card_expiry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` int(11) DEFAULT NULL,
  `academic_year` int(11) DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_course_year` (`course_id`,`academic_year`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `guardian_card_expiry`
INSERT INTO `guardian_card_expiry` (`id`, `course_id`, `academic_year`, `expiry_date`, `created_at`, `updated_at`) VALUES("3","1","2025","2027-11-17","2025-04-16 03:05:10","2025-04-16 03:05:10");
INSERT INTO `guardian_card_expiry` (`id`, `course_id`, `academic_year`, `expiry_date`, `created_at`, `updated_at`) VALUES("4","1","2022","2024-07-16","2025-04-16 03:07:50","2025-04-16 03:07:50");


-- Table structure for table `height_mark`
DROP TABLE IF EXISTS `height_mark`;
CREATE TABLE `height_mark` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` varchar(255) NOT NULL,
  `mark_year` varchar(100) NOT NULL,
  `class_id` int(11) NOT NULL,
  `mark_number` float NOT NULL,
  `subject_id` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `created_add` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `height_mark`


-- Table structure for table `hold_results`
DROP TABLE IF EXISTS `hold_results`;
CREATE TABLE `hold_results` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `reason` text NOT NULL,
  `hold_date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `course_id` (`course_id`),
  KEY `year` (`year`),
  KEY `exam_id` (`exam_id`),
  KEY `student_id` (`student_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `hold_results`


-- Table structure for table `holiday_v3`
DROP TABLE IF EXISTS `holiday_v3`;
CREATE TABLE `holiday_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) NOT NULL,
  `date` date NOT NULL,
  `add_time` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `holiday_v3`
INSERT INTO `holiday_v3` (`id`, `name`, `date`, `add_time`) VALUES("4","বিজয় দিবস","2024-12-25","2024-12-27 09:30:17");


-- Table structure for table `hotline_settings`
DROP TABLE IF EXISTS `hotline_settings`;
CREATE TABLE `hotline_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `phone_1` varchar(100) NOT NULL,
  `phone_2` varchar(100) DEFAULT NULL,
  `email` varchar(100) NOT NULL,
  `address` varchar(500) NOT NULL,
  `google_map_embed` text NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `hotline_settings`
INSERT INTO `hotline_settings` (`id`, `phone_1`, `phone_2`, `email`, `address`, `google_map_embed`, `date`) VALUES("1","01717452764","01717452764","webbazarbd24@gmail.com","Kaliganj, Lalmonirhat, Ranpur,Bangladesh","<iframe src=\"https://www.google.com/maps/embed?pb=!1m23!1m12!1m3!1d114785.87447169314!2d89.11741509398381!3d25.96611917517843!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!4m8!3e6!4m0!4m5!1s0x39e33d018a5141fd%3A0x3ed1a95fffaef4bb!2sX682%2BJ4C%2C%20Tushbhander!3m2!1d25.966141!2d89.1998167!5e0!3m2!1sen!2sbd!4v1749948390307!5m2!1sen!2sbd\"   width=\"100%\" 
\n                                height=\"450\" 
\n                                style=\"border:0;\" 
\n                                allowfullscreen=\"\" 
\n                                loading=\"lazy\"></iframe>","2025-06-15 00:48:57");


-- Table structure for table `in_bank_invoice`
DROP TABLE IF EXISTS `in_bank_invoice`;
CREATE TABLE `in_bank_invoice` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `bank_name` varchar(100) NOT NULL,
  `billing_type` varchar(100) NOT NULL,
  `ac_no` varchar(100) DEFAULT NULL,
  `name` varchar(250) DEFAULT NULL,
  `mobile` varchar(250) DEFAULT NULL,
  `discription` varchar(250) DEFAULT NULL,
  `reciept` varchar(250) NOT NULL,
  `total_amount` int(20) DEFAULT 0,
  `discount` int(20) DEFAULT 0,
  `due` int(20) DEFAULT 0,
  `paid_amount` int(20) DEFAULT 0,
  `billing_time` varchar(100) NOT NULL,
  `add_date` varchar(100) NOT NULL,
  `update_date` varchar(100) NOT NULL,
  `add_author` longtext NOT NULL,
  `update_author` longtext NOT NULL,
  `check_update` int(20) DEFAULT 0,
  `d_status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `in_bank_invoice`


-- Table structure for table `in_bank_list`
DROP TABLE IF EXISTS `in_bank_list`;
CREATE TABLE `in_bank_list` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `bank_name` varchar(200) NOT NULL,
  `bank_account` varchar(200) NOT NULL,
  `holder_name` varchar(100) NOT NULL,
  `bank_mobile` varchar(250) DEFAULT NULL,
  `balance` int(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `in_bank_list`


-- Table structure for table `income`
DROP TABLE IF EXISTS `income`;
CREATE TABLE `income` (
  `income_id` int(11) NOT NULL AUTO_INCREMENT,
  `income_amount` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `income_details` varchar(250) NOT NULL,
  `income_receipt` varchar(250) NOT NULL,
  `income_date` varchar(255) NOT NULL,
  `income_month` varchar(255) NOT NULL,
  `income_year` varchar(255) NOT NULL,
  PRIMARY KEY (`income_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

-- Dumping data for table `income`
INSERT INTO `income` (`income_id`, `income_amount`, `category_id`, `income_details`, `income_receipt`, `income_date`, `income_month`, `income_year`) VALUES("3","200","5","","","2022-01-29","01","2022");
INSERT INTO `income` (`income_id`, `income_amount`, `category_id`, `income_details`, `income_receipt`, `income_date`, `income_month`, `income_year`) VALUES("4","500","6","","","2022-01-31","01","2022");
INSERT INTO `income` (`income_id`, `income_amount`, `category_id`, `income_details`, `income_receipt`, `income_date`, `income_month`, `income_year`) VALUES("5","500","3","uku","","2022-11-08","11","2022");
INSERT INTO `income` (`income_id`, `income_amount`, `category_id`, `income_details`, `income_receipt`, `income_date`, `income_month`, `income_year`) VALUES("9","90","3","","8e06a13c506c7d4d3ef7343b9a9dee2a.jpg","2022-12-02","12","2022");
INSERT INTO `income` (`income_id`, `income_amount`, `category_id`, `income_details`, `income_receipt`, `income_date`, `income_month`, `income_year`) VALUES("11","900","3","","","2023-05-11","05","2023");


-- Table structure for table `information`
DROP TABLE IF EXISTS `information`;
CREATE TABLE `information` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `person_id` varchar(250) DEFAULT NULL,
  `date_time` varchar(250) DEFAULT NULL,
  `date` varchar(250) DEFAULT NULL,
  `time` varchar(250) DEFAULT NULL,
  `direction` varchar(250) DEFAULT NULL,
  `type` varchar(250) DEFAULT NULL,
  `serial_no` varchar(250) DEFAULT NULL,
  `person_name` varchar(250) DEFAULT NULL,
  `card_no` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=538 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `information`
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("496","17","2024-02-13T17:12:50","2024-02-13","17:12:50","","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("497","18","2024-02-13T17:13:14","2024-02-13","17:13:14","","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("498","18","2024-02-13T17:13:28","2024-02-13","17:13:28","","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("499","18","2024-02-13T17:13:41","2024-02-13","17:13:41","","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("500","17","2024-02-13T17:13:43","2024-02-13","17:13:43","","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("501","17","2024-02-13T17:13:44","2024-02-13","17:13:44","","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("502","17","2024-02-13T17:15:10","2024-02-13","17:15:10","","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("503","17","2024-02-13T17:16:03","2024-02-13","17:16:03","","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("504","18","2024-02-13T17:25:25","2024-02-13","17:25:25","","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("505","17","2024-02-13T17:25:26","2024-02-13","17:25:26","","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("506","18","2024-02-13T17:25:28","2024-02-13","17:25:28","","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("507","18","2024-02-13T17:25:36","2024-02-13","17:25:36","","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("508","17","2024-02-13T17:25:39","2024-02-13","17:25:39","","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("509","18","2024-02-13T17:25:43","2024-02-13","17:25:43","","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("510","17","2024-02-13T17:25:45","2024-02-13","17:25:45","","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("511","18","2024-02-13T17:25:47","2024-02-13","17:25:47","","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("512","17","2024-02-13T17:25:52","2024-02-13","17:25:52","","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("513","18","2024-02-13T17:25:54","2024-02-13","17:25:54","","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("516","18","2024-02-13T17:29:09","2024-02-13","17:29:09","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("517","18","2024-02-13T17:29:24","2024-02-13","17:29:24","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("518","18","2024-02-13T17:29:31","2024-02-13","17:29:31","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("519","17","2024-02-13T17:29:36","2024-02-13","17:29:36","0","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("520","18","2024-02-13T17:30:01","2024-02-13","17:30:01","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("522","18","2024-02-13T17:45:44","2024-02-13","17:45:44","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("523","18","2024-02-13T17:45:50","2024-02-13","17:45:50","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("524","18","2024-02-13T17:45:52","2024-02-13","17:45:52","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("525","18","2024-02-13T17:45:56","2024-02-13","17:45:56","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("526","17","2024-02-13T17:46:01","2024-02-13","17:46:01","0","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("527","17","2024-02-13T17:46:03","2024-02-13","17:46:03","0","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("529","18","2024-02-13T19:12:37","2024-02-13","19:12:37","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("531","17","2024-02-13T19:13:47","2024-02-13","19:13:47","0","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("532","18","2024-02-13T19:13:57","2024-02-13","19:13:57","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("534","18","2024-02-13T19:35:43","2024-02-13","19:35:43","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("535","17","2024-02-13T19:35:55","2024-02-13","19:35:55","0","john","DS-K1T343EFX20220310V030304ENK72668265","Md Ashraful Islam Liton Kondoker tt ttttttt","0003317314");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("536","18","2024-02-13T19:36:08","2024-02-13","19:36:08","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");
INSERT INTO `information` (`id`, `person_id`, `date_time`, `date`, `time`, `direction`, `type`, `serial_no`, `person_name`, `card_no`) VALUES("537","18","2024-02-13T19:36:21","2024-02-13","19:36:21","0","john","DS-K1T343EFX20220310V030304ENK72668265","md rasel","0002676737");


-- Table structure for table `institution_name_ex`
DROP TABLE IF EXISTS `institution_name_ex`;
CREATE TABLE `institution_name_ex` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name_bangla` varchar(255) DEFAULT NULL,
  `name_english` varchar(255) DEFAULT NULL,
  `name_code` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- Dumping data for table `institution_name_ex`
INSERT INTO `institution_name_ex` (`id`, `name_bangla`, `name_english`, `name_code`) VALUES("3","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","Doubari Ideal Public School ",NULL);


-- Table structure for table `jh_payment`
DROP TABLE IF EXISTS `jh_payment`;
CREATE TABLE `jh_payment` (
  `user_pay_id` int(10) NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(200) NOT NULL,
  `student_id` varchar(20) NOT NULL,
  `course_id` int(10) NOT NULL,
  `amount` int(10) NOT NULL,
  `payment_date` varchar(16) CHARACTER SET utf8mb4 NOT NULL,
  `total_payment` varchar(10) CHARACTER SET utf8mb4 NOT NULL,
  `due` int(11) NOT NULL,
  `accept_name` varchar(255) CHARACTER SET utf8mb4 DEFAULT NULL,
  `accept_id` int(11) DEFAULT NULL,
  `status` int(2) NOT NULL COMMENT '1 = complite_payment\r\n2 = incomplite_payment',
  `description_name` varchar(255) NOT NULL,
  `transtion_id` varchar(255) DEFAULT NULL,
  `payment_method` varchar(255) DEFAULT NULL,
  `create_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`user_pay_id`)
) ENGINE=InnoDB AUTO_INCREMENT=98 DEFAULT CHARSET=utf8;

-- Dumping data for table `jh_payment`
INSERT INTO `jh_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`) VALUES("96","1698198532_592102591","1","0","50","2023-10-25","","8950","admin","1","0","5",NULL,NULL,"2023-10-25 01:48:52");
INSERT INTO `jh_payment` (`user_pay_id`, `invoice_id`, `student_id`, `course_id`, `amount`, `payment_date`, `total_payment`, `due`, `accept_name`, `accept_id`, `status`, `description_name`, `transtion_id`, `payment_method`, `create_at`) VALUES("97","1699073197_1689803675","1","0","500","2023-11-04","","8450","admin","1","0","3",NULL,NULL,"2023-11-04 04:46:37");


-- Table structure for table `language_table`
DROP TABLE IF EXISTS `language_table`;
CREATE TABLE `language_table` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `lang` varchar(100) NOT NULL DEFAULT 'en',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `language_table`
INSERT INTO `language_table` (`id`, `lang`) VALUES("1","en");


-- Table structure for table `last_id_history`
DROP TABLE IF EXISTS `last_id_history`;
CREATE TABLE `last_id_history` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `last_id` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `last_id_history`
INSERT INTO `last_id_history` (`id`, `last_id`) VALUES("1","955");


-- Table structure for table `leave_application_v3`
DROP TABLE IF EXISTS `leave_application_v3`;
CREATE TABLE `leave_application_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `regi_id` int(11) NOT NULL,
  `class_teacher` varchar(200) DEFAULT NULL,
  `application_type` varchar(200) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `application_date` datetime NOT NULL,
  `subject` varchar(300) NOT NULL,
  `message` text NOT NULL,
  `approve_by` varchar(200) DEFAULT NULL,
  `status` varchar(200) NOT NULL DEFAULT 'Pending',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `leave_application_v3`
INSERT INTO `leave_application_v3` (`id`, `regi_id`, `class_teacher`, `application_type`, `start_date`, `end_date`, `application_date`, `subject`, `message`, `approve_by`, `status`) VALUES("11","2",NULL,"Sick leave","2025-08-23","2025-08-24","2025-08-23 00:00:00","বাড়িতে বিশেষ কাজ","ুারনক",NULL,"Pending");


-- Table structure for table `login_otp`
DROP TABLE IF EXISTS `login_otp`;
CREATE TABLE `login_otp` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `sending_method` varchar(100) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `custom_sms` varchar(250) DEFAULT NULL,
  `type` varchar(120) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `login_otp`
INSERT INTO `login_otp` (`id`, `sending_method`, `status`, `custom_sms`, `type`) VALUES("1","mobile","off","WebBazarBD YOUR LOG IN OTP","admin");
INSERT INTO `login_otp` (`id`, `sending_method`, `status`, `custom_sms`, `type`) VALUES("2","mobile","off","User Login OTP","user");


-- Table structure for table `logo`
DROP TABLE IF EXISTS `logo`;
CREATE TABLE `logo` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(250) DEFAULT NULL,
  `names` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `logo`


-- Table structure for table `migrations`
DROP TABLE IF EXISTS `migrations`;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table `migrations`


-- Table structure for table `mode_test_exam_v3`
DROP TABLE IF EXISTS `mode_test_exam_v3`;
CREATE TABLE `mode_test_exam_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam` varchar(500) DEFAULT NULL,
  `course` varchar(200) DEFAULT NULL,
  `year` varchar(500) DEFAULT NULL,
  `json_data` text DEFAULT NULL,
  `status` varchar(200) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `mode_test_exam_v3`
INSERT INTO `mode_test_exam_v3` (`id`, `exam`, `course`, `year`, `json_data`, `status`, `date`) VALUES("19","M-1","One","2024","{\"course\":\"One\",\"subjects\":[\"English\",\"Mathematics\",\"environment society and science\"],\"year\":\"2024\",\"exam\":\"M-1\",\"total_mark\":\"100\",\"marks_data\":[{\"student_id\":\"2032\",\"student_name\":\"MD ABRAR AFTAHI\",\"marks\":[{\"subject\":\"English\",\"mark\":\"99\"},{\"subject\":\"Mathematics\",\"mark\":\"80\"},{\"subject\":\"environment society and science\",\"mark\":\"90\"}]},{\"student_id\":\"2031\",\"student_name\":\"Al Imran\",\"marks\":[{\"subject\":\"English\",\"mark\":\"50\"},{\"subject\":\"Mathematics\",\"mark\":\"50\"},{\"subject\":\"environment society and science\",\"mark\":\"50\"}]}]}",NULL,"2024-12-23 03:10:55");


-- Table structure for table `new_sms_permission`
DROP TABLE IF EXISTS `new_sms_permission`;
CREATE TABLE `new_sms_permission` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `active_provider` varchar(200) NOT NULL,
  `admission_status` varchar(200) DEFAULT NULL,
  `status` int(20) NOT NULL DEFAULT 0,
  `mram_api_key` varchar(255) DEFAULT NULL,
  `mram_sender_id` varchar(255) DEFAULT NULL,
  `mram_secret_key` varchar(255) DEFAULT NULL,
  `smsq_api_key` varchar(255) DEFAULT NULL,
  `smsq_sender_id` varchar(255) DEFAULT NULL,
  `smsq_secret_key` varchar(255) DEFAULT NULL,
  `greenweb_api_key` varchar(255) DEFAULT NULL,
  `greenweb_sender_id` varchar(255) DEFAULT NULL,
  `greenweb_secret_key` varchar(255) DEFAULT NULL,
  `webbazarbd_api_key` varchar(255) DEFAULT NULL,
  `webbazarbd_sender_id` varchar(255) DEFAULT NULL,
  `webbazarbd_secret_key` varchar(255) DEFAULT NULL,
  `bulksmsbd_api_key` varchar(255) DEFAULT NULL,
  `bulksmsbd_sender_id` varchar(255) DEFAULT NULL,
  `bulksmsbd_secret_key` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `new_sms_permission`
INSERT INTO `new_sms_permission` (`id`, `active_provider`, `admission_status`, `status`, `mram_api_key`, `mram_sender_id`, `mram_secret_key`, `smsq_api_key`, `smsq_sender_id`, `smsq_secret_key`, `greenweb_api_key`, `greenweb_sender_id`, `greenweb_secret_key`, `webbazarbd_api_key`, `webbazarbd_sender_id`, `webbazarbd_secret_key`, `bulksmsbd_api_key`, `bulksmsbd_sender_id`, `bulksmsbd_secret_key`) VALUES("1","mram","1","1","C300233168a098b2a1ed36.30468283","8809601016151","1","1","1","1","1","1","0","1","1","1","1","1","1");


-- Table structure for table `new_user_table`
DROP TABLE IF EXISTS `new_user_table`;
CREATE TABLE `new_user_table` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `username` varchar(250) DEFAULT NULL,
  `email` varchar(250) DEFAULT NULL,
  `mobile` varchar(250) DEFAULT NULL,
  `password` varchar(250) DEFAULT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  `create_date` varchar(250) DEFAULT NULL,
  `auth` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `new_user_table`
INSERT INTO `new_user_table` (`id`, `name`, `username`, `email`, `mobile`, `password`, `status`, `create_date`, `auth`) VALUES("14","Masuma","masuma14","pukashschoolcollege2015@gmail.com","01727316073","123456","1","1755311407","Resultcontrol & Student");


-- Table structure for table `notification_add_student`
DROP TABLE IF EXISTS `notification_add_student`;
CREATE TABLE `notification_add_student` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `regi` int(11) NOT NULL,
  `sname` varchar(255) CHARACTER SET utf8 NOT NULL,
  `image` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ad_noti` varchar(500) COLLATE utf8_unicode_ci NOT NULL,
  `time_stamp` int(11) NOT NULL,
  `edite_time` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `last_date` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `notification_add_student`
INSERT INTO `notification_add_student` (`id`, `regi`, `sname`, `image`, `ad_noti`, `time_stamp`, `edite_time`, `last_date`) VALUES("16","2","SAFAJANNAT TAHHIYA","","আপনার সন্তানের বকেয়া বেতন ৩ মাস রয়েছ","1754034748","2025-08-01 07:52:28","2025-07-31");


-- Table structure for table `online_admission_switch`
DROP TABLE IF EXISTS `online_admission_switch`;
CREATE TABLE `online_admission_switch` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `online_admission_switch`
INSERT INTO `online_admission_switch` (`id`, `type`, `value`) VALUES("1","online-admission","off");
INSERT INTO `online_admission_switch` (`id`, `type`, `value`) VALUES("2","admission-fee","1500");
INSERT INTO `online_admission_switch` (`id`, `type`, `value`) VALUES("3","max-time","72");
INSERT INTO `online_admission_switch` (`id`, `type`, `value`) VALUES("4","payment-method","bkash");
INSERT INTO `online_admission_switch` (`id`, `type`, `value`) VALUES("5","youtube","https://www.youtube.com/embed/mWZ6b_I-Djg");


-- Table structure for table `online_notice`
DROP TABLE IF EXISTS `online_notice`;
CREATE TABLE `online_notice` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) NOT NULL,
  `notice` longtext NOT NULL,
  `notice_id` varchar(250) NOT NULL,
  `status` int(5) NOT NULL DEFAULT 1,
  `expire_time` varchar(250) NOT NULL,
  `publish_date` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `online_notice`
INSERT INTO `online_notice` (`id`, `title`, `notice`, `notice_id`, `status`, `expire_time`, `publish_date`) VALUES("4","আগামীকাল সফটওয়্যার বন্ধ থাকবে","আগামীকাল সফটওয়্যার বন্ধ থাকবে","10","1","1732201422","1732190622");


-- Table structure for table `operator_description`
DROP TABLE IF EXISTS `operator_description`;
CREATE TABLE `operator_description` (
  `op_id` int(11) NOT NULL AUTO_INCREMENT,
  `op_description` varchar(200) NOT NULL,
  `oprator_image` varchar(100) DEFAULT NULL,
  `oprator_key` varchar(100) NOT NULL,
  `status` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`op_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `operator_description`
INSERT INTO `operator_description` (`op_id`, `op_description`, `oprator_image`, `oprator_key`, `status`) VALUES("3","bkash",NULL,"bkash","payment_operator");
INSERT INTO `operator_description` (`op_id`, `op_description`, `oprator_image`, `oprator_key`, `status`) VALUES("4","Monthly payment",NULL,"monthly_payment","payment_description");
INSERT INTO `operator_description` (`op_id`, `op_description`, `oprator_image`, `oprator_key`, `status`) VALUES("9","Cash",NULL,"cash","payment_operator");


-- Table structure for table `p_customer`
DROP TABLE IF EXISTS `p_customer`;
CREATE TABLE `p_customer` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `categories_id` int(20) DEFAULT NULL,
  `mobile` varchar(100) NOT NULL,
  `duration` varchar(100) DEFAULT NULL,
  `address` varchar(150) NOT NULL,
  `add_date` varchar(100) NOT NULL,
  `update_date` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `p_customer`


-- Table structure for table `p_customer_categories`
DROP TABLE IF EXISTS `p_customer_categories`;
CREATE TABLE `p_customer_categories` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `p_customer_categories`


-- Table structure for table `p_invoice`
DROP TABLE IF EXISTS `p_invoice`;
CREATE TABLE `p_invoice` (
  `p_in_id` int(10) NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) NOT NULL,
  `customer_name` varchar(150) NOT NULL,
  `customer_mobile` varchar(50) NOT NULL,
  `customer_address` varchar(250) NOT NULL,
  `product_information` longtext NOT NULL,
  `files` varchar(100) DEFAULT NULL,
  `description` varchar(250) DEFAULT NULL,
  `total_amount` int(20) DEFAULT NULL,
  `discount` int(20) DEFAULT NULL,
  `due` int(20) DEFAULT NULL,
  `paid_amount` int(20) DEFAULT NULL,
  `add_date` varchar(100) DEFAULT NULL,
  `update_date` varchar(100) DEFAULT NULL,
  `create_date` varchar(100) NOT NULL,
  `d_status` int(10) DEFAULT 1,
  PRIMARY KEY (`p_in_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `p_invoice`


-- Table structure for table `p_invoice_temp`
DROP TABLE IF EXISTS `p_invoice_temp`;
CREATE TABLE `p_invoice_temp` (
  `temp_in_id` int(20) NOT NULL AUTO_INCREMENT,
  `in_id` int(20) NOT NULL,
  `temp_mobile` varchar(100) NOT NULL,
  `temp_amount` int(20) NOT NULL,
  `temp_date` varchar(100) NOT NULL,
  `temp_dates` varchar(250) NOT NULL,
  `d_status` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`temp_in_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `p_invoice_temp`


-- Table structure for table `p_product`
DROP TABLE IF EXISTS `p_product`;
CREATE TABLE `p_product` (
  `p_id` int(20) NOT NULL AUTO_INCREMENT,
  `p_name` varchar(250) NOT NULL,
  `p_amount` int(20) NOT NULL,
  `p_add_date` varchar(100) DEFAULT NULL,
  `p_update_date` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`p_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `p_product`
INSERT INTO `p_product` (`p_id`, `p_name`, `p_amount`, `p_add_date`, `p_update_date`) VALUES("1","SM PDF APPS","1000","2023-12-15","2023-12-15");
INSERT INTO `p_product` (`p_id`, `p_name`, `p_amount`, `p_add_date`, `p_update_date`) VALUES("2","SMS SOFT APP","2000","2023-12-15","2023-12-15");


-- Table structure for table `password_resets`
DROP TABLE IF EXISTS `password_resets`;
CREATE TABLE `password_resets` (
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table `password_resets`


-- Table structure for table `payment_redirect`
DROP TABLE IF EXISTS `payment_redirect`;
CREATE TABLE `payment_redirect` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `link_name` varchar(250) DEFAULT NULL,
  `status` int(20) NOT NULL,
  `note` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- Dumping data for table `payment_redirect`
INSERT INTO `payment_redirect` (`id`, `link_name`, `status`, `note`) VALUES("1","bangla","0",NULL);
INSERT INTO `payment_redirect` (`id`, `link_name`, `status`, `note`) VALUES("2","english","0","");
INSERT INTO `payment_redirect` (`id`, `link_name`, `status`, `note`) VALUES("3","english2","0",NULL);
INSERT INTO `payment_redirect` (`id`, `link_name`, `status`, `note`) VALUES("4","pos_english","0",NULL);
INSERT INTO `payment_redirect` (`id`, `link_name`, `status`, `note`) VALUES("5","pos_bangla","0",NULL);
INSERT INTO `payment_redirect` (`id`, `link_name`, `status`, `note`) VALUES("6","invoice-6","1","Please make the payment by the due date to avoid any late fees. For assistance, contact the finance department and reference your student ID");


-- Table structure for table `permissions`
DROP TABLE IF EXISTS `permissions`;
CREATE TABLE `permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `module` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=167 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `permissions`
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("76","Student","Dashboard","2025-04-03 05:28:47");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("77","Student Seat Plane","Dashboard","2025-04-03 05:29:14");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("78","Routine All","Dashboard","2025-04-03 05:29:44");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("79","Attendance","Dashboard","2025-04-03 05:30:03");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("80","Examination","Dashboard","2025-04-03 05:30:16");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("81","Registration","Dashboard","2025-04-03 05:30:32");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("82","Card Information","Dashboard","2025-04-03 05:30:44");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("83","Card Expiry","Dashboard","2025-04-03 05:30:54");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("84","Testimonial","Dashboard","2025-04-03 05:31:04");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("85","Basic Certificate","Dashboard","2025-04-03 05:31:14");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("86","Class,Group,Session,Section,Shift","Dashboard","2025-04-03 05:31:26");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("87","Institution Name","Dashboard","2025-04-03 05:31:37");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("88","Teacher Panel","Dashboard","2025-04-03 05:31:47");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("89","SMS Panel","Dashboard","2025-04-03 05:31:57");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("90","Note Notification","Dashboard","2025-04-03 05:32:09");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("91","Staff Entry","Dashboard","2025-04-03 05:32:34");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("92","Notice","Dashboard","2025-04-03 05:32:37");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("93","Promotion","Dashboard","2025-04-03 05:32:46");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("94","Visitor Portal","Dashboard","2025-04-03 05:32:54");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("95","Backup","Dashboard","2025-04-03 05:33:04");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("96","Subjects,Mark,Grading,eSif","Resultcontrol","2025-04-03 05:47:11");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("97","Certificate Manage","Resultcontrol","2025-04-03 05:47:35");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("98","MarkSheet","Resultcontrol","2025-04-03 05:47:46");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("99","TabilationSheet","Resultcontrol","2025-04-03 05:48:14");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("100","Student List,DCR,Blank Mark Input","Resultcontrol","2025-04-03 05:48:44");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("101","Progressive Report","Resultcontrol","2025-04-03 05:49:00");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("102","Result SMS","Resultcontrol","2025-04-03 05:49:15");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("103","Result Settings","Resultcontrol","2025-04-03 05:49:37");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("104","Role Management","Dashboard","2025-04-04 02:37:31");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("105","Resultcontrol Panel","Dashboard","2025-04-04 03:50:43");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("106","Activity Panel","Dashboard","2025-04-04 03:51:09");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("107","Accounting Panel","Dashboard","2025-04-04 03:51:21");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("108","Study Management","Activity","2025-04-04 03:53:48");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("109","Activity Management","Activity","2025-04-04 03:54:08");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("110","Holidays Management","Activity","2025-04-04 03:54:23");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("111","TC Management","Activity","2025-04-04 03:54:37");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("112","Applications Management","Activity","2025-04-04 03:54:56");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("113","Activity Settings","Activity","2025-04-04 03:55:11");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("115","Costs & Incomes","Accounting","2025-04-04 04:03:00");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("117","Due SMS System","Accounting","2025-04-04 04:03:53");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("118","Ledger","Accounting","2025-04-04 04:04:29");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("119","Setup","Accounting","2025-04-04 04:04:40");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("121","Payment Requests","Accounting","2025-04-04 04:05:13");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("122","SSL Payment","Accounting","2025-04-04 04:05:23");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("123","Manage bKash","Accounting","2025-04-04 04:05:44");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("124","Accounting Settings","Accounting","2025-04-04 04:05:57");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("128","Delete Log","Accounting","2025-04-16 02:16:57");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("129","Temporary Application","Temporary AD","2025-04-26 06:55:48");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("130","Manual Payment Request","Temporary AD","2025-04-26 06:56:16");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("131","Exams Temporary AD","Temporary AD","2025-04-26 06:56:41");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("132","Exam Selected Student","Temporary AD","2025-04-26 06:56:55");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("133","Admit Instructions","Temporary AD","2025-04-26 06:57:05");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("134","Admit Cards","Temporary AD","2025-04-26 06:57:16");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("135","Exam Attend Entry","Temporary AD","2025-04-26 06:57:26");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("136","Mark Input","Temporary AD","2025-04-26 06:57:39");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("137","Tiem Over Student","Temporary AD","2025-04-26 06:57:52");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("138","Move Student","Temporary AD","2025-04-26 06:58:03");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("139","SSLCommerz Payment","Temporary AD","2025-04-26 06:58:19");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("140","Bkash Payment","Temporary AD","2025-04-26 06:58:31");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("141","Settings Temporary AD","Temporary AD","2025-04-26 06:58:48");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("142","Temporary AD Panel","Dashboard","2025-04-26 06:59:27");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("143","Fee Collection Temporary AD","Temporary AD","2025-04-28 07:52:22");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("144","Fee Payment","Temporary AD","2025-04-28 07:52:32");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("145","Fee Manual Request","Temporary AD","2025-04-28 07:52:41");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("146","SSL Fee Payment","Temporary AD","2025-04-28 07:52:50");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("147","Bkash Fee Payment","Temporary AD","2025-04-28 07:53:02");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("148","Collection Report Temporary AD","Temporary AD","2025-04-28 12:16:01");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("149","Temp Application SMS","Temporary AD","2025-04-30 10:36:45");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("150","Exam Selected SMS","Temporary AD","2025-04-30 10:37:01");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("151","Fee Settings","Temporary AD","2025-04-30 10:37:19");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("152","SMS Settings Temporary AD","Temporary AD","2025-04-30 10:37:33");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("153","Notice Seetings","Temporary AD","2025-05-03 03:38:02");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("154","Exam Fee Collection","Temporary AD","2025-05-04 13:27:51");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("155","Bank Management","Accounting","2025-05-23 16:30:44");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("156","Dashboard Settings","Dashboard","2025-05-27 05:15:19");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("158","Fee Collection","Accounting","2025-05-31 14:40:39");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("163","Collection Due","Accounting","2025-05-31 14:41:30");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("165","DCR","Accounting","2025-06-06 12:24:16");
INSERT INTO `permissions` (`id`, `name`, `module`, `created_at`) VALUES("166","Accounting Dashboard","Accounting","2025-07-03 13:38:36");


-- Table structure for table `person_categories`
DROP TABLE IF EXISTS `person_categories`;
CREATE TABLE `person_categories` (
  `cat_id` int(20) NOT NULL AUTO_INCREMENT,
  `cat_name` varchar(250) NOT NULL,
  PRIMARY KEY (`cat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `person_categories`


-- Table structure for table `personal_access_tokens`
DROP TABLE IF EXISTS `personal_access_tokens`;
CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table `personal_access_tokens`


-- Table structure for table `print_template`
DROP TABLE IF EXISTS `print_template`;
CREATE TABLE `print_template` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `image` varchar(200) DEFAULT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  `template_no` int(10) NOT NULL,
  `card_no` varchar(255) DEFAULT NULL,
  `bottom_page` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `print_template`
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("1","template/template_1761395918_1.From_d-1-School_English.png","0","1","1-School_English",NULL);
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("2","template/template_1707699923_From_d_BN-2.png","0","2","2-School_Bangla",NULL);
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("3","template/template_1711596292_3.from-d-3-School_English.png","0","3","3-School_English",NULL);
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("4","template/template_1723073889_4.from-d-4-Coaching_English.png","0","4","4-Coaching_English",NULL);
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("5","template/template_1761396456_5.From-d-5-Madrsha_Bangla.png","0","5","5-Madrsha_Bangla",NULL);
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("6","template/template_1733987956_6.From-d-6-Coaching_English.png","0","6","6-Coaching_English",NULL);
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("7","template/template_1711598186_7.from-d-7-Coaching_English.png","0","7","7-Coaching_English",NULL);
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("8","template/template_1723348327_8.from-d-8-Coaching_English.png","0","8","8-Coaching_English",NULL);
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("9","template/template_1731939036_08 ADMISSION  new Form-images-0.jpg","0","9","9-JAMIA ISLAMIA DARUL","template/template_1731939043_08 ADMISSION  new Form-images-1.jpg");
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("10","template/template_1733642272_10.From-d-10-Madrsha_Bangla.png","0","10","10-Madrsha_Bangla",NULL);
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("11","template/template_1754061722_13-English.png","1","11","11-সকল প্রতিষ্ঠানের জন্য -ইংলিশ",NULL);
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("12","template/template_1754061731_14_Bangla.png","0","12","12-সকল প্রতিষ্ঠানের জন্য -বাংলা",NULL);
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("13","template/template_1761396357_13-English.png","0","13","13-Madrsha",NULL);
INSERT INTO `print_template` (`id`, `image`, `status`, `template_no`, `card_no`, `bottom_page`) VALUES("14","template/template_1761396267_14_Bangla.png","0","14","14-Madrsha_English",NULL);


-- Table structure for table `quota_student`
DROP TABLE IF EXISTS `quota_student`;
CREATE TABLE `quota_student` (
  `quota_stu_id` int(11) NOT NULL AUTO_INCREMENT,
  `quota_ba` varchar(255) NOT NULL,
  `quota_en` varchar(255) NOT NULL,
  PRIMARY KEY (`quota_stu_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- Dumping data for table `quota_student`
INSERT INTO `quota_student` (`quota_stu_id`, `quota_ba`, `quota_en`) VALUES("2","নাই","N/A");


-- Table structure for table `regination_settings`
DROP TABLE IF EXISTS `regination_settings`;
CREATE TABLE `regination_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sig1_name` varchar(5000) DEFAULT NULL,
  `sig2_name` varchar(500) DEFAULT NULL,
  `note1` text DEFAULT NULL,
  `note2` text DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `image` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `regination_settings`
INSERT INTO `regination_settings` (`id`, `sig1_name`, `sig2_name`, `note1`, `note2`, `issue_date`, `image`) VALUES("1","Signature of the Student	","Signature of Head of the Institute","This Registration card is Valid for six months.","For all communications with the insititute code, registation number and session are be mentioned.","2025-03-12","img/1744961795_sig1_background.png");


-- Table structure for table `role_permissions`
DROP TABLE IF EXISTS `role_permissions`;
CREATE TABLE `role_permissions` (
  `role_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  PRIMARY KEY (`role_id`,`permission_id`),
  KEY `permission_id` (`permission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `role_permissions`
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","76");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","77");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","78");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","79");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","80");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","81");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","82");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","83");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","84");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","85");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","86");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","87");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","88");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","89");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","90");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","91");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","92");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","93");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","94");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","95");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","96");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","97");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","98");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","99");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","100");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","101");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","102");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","103");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","104");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","105");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","106");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","107");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","108");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","109");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","110");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","111");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","112");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","113");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","115");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","117");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","118");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","119");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","121");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","122");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","123");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","124");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","128");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","129");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","130");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","131");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","132");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","133");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","134");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","135");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","136");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","137");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","138");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","139");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","140");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","141");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","142");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","143");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","144");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","145");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","146");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","147");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","148");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","149");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","150");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","151");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","152");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","153");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","154");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","155");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","156");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","157");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","158");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","159");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","160");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","161");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","162");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","163");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","164");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","165");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("5","166");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("7","76");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("8","107");
INSERT INTO `role_permissions` (`role_id`, `permission_id`) VALUES("8","121");


-- Table structure for table `roles`
DROP TABLE IF EXISTS `roles`;
CREATE TABLE `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `roles`
INSERT INTO `roles` (`id`, `name`, `description`, `created_at`) VALUES("5","admin","","2025-04-03 03:21:49");
INSERT INTO `roles` (`id`, `name`, `description`, `created_at`) VALUES("7","Resultcontrol & Student","","2025-04-04 02:51:39");
INSERT INTO `roles` (`id`, `name`, `description`, `created_at`) VALUES("8","Accounting Manager","","2025-04-17 03:24:06");


-- Table structure for table `room`
DROP TABLE IF EXISTS `room`;
CREATE TABLE `room` (
  `room_id` int(11) NOT NULL AUTO_INCREMENT,
  `room_name` varchar(255) NOT NULL,
  PRIMARY KEY (`room_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

-- Dumping data for table `room`
INSERT INTO `room` (`room_id`, `room_name`) VALUES("1","101");
INSERT INTO `room` (`room_id`, `room_name`) VALUES("2","107");
INSERT INTO `room` (`room_id`, `room_name`) VALUES("11","100");


-- Table structure for table `save_routine_v3`
DROP TABLE IF EXISTS `save_routine_v3`;
CREATE TABLE `save_routine_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` varchar(100) DEFAULT NULL,
  `shift` varchar(100) DEFAULT NULL,
  `section` varchar(100) DEFAULT NULL,
  `year` varchar(100) DEFAULT NULL,
  `exam_id` varchar(100) DEFAULT NULL,
  `branch` varchar(100) DEFAULT NULL,
  `academic_year` varchar(100) DEFAULT NULL,
  `routine_details` text DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `status` varchar(100) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `save_routine_v3`
INSERT INTO `save_routine_v3` (`id`, `course_id`, `shift`, `section`, `year`, `exam_id`, `branch`, `academic_year`, `routine_details`, `start_date`, `end_date`, `status`, `date`) VALUES("3","211","Morning","A","2024","7","General","2024-2025","{\"subject_id\":\"Quaran 5\",\"date\":\"2024-11-08\",\"start_time\":\"13:25\",\"end_time\":\"13:25\"}",NULL,NULL,"","2024-11-12 05:23:37");
INSERT INTO `save_routine_v3` (`id`, `course_id`, `shift`, `section`, `year`, `exam_id`, `branch`, `academic_year`, `routine_details`, `start_date`, `end_date`, `status`, `date`) VALUES("4","211","Morning","A","2024","4","General","2024-2025","[{\"subject_id\":\"\\u0987\\u09b8\\u09b2\\u09be\\u09ae\\u09c7\\u09b0 \\u0987\\u09a4\\u09bf\\u09b9\\u09be\\u09b8\",\"date\":\"2024-11-13\",\"start_time\":\"11:31\",\"end_time\":\"11:32\"},{\"subject_id\":\"\\u09b8\\u09be\\u09a7\\u09be\\u09b0\\u09a3 \\u099c\\u09cd\\u099e\\u09be\\u09a8\",\"date\":\"2024-11-17\",\"start_time\":\"11:33\",\"end_time\":\"11:31\"},{\"subject_id\":\"Quaran 5\",\"date\":\"2024-11-15\",\"start_time\":\"11:32\",\"end_time\":\"11:30\"}]",NULL,NULL,"","2024-11-12 05:29:46");
INSERT INTO `save_routine_v3` (`id`, `course_id`, `shift`, `section`, `year`, `exam_id`, `branch`, `academic_year`, `routine_details`, `start_date`, `end_date`, `status`, `date`) VALUES("5","201","","","","","General","","[{\"subject_id\":\"Bangla\",\"date\":\"2025-05-28\",\"start_time\":\"14:07\",\"end_time\":\"14:07\"},{\"subject_id\":\"English\",\"date\":\"2025-05-30\",\"start_time\":\"17:07\",\"end_time\":\"14:06\"},{\"subject_id\":\"environment and 52\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"English9\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"society and science\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"science\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"English3\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"English4\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"English5\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"English6\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"English7\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"English8\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"}]",NULL,NULL,NULL,"2025-05-13 08:03:26");
INSERT INTO `save_routine_v3` (`id`, `course_id`, `shift`, `section`, `year`, `exam_id`, `branch`, `academic_year`, `routine_details`, `start_date`, `end_date`, `status`, `date`) VALUES("6","201","Morning","A","2024","10","","2024-2025","[{\"subject_id\":\"Bangla\",\"date\":\"2025-05-14\",\"start_time\":\"14:06\",\"end_time\":\"14:09\"},{\"subject_id\":\"English\",\"date\":\"2025-05-31\",\"start_time\":\"14:07\",\"end_time\":\"14:06\"},{\"subject_id\":\"environment and 52\",\"date\":\"2025-05-24\",\"start_time\":\"14:08\",\"end_time\":\"14:07\"},{\"subject_id\":\"English9\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"society and science\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"science\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"English3\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"English4\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"English5\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"English6\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"English7\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"English8\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"}]",NULL,NULL,NULL,"2025-05-13 08:04:04");
INSERT INTO `save_routine_v3` (`id`, `course_id`, `shift`, `section`, `year`, `exam_id`, `branch`, `academic_year`, `routine_details`, `start_date`, `end_date`, `status`, `date`) VALUES("7","1","","A","2024","12","General","2024-2025","[{\"subject_id\":\"Bangla\",\"date\":\"2025-05-13\",\"start_time\":\"20:57\",\"end_time\":\"20:57\"},{\"subject_id\":\"English\",\"date\":\"2025-05-14\",\"start_time\":\"20:55\",\"end_time\":\"20:55\"},{\"subject_id\":\"environment and 52\",\"date\":\"2025-05-15\",\"start_time\":\"20:56\",\"end_time\":\"20:55\"},{\"subject_id\":\"English9\",\"date\":\"2025-05-14\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"society and science\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"science\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"English3\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"English4\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"English5\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"English6\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"English7\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"},{\"subject_id\":\"English8\",\"date\":\"\",\"start_time\":\"\",\"end_time\":\"\"}]","2025-05-13","2025-05-30",NULL,"2025-05-13 14:53:57");


-- Table structure for table `semester_exam_v3`
DROP TABLE IF EXISTS `semester_exam_v3`;
CREATE TABLE `semester_exam_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` varchar(200) DEFAULT NULL,
  `class` varchar(200) DEFAULT NULL,
  `subject` varchar(200) DEFAULT NULL,
  `mt` varchar(200) DEFAULT NULL,
  `semester` varchar(200) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `semester_exam_v3`
INSERT INTO `semester_exam_v3` (`id`, `year`, `class`, `subject`, `mt`, `semester`, `date`) VALUES("2","2024","3","19","65","55","2024-11-30 02:23:36");
INSERT INTO `semester_exam_v3` (`id`, `year`, `class`, `subject`, `mt`, `semester`, `date`) VALUES("4","2024","3","17","30","50","2024-11-30 02:30:52");
INSERT INTO `semester_exam_v3` (`id`, `year`, `class`, `subject`, `mt`, `semester`, `date`) VALUES("5","2024","3","18","50","25","2024-11-30 02:31:04");
INSERT INTO `semester_exam_v3` (`id`, `year`, `class`, `subject`, `mt`, `semester`, `date`) VALUES("7","2024","3","20","50","25","2024-12-02 03:51:56");
INSERT INTO `semester_exam_v3` (`id`, `year`, `class`, `subject`, `mt`, `semester`, `date`) VALUES("8","2024","3","21","100","33","2024-12-02 03:52:10");
INSERT INTO `semester_exam_v3` (`id`, `year`, `class`, `subject`, `mt`, `semester`, `date`) VALUES("9","2024","3","22","100","50","2024-12-02 03:52:23");
INSERT INTO `semester_exam_v3` (`id`, `year`, `class`, `subject`, `mt`, `semester`, `date`) VALUES("10","2024","3","23","100","90","2024-12-02 03:52:34");
INSERT INTO `semester_exam_v3` (`id`, `year`, `class`, `subject`, `mt`, `semester`, `date`) VALUES("12","2024","3","44","70","30","2024-12-02 04:05:46");


-- Table structure for table `sessions`
DROP TABLE IF EXISTS `sessions`;
CREATE TABLE `sessions` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payload` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- Dumping data for table `sessions`
INSERT INTO `sessions` (`id`, `user_id`, `ip_address`, `user_agent`, `payload`, `last_activity`) VALUES("1","0","::1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36","YTozOntzOjY6Il90b2tlbiI7czo0MDoiU2l4emFiWDA5NjFValNDb1ZUNHZ0RVlndnlSRTBydDdiS3hTMmloWCI7czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6NTI6Imh0dHA6Ly9sb2NhbGhvc3Qvc3R1ZGVudF9tYW5hZ21lbnRfc3lzdGVtL3Ntcy9wdWJsaWMiO31zOjY6Il9mbGFzaCI7YToyOntzOjM6Im9sZCI7YTowOnt9czozOiJuZXciO2E6MDp7fX19","1625916890");


-- Table structure for table `set_grade_system_v3`
DROP TABLE IF EXISTS `set_grade_system_v3`;
CREATE TABLE `set_grade_system_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `system_name` varchar(500) NOT NULL,
  `grade_id` int(11) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `set_grade_system_v3`
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("1","marksheet_1","8","2025-01-11 04:06:01");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("2","marksheet_2","8","2025-05-07 11:54:40");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("3","marksheet_3","8","2025-05-07 11:53:55");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("4","marksheet_4","8","2025-01-11 04:06:08");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("6","marksheet_6","8","2025-05-07 11:54:44");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("7","marksheet_7","8","2025-01-11 04:06:12");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("10","merit_list_1","8","2025-01-11 04:06:13");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("11","merit_list_2","8","2025-01-11 04:06:15");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("12","certificate_english","8","2025-01-11 04:06:17");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("13","certificate_bangla","8","2025-01-11 04:06:20");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("14","certification_letter_en","8","2025-01-11 04:06:24");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("15","certification_letter","8","2025-01-11 04:06:49");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("16","progressive_report_1","8","2025-01-11 04:06:45");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("17","progressive_report_2","8","2025-01-11 04:06:41");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("18","progressive_report_3","8","2025-01-11 04:06:36");
INSERT INTO `set_grade_system_v3` (`id`, `system_name`, `grade_id`, `date`) VALUES("19","progressive_report_4","8","2025-01-11 04:06:33");


-- Table structure for table `settings`
DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `regi_system` varchar(10) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `slogan` varchar(255) DEFAULT NULL,
  `school_name` varchar(255) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `contact_info` text DEFAULT NULL,
  `admission_form_primary_color` varchar(20) DEFAULT '#2c5aa0',
  `admission_previews` varchar(20) DEFAULT NULL,
  `admission_form_text_color` varchar(7) DEFAULT '#333333',
  `admission_header_bg_color` varchar(200) DEFAULT NULL,
  `signature_1` varchar(255) DEFAULT NULL,
  `signature_2` varchar(255) DEFAULT NULL,
  `admission_form_header_text_color` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `settings`
INSERT INTO `settings` (`id`, `regi_system`, `date`, `slogan`, `school_name`, `address`, `contact_info`, `admission_form_primary_color`, `admission_previews`, `admission_form_text_color`, `admission_header_bg_color`, `signature_1`, `signature_2`, `admission_form_header_text_color`) VALUES("1","new","2025-11-21 02:49:11","স্বপ্ন পূরণের প্রথম ধাপ, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল সর্বদা আপনার পাশে।","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","গ্রাম : ডৌবাড়ী ,উপজেলাঃ গোয়াইনঘাট,জেলাঃ সিলেট,বিভাগ ঃ সিলেট","doubariidealpublicschool@gmail.com
\n01727316073","#570000","on","#050505","#00a876","Student signature","Principal\'s Signature","#ffffff");


-- Table structure for table `settings_certificate_v3`
DROP TABLE IF EXISTS `settings_certificate_v3`;
CREATE TABLE `settings_certificate_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `certificate_english` varchar(2000) NOT NULL,
  `certificate_bangla` varchar(2000) NOT NULL,
  `certificate_letter_english` varchar(2000) NOT NULL,
  `certificate_letter_bangla` varchar(2000) NOT NULL,
  `signature_1` varchar(200) NOT NULL,
  `signature_2` varchar(200) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `certificate_english_head` varchar(200) NOT NULL,
  `certificate_bangla_head` varchar(200) NOT NULL,
  `certificate_letter_english_head` varchar(200) NOT NULL,
  `certificate_letter_bangla_head` varchar(200) NOT NULL,
  `certificate_cover` varchar(255) DEFAULT NULL,
  `watermark` varchar(255) DEFAULT NULL,
  `signature_1_img` varchar(255) DEFAULT NULL,
  `signature_2_img` varchar(255) DEFAULT NULL,
  `hide_head` varchar(20) DEFAULT 'head_show',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `settings_certificate_v3`
INSERT INTO `settings_certificate_v3` (`id`, `certificate_english`, `certificate_bangla`, `certificate_letter_english`, `certificate_letter_bangla`, `signature_1`, `signature_2`, `date`, `certificate_english_head`, `certificate_bangla_head`, `certificate_letter_english_head`, `certificate_letter_bangla_head`, `certificate_cover`, `watermark`, `signature_1_img`, `signature_2_img`, `hide_head`) VALUES("1","This is to certify that `student_name`, daughter of `fname`,  student of `website_name` , `address` , bearing Student ID `student_regi_no`, Roll No. `roll` and studying Class `course_name` , `Failed_or_Passed` the `exam_name`  of `year` in `branch` Group and obtained a G.P.A of `gpa` in the scale of 5.00.","এই মর্মে সার্টিফিকেট প্রদান করা যাচ্ছে যে `student_name`, পিতা `fname`, `website_name_bn`, `address_bn` এর ছাত্রী, যার ছাত্র আইডি `student_reg_no`,  রোল নম্বর `roll_2` এবং শ্রেণী `course_name` এ অধ্যয়নরত `Failed_or_Passed` হয়েছে `exam_name` পরীক্ষায় `year` সালে `branch` গ্রুপে এবং ৫.০০ এর স্কেলে একটি জি.পি.এ `gpa` অর্জন করেছে।","He/She has been a regular student of this institution in the year `year`, in the class `course_name`, and has passed with a GPA of `gpa` He/She is eligible for promotion to the next class. This certificate is issued upon the request of the guardian.","সে এই প্রতিষ্ঠানে একজন নিয়মিত শিক্ষার্থী হিসেবে `year` সালে,  `course_name` শ্রেণিতে , জিপিএ `gpa` পেয়ে উত্তীর্ণ হয়েছে। সে পরবর্তী শ্রেণিতে উন্নীত হওয়ার যোগ্য। তার অভিভাবকের আবেদনের প্রেক্ষিতে প্রত্যয়নপত্র প্রদান করা হল।","পরীক্ষা আহ্বায়ক","প্রধান শিক্ষক","2025-11-16 16:55:40","Certificate1","সার্টিফিকেট1","Testimonial English ","প্রত্যয়ন পত্র","certificate_cover_1752752883_6721.png","watermark_1761843852_8959.jpg","signature_1_img_1752596943_5760.png","signature_2_img_1763312140_3176.jpg","head_show");


-- Table structure for table `settings_v3`
DROP TABLE IF EXISTS `settings_v3`;
CREATE TABLE `settings_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `website_name` varchar(250) NOT NULL,
  `short_name` varchar(100) NOT NULL,
  `website_name_bn` varchar(500) NOT NULL,
  `email` varchar(250) NOT NULL,
  `phone` varchar(250) NOT NULL,
  `logo` varchar(500) NOT NULL,
  `watermark` varchar(500) NOT NULL,
  `result_system` varchar(200) NOT NULL,
  `address` varchar(500) NOT NULL,
  `address_bn` varchar(200) NOT NULL,
  `site_url` varchar(200) NOT NULL,
  `col_1` varchar(200) NOT NULL,
  `col_3` varchar(200) NOT NULL,
  `col_2` varchar(200) NOT NULL,
  `col_4` varchar(200) DEFAULT NULL,
  `result_show` varchar(500) NOT NULL,
  `signature_1` varchar(200) NOT NULL,
  `signature_2` varchar(200) NOT NULL,
  `holidays` text NOT NULL,
  `grading_formula` text NOT NULL,
  `slogan` varchar(300) NOT NULL,
  `sms_content` varchar(1000) NOT NULL,
  `certificate_cover` varchar(200) NOT NULL,
  `hide_head` varchar(200) DEFAULT NULL,
  `backup_path` text DEFAULT NULL,
  `signature_1_text` varchar(100) DEFAULT NULL,
  `signature_2_text` varchar(100) DEFAULT NULL,
  `marksheet_attendance` varchar(20) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `curriculum_activities` varchar(255) DEFAULT NULL,
  `gpa_details` text DEFAULT NULL,
  `sms_content_model_test` varchar(255) DEFAULT NULL,
  `sms_send_status` varchar(255) DEFAULT NULL,
  `progressive_report_2_note` varchar(500) DEFAULT NULL,
  `progressive_report_3_note` varchar(500) DEFAULT NULL,
  `marksheet_merit_position_show` varchar(255) DEFAULT NULL,
  `official_website_link` varchar(255) DEFAULT NULL,
  `result_show_default_year` varchar(255) DEFAULT NULL,
  `result_publish_date` varchar(255) DEFAULT NULL,
  `marksheet_comment` varchar(255) DEFAULT NULL,
  `gpa_detail_title` varchar(255) DEFAULT NULL,
  `curriculum_title` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `settings_v3`
INSERT INTO `settings_v3` (`id`, `website_name`, `short_name`, `website_name_bn`, `email`, `phone`, `logo`, `watermark`, `result_system`, `address`, `address_bn`, `site_url`, `col_1`, `col_3`, `col_2`, `col_4`, `result_show`, `signature_1`, `signature_2`, `holidays`, `grading_formula`, `slogan`, `sms_content`, `certificate_cover`, `hide_head`, `backup_path`, `signature_1_text`, `signature_2_text`, `marksheet_attendance`, `date`, `curriculum_activities`, `gpa_details`, `sms_content_model_test`, `sms_send_status`, `progressive_report_2_note`, `progressive_report_3_note`, `marksheet_merit_position_show`, `official_website_link`, `result_show_default_year`, `result_publish_date`, `marksheet_comment`, `gpa_detail_title`, `curriculum_title`) VALUES("1","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল","pukashschoolcollege2015@gmail.com","01727316073","logo_1761701403_2logo.png","watermark_1761701403_2logo.png","regular","গ্রাম : ডৌবাড়ী ,উপজেলাঃ গোয়াইনঘাট,জেলাঃ সিলেট,বিভাগ ঃ সিলেট","গ্রাম : ডৌবাড়ী ,উপজেলাঃ গোয়াইনঘাট,জেলাঃ সিলেট,বিভাগ ঃ সিলেট","https://doubariidealpublicschool.top/sms/","CQ","PR","MCQ","Final","mark_sheet_6","signature_1_1735149414_Screenshot_8.png","signature_2_1735149414_Screenshot_6.png","Friday,Saturday","grading_formula2","আপনার সন্তান গড়ে তোলার দায়িত্ব আমাদের","`exam_name`, `student_name_bn` , আইডি: `student_id_bn`, ক্লাস: `class_bn`, জিপিএ : `gpa_bn` পেয়েছো, মোট নাম্বার: `total_mark_bn`, সর্বোচ্চ নাম্বার : `max_mark_bn`।, মেরিট পজিশন: `position_bn`।  `school_name`।","certificate_cover_1736073774_Untitled design.png","head_show","students-image,stuImages,images, resultcontrol/images,activity/images,activity/students-image,id-card-control/image,teacher_registration_data/images,staff_data/images,admin_notic,accounting/images,admission/template,temporary_ad/uploads/notices","Signature 1 Text","Signature 2 Text","on","2025-12-04 07:46:35","খেলাধুলা, গজল, প্রতিযোগিতা, সাংস্কৃতিক অনুষ্ঠান, কুইজ ও বিভিন্ন সৃজনশীল কার্যক্রম।","[{\"gpa\":\"5.00\",\"text\":\"মাশাল্লাহ, খুব ভালো\"},{\"gpa\":\"4.00\",\"text\":\"সন্তোষজনক আরও ভালো করার সুযোগ আছে\"},{\"gpa\":\"3.00\",\"text\":\"একটু ভাল আরো ভাল করতে হবে\"},{\"gpa\":\"2.00\",\"text\":\"পাস করেছে, আরও চেষ্টা প্রয়োজন\"},{\"gpa\":\"1.00\",\"text\":\"দুর্বল, অনেক বেশি পরিশ্রম করতে হবে\"},{\"gpa\":\"0.00\",\"text\":\"ফেল – আবার চেষ্টা করো\"}]","exam_name, student_name_en , আইডি: student_id_en, ক্লাস: class, মোট নাম্বার: total_mark_bn, পেয়েছো ।  school_name","on","সিটিং থেকে আপনার মত করে নোট লিখতে পারেন এখানে","সিটিং থেকে আপনার মত করে নোট লিখতে পারেন এখানে","off","https://doubariidealpublicschool.top","2025","2025-12-04T21:00","কৃতিত্ব অর্জনকারী শিক্ষার্থীদের জানাই উষ্ণ অভিনন্দন, এবং যারা এবার সফল হতে পারোনি, তাদের জন্য রইল নতুন উদ্যমে ঘুরে দাঁড়ানোর অদম্য প্রেরণা!","","");


-- Table structure for table `share_holder`
DROP TABLE IF EXISTS `share_holder`;
CREATE TABLE `share_holder` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `details` longtext NOT NULL,
  `create_date` varchar(250) NOT NULL,
  `total_amount` int(20) NOT NULL,
  `d_status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `share_holder`


-- Table structure for table `shift_system`
DROP TABLE IF EXISTS `shift_system`;
CREATE TABLE `shift_system` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shift_name` varchar(255) NOT NULL,
  `shift_name_bn` varchar(200) NOT NULL,
  `delete_status` enum('0','1') CHARACTER SET latin1 NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- Dumping data for table `shift_system`
INSERT INTO `shift_system` (`id`, `shift_name`, `shift_name_bn`, `delete_status`) VALUES("3","Morning","সকাল","0");
INSERT INTO `shift_system` (`id`, `shift_name`, `shift_name_bn`, `delete_status`) VALUES("5","Evening","বিকাল","0");


-- Table structure for table `sms`
DROP TABLE IF EXISTS `sms`;
CREATE TABLE `sms` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `status` int(10) NOT NULL DEFAULT 1,
  `type` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `sms`
INSERT INTO `sms` (`id`, `status`, `type`) VALUES("1","1","teacher");
INSERT INTO `sms` (`id`, `status`, `type`) VALUES("2","1","student");
INSERT INTO `sms` (`id`, `status`, `type`) VALUES("3","1","user");


-- Table structure for table `sms_api_v3`
DROP TABLE IF EXISTS `sms_api_v3`;
CREATE TABLE `sms_api_v3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `apiUrl` varchar(1000) NOT NULL,
  `apiKey` varchar(1000) NOT NULL,
  `authKey` varchar(1000) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `result_link` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `sms_api_v3`
INSERT INTO `sms_api_v3` (`id`, `apiUrl`, `apiKey`, `authKey`, `date`, `result_link`) VALUES("1","","","","2025-07-24 08:26:08","https://doubariidealpublicschool.top/sms/");


-- Table structure for table `sms_config`
DROP TABLE IF EXISTS `sms_config`;
CREATE TABLE `sms_config` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` varchar(250) DEFAULT NULL,
  `status` int(10) DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `sms_config`


-- Table structure for table `sms_deactive`
DROP TABLE IF EXISTS `sms_deactive`;
CREATE TABLE `sms_deactive` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(250) NOT NULL,
  `status` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `sms_deactive`
INSERT INTO `sms_deactive` (`id`, `type`, `status`) VALUES("1","teacher","0");
INSERT INTO `sms_deactive` (`id`, `type`, `status`) VALUES("2","student","1");
INSERT INTO `sms_deactive` (`id`, `type`, `status`) VALUES("3","staff","0");


-- Table structure for table `sms_error_log`
DROP TABLE IF EXISTS `sms_error_log`;
CREATE TABLE `sms_error_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `provider` varchar(50) NOT NULL,
  `mobile` varchar(20) NOT NULL,
  `message` text NOT NULL,
  `error_message` text DEFAULT NULL,
  `http_code` int(11) DEFAULT NULL,
  `api_response` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=620 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table `sms_error_log`
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("1","mram","01727316073","আপনার সন্তান কে বিদ্যালয়ে পাঠান","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1b105e92c7","2025-08-17 10:37:58");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("2","mram","01875344468","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর পক্ষ থেকে সবাই\nকে শুভেচ্ছা। আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1d140119ce","2025-08-17 12:55:28");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("3","mram","01727316073","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর পক্ষ থেকে সবাই\nকে শুভেচ্ছা। আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1d140dab71","2025-08-17 12:55:29");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("4","mram","01310906842","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর পক্ষ থেকে সবাই\nকে শুভেচ্ছা। আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1d141b38f9","2025-08-17 12:55:29");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("5","mram","01727316073","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর পক্ষ থেকে সবাই\nকে শুভেচ্ছা। আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1d1421241f","2025-08-17 12:55:30");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("6","mram","01330742203","আপনার সন্তানকে নিয়মিত বিদ্যালয় পাঠান। ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1da091a459","2025-08-17 13:32:57");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("7","mram","01779950102","আপনার সন্তানকে নিয়মিত বিদ্যালয় পাঠান। ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1da09e7fc9","2025-08-17 13:32:58");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("8","mram","01308652137","আপনার সন্তানকে নিয়মিত বিদ্যালয় পাঠান। ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1da0ac415a","2025-08-17 13:32:58");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("9","mram","01324984372","আপনার সন্তানকে নিয়মিত বিদ্যালয় পাঠান। ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1da0ca5f9e","2025-08-17 13:33:00");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("10","mram","01749926384","আপনার সন্তানকে নিয়মিত বিদ্যালয় পাঠান। ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1da0d822c3","2025-08-17 13:33:01");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("11","mram","01759828898","আপনার সন্তানকে নিয়মিত বিদ্যালয় পাঠান। ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1da0e70b44","2025-08-17 13:33:02");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("12","mram","01712095274","আপনার সন্তানকে নিয়মিত বিদ্যালয় পাঠান। ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1da701dbe2","2025-08-17 13:34:40");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("13","mram","01308652137","আপনার সন্তানকে নিয়মিত বিদ্যালয় পাঠান। ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1da70f12d7","2025-08-17 13:34:41");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("14","mram","01709259285","আপনার সন্তানকে নিয়মিত বিদ্যালয় পাঠান। ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1da721bb6e","2025-08-17 13:34:42");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("15","mram","01720825990","আপনার সন্তানকে নিয়মিত বিদ্যালয় পাঠান। ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1da7437a04","2025-08-17 13:34:44");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("16","mram","01727316073","আপনার সন্তানকে নিয়মিত বিদ্যালয় পাঠান। ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1da7514382","2025-08-17 13:34:45");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("17","mram","01739874783","আপনার সন্তানকে নিয়মিত বিদ্যালয় পাঠান। ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1da75e0ddb","2025-08-17 13:34:46");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("18","mram","01720648048","আপনার সন্তানকে নিয়মিত বিদ্যালয় পাঠান। ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1da7c34cf7","2025-08-17 13:34:52");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("19","mram","01308384045","আপনার সন্তানকে নিয়মিত বিদ্যালয় পাঠান। ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1da7d1d41c","2025-08-17 13:34:53");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("20","mram","01723366165","আপনার সন্তানকে নিয়মিত বিদ্যালয় পাঠান। ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1da7eaec2e","2025-08-17 13:34:54");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("21","mram","8801727316073","আসসালামু আলাইকুম  \nSAFAJANNAT TAHHIYA,Your username safa \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f7371c296","2025-08-17 15:37:27");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("22","mram","88০১৩০৪২৮০৯২০","আসসালামু আলাইকুম  \nNAJIFA JANNAT,Your username najifa \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:37:28");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("23","mram","88০১৭১৫১২৭৮০৭","আসসালামু আলাইকুম  \nMAHIA AKTER,Your username mahia \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:37:29");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("24","mram","88০১৭৮৩৩৫০৪৪৭৬","আসসালামু আলাইকুম  \nMINHAJUL ISLAM MAHIN,Your username minhaj \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:37:29");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("25","mram","88০১৭৭৬৩৮২২০৫","আসসালামু আলাইকুম  \nMD JAMIL AHMAD,Your username jamil \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:37:30");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("26","mram","88০১৭৭৭৩১২৪৫৫","আসসালামু আলাইকুম  \nMST FARHANA AKTER,Your username farhan \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:37:31");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("27","mram","8801712095274","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMAHADI HASAN ABIR,Your username mahadihasanabir414 \nPassword MAHA3656","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f79b6bf93","2025-08-17 15:39:07");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("28","mram","88০১৭২১২৩৭৮৪১","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nARAFATH RAHMAN PUSPO,Your username arafathrahmanpuspo301 \nPassword ARAF7675","HTTP Error","200","2001","2025-08-17 15:39:08");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("29","mram","88০১৭৬৬১৫৯৭৪০","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nANISUR RAHMAN,Your username anisurrahman728 \nPassword ANIS4205","HTTP Error","200","2001","2025-08-17 15:39:09");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("30","mram","88০১৭৬০০২২৬৪১","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMST HUMAIRA JANNAT,Your username msthumairajannat548 \nPassword MST 5944","HTTP Error","200","2001","2025-08-17 15:39:10");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("31","mram","88০১৭২৭৩১৬০৭৩","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nANISHA SIDDIQA NOWRIN,Your username anishasiddiqanowrin753 \nPassword ANIS5480","HTTP Error","200","2001","2025-08-17 15:39:10");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("32","mram","88০১৩০৮৩৮৪০৪৫","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMD ABU BOKOR TOWHID,Your username mdabubokor469 \nPassword MD A8842","HTTP Error","200","2001","2025-08-17 15:39:11");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("33","mram","8801308652137","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMD ASAD AHMED,Your username asad \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f7a00182d","2025-08-17 15:39:12");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("34","mram","8801709259285","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nKADEJA AKTER MONI,Your username kadejaaktermoni360 \nPassword KADE5807","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f7a0cd7bc","2025-08-17 15:39:12");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("35","mram","8801720825990","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nRUHAMA AKTER RUHI,Your username ruhama \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f7a1aa6e2","2025-08-17 15:39:13");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("36","mram","8801727316073","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nJUBEL AHMED,Your username jubel \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f7a294796","2025-08-17 15:39:14");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("37","mram","8801739874783","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nSURAIYA BEGUM,Your username suraiyabegum564 \nPassword SURA1626","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f7a370dae","2025-08-17 15:39:15");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("38","mram","8801720648048","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMST SUMAIYA BEGUM,Your username sumaiya \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f7a3ca6ea","2025-08-17 15:39:15");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("39","mram","8801308384045","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nAshag Sohag Sanjid,Your username ashagsohagsanjid781 \nPassword Asha5873","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f7a4a0561","2025-08-17 15:39:16");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("40","mram","8801723366165","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nSHAHANA SIDDIKA,Your username shahana \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f7a579184","2025-08-17 15:39:17");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("41","mram","88০১৩০৩৭০০২৬২","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nNUSRAT ISLAM NOWSIN,Your username nusrat \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:39:34");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("42","mram","88০১৭২৭৩১৬০৭৩","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMASKURA BEGUM,Your username maskurabegum317 \nPassword MASK2594","HTTP Error","200","2001","2025-08-17 15:39:34");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("43","mram","88০১৮৯৭৪১৮৯৩৯","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMD AHSHAN  ALAHI  RAFI,Your username mdahshanalahirafi359 \nPassword MD A2299","HTTP Error","200","2001","2025-08-17 15:39:51");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("44","mram","8801734080229","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMAHMUDUL HASAN HEMAL,Your username mahmudulhasanhemal549 \nPassword MAHM9066","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f7c7d0238","2025-08-17 15:39:51");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("45","mram","88০১৭৬৬১৫৯৭৪০","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nNUSRAT JAHAN MONI,Your username nusratjahanmoni457 \nPassword NUSR3993","HTTP Error","200","2001","2025-08-17 15:39:52");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("46","mram","88০১৭২৭৩১৬০৭৩","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nFERDOUS POPY,Your username ferdouspopy363 \nPassword FERD4795","HTTP Error","200","2001","2025-08-17 15:39:52");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("47","mram","8801330742203","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMD RAHAT ,Your username rahat \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f7d272de5","2025-08-17 15:40:02");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("48","mram","8801779950102","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nTAWFIQA JANNAT MUNTAHA,Your username tawfiqa \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f7d34a079","2025-08-17 15:40:03");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("49","mram","8801308652137","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMUNTAHA JANNAT TAKIYA,Your username muntaha \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f7d425b5c","2025-08-17 15:40:04");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("50","mram","8801324984372","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMD MAHDI HASAN,Your username mahdi \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f7d47c025","2025-08-17 15:40:04");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("51","mram","8801749926384","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nRAKIBUR HOSSAIN MAHI,Your username rakibur \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f7d4d41ea","2025-08-17 15:40:05");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("52","mram","8801759828898","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nKAMRAN AHMED,Your username kamran \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f7d5dcfe2","2025-08-17 15:40:06");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("53","mram","88০১৭১৯৪২৮৮৩৯","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nNAMIRA ISLAM MAHNUR,Your username namira \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:17");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("54","mram","88০১৩১৫৯৩৩৫২১","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMST SABRINA AKTER,Your username sabrina \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:18");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("55","mram","88০১৭৩০৯৫১৯২৩","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nAIMAN SADI,Your username aimansadi \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:18");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("56","mram","88০১৭২৭৩১৬০৭৩","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMD RUHAN AHMED,Your username ruhan \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:19");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("57","mram","88০১৭৫৬০৫৭১৩১","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nADYAN ALAMGIR ADNAN,Your username adyanalamgiradnan419 \nPassword ADYA8449","HTTP Error","200","2001","2025-08-17 15:40:20");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("58","mram","88০১৭৩৩৪৬৪১২০","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nNUSRAT JAHAN  TASNIM,Your username nusrat \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:21");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("59","mram","88০১৭১৬৫৯৬১৯৩","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nANSARUL ARIAN,Your username ansarul \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:21");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("60","mram","88০১৮৯৭৪১৮৯৩৯","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMD ANISUL HAQUE,Your username anisul \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:22");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("61","mram","88০১৭৭২০৩৯৮৯৮","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nSHOAIBUR RAHMAN,Your username shoaiburrahman131 \nPassword SHOA8957","HTTP Error","200","2001","2025-08-17 15:40:23");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("62","mram","88০১৭৩৯৮৭৮৩","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMST AYSHA AKTER,Your username aysha \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:24");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("63","mram","88০১৭২৭৩১৬০৭৩","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nABDUR RAHMAN,Your username abdur \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:25");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("64","mram","88০১৩০৯৭২৬৯৫২","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMOSTAKIM AHMAD,Your username mostak \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:25");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("65","mram","88০১৩০৪২৮৫৭০৪","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nSHRESTHA DAS,Your username shrestha \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:26");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("66","mram","88০১৭২৭৩১৬০৭৩","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMAHDI HASAN,Your username mahdi \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:40");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("67","mram","88০১৭৮১৫৮২৮৭১","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nANISA BEGUM,Your username anisa \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:41");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("68","mram","88০১৩২২১৯১৮৯১","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nABU SAYAD,Your username abusayad \nPassword 1245","HTTP Error","200","2001","2025-08-17 15:40:42");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("69","mram","88০১৭৯৬৮০৬১৩৭","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMD HABIBUR RAHMAN,Your username habibur \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:42");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("70","mram","8801875344468","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMST MONIRA SIDDIKA MIM,Your username monira \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f7fb34cd1","2025-08-17 15:40:43");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("71","mram","88০১৭১৫৫৭৩৭০৮","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nADIL AHMED,Your username adil \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:43");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("72","mram","88০১৭৪১৩৭৬৩২৯","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMD ROBIUL HASAN,Your username robiul \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:44");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("73","mram","88০১৩৩০৩০৩৬০০","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nRAKIBUL HASAN,Your username rakibul \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:45");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("74","mram","88০১৭৪৩৯৫৪৪৬৭","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nSAKIB AHMED,Your username sakib \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:45");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("75","mram","88০১৭৮৪২৫১২৭৪","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMST ISRAT JAHAN JIM,Your username ISRAT \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:46");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("76","mram","88০১৭০৬৬১১৮০২","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nNADIA FERDAUS HAPPY,Your username nadia \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:47");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("77","mram","88০১৭১২০৯৫২৭৪","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nANAS,Your username anas \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:47");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("78","mram","88০১৭২৩১০৪৩৯৫","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMD SAHIDUR RAHMAN HADI,Your username hadi \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:48");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("79","mram","8801727316073","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nNUSHRAT JANNAT LIMA,Your username nushrat \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f800ec0c4","2025-08-17 15:40:49");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("80","mram","88০১৭২৭৩১৬০৭৩","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nISRAT JANNAT SUMANA ,Your username isratjannat \nPassword ISRA1315","HTTP Error","200","2001","2025-08-17 15:40:49");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("81","mram","88০১৭২৭৩১৬০৭৩","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nRUMA BEGUM,Your username ruma \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:50");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("82","mram","88০১৭৬০০২২৬৪১","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMST TAHSINA JANNAT NISA,Your username tahsina \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:51");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("83","mram","88০১৭৪৩৯২০৩৬২","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMD MASUD AHMED,Your username masud \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:51");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("84","mram","88০১৭১৩৮০৪৮৫৩","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMD . MIZANUR RAHMAN,Your username mizan \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:52");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("85","mram","88০১৭৬১৭৩৬৪২৬","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nAFFAN MUAZ,Your username affan \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:53");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("86","mram","88০১৭৫৯৯৩৪৮৪০","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMST MUNTAHA JANNAT  MIM,Your username muntaha \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:53");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("87","mram","88০১৩০৮৪৬১৮১৭","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nTAWHIDUL ISLAM IBRAHIM,Your username tawhi \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:54");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("88","mram","88০১৭৫৯৮৫৩৩১৭","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nFAIZA JANNAT NAZIHA,Your username faiza \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:55");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("89","mram","88০১৭৩৯৮৭৪৭৮৩","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nRABEYA BOSORI,Your username rabeya \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:56");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("90","mram","88০১৭৫২৫০৬৯৫৬","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMAHBUBA JANNAT FAHIM,Your username mahbubajannat \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:56");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("91","mram","88০১৭২৯২৪০৪২৯","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nFAZLE FARIN RAISHA,Your username fazle \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:57");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("92","mram","88০১৭২৭৩১৬০৭৩","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMD ABDUR BADIR,Your username abdur \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:40:58");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("93","mram","8801310906842","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMST  RAHIMA BEGUM,Your username mstrahimabegum379 \nPassword MST 3493","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f80df0b7d","2025-08-17 15:41:02");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("94","mram","88০১৭২৩৯২৫৮৭১","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nAL RAJIB,Your username alrajib \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:41:02");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("95","mram","88০১৭২৭৩১৬০৭৩","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nHUJAIFA AL TAMHID,Your username hujaifaaltamhid776 \nPassword HUJA6324","HTTP Error","200","2001","2025-08-17 15:41:02");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("96","mram","88০১৭০৯৯৪৯৫১৭","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nFARIHA JANNAT FAUZIA,Your username farihajannatfauzia121 \nPassword FARI8330","HTTP Error","200","2001","2025-08-17 15:41:03");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("97","mram","88০১৩০৯২৫৮৯৪৮","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nTANISA AKTER,Your username tanisa \nPassword 12345","HTTP Error","200","2001","2025-08-17 15:41:04");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("98","mram","8801727316073","আসসালামু আলাইকুম, ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nkamal,Your username kamal \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f8113e00b","2025-08-17 15:41:05");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("99","mram","8801822055791","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল \nYour userid 69\nPassword 539196","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f8ebbade4","2025-08-17 15:44:43");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("100","mram","8801327047732","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল \nYour userid 73\nPassword 312345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f8ec9addd","2025-08-17 15:44:44");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("101","mram","8801304285704","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল \nYour userid 74\nPassword 387872","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f8ed7ea11","2025-08-17 15:44:45");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("102","mram","8801763528453","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল \nYour userid 75\nPassword 940117","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f8ee56e26","2025-08-17 15:44:46");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("103","mram","8801709304015","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল \nYour userid 76\nPassword 397467","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f8ef3325c","2025-08-17 15:44:47");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("104","mram","8801774870651","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল \nYour userid 77\nPassword 927977","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a1f8f012047","2025-08-17 15:44:48");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("105","mram","01882167068","এখানে কাষ্টম এসএমএস লিখতে পারবেনYour User ID: 78  Password : .193565","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a9883f5c9e3","2025-08-23 09:22:07");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("106","mram","8801882167068","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল \nYour userid 78\nPassword 193565","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a988dc94021","2025-08-23 09:24:44");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("107","mram","8801822055791","আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান। ডৌবাড়ী আইডিয়াল পাবলিক স্কুল \nYour userid 69\nPassword 539196","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a989c5917d8","2025-08-23 09:28:37");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("108","mram","8801327047732","আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান। ডৌবাড়ী আইডিয়াল পাবলিক স্কুল \nYour userid 73\nPassword 312345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a989c6665a5","2025-08-23 09:28:38");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("109","mram","8801304285704","আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান। ডৌবাড়ী আইডিয়াল পাবলিক স্কুল \nYour userid 74\nPassword 387872","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a989c7406b5","2025-08-23 09:28:39");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("110","mram","8801763528453","আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান। ডৌবাড়ী আইডিয়াল পাবলিক স্কুল \nYour userid 75\nPassword 940117","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a989c816787","2025-08-23 09:28:40");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("111","mram","8801709304015","আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান। ডৌবাড়ী আইডিয়াল পাবলিক স্কুল \nYour userid 76\nPassword 397467","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a989c8e7138","2025-08-23 09:28:41");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("112","mram","8801774870651","আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান। ডৌবাড়ী আইডিয়াল পাবলিক স্কুল \nYour userid 77\nPassword 927977","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a989c9bad64","2025-08-23 09:28:41");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("113","mram","8801882167068","আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান। ডৌবাড়ী আইডিয়াল পাবলিক স্কুল \nYour userid 78\nPassword 193565","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168a989cd2d2cb","2025-08-23 09:28:45");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("114","mram","01727316073","সম্মানিত অভিভাবক শিক্ষার্থীর নাম: SAFAJANNAT TAHHIYA, শিক্ষার্থীর আইডি: ২ , অপরিশোধিত টাকা: ৫,৫০০","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168adc752e6dd4","2025-08-26 14:40:19");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("115","mram","01727316073","Annual Examination 2025, সাফা জান্নাত তাহহিয়া , আইডি: ২, ক্লাস: দ্বিতীয়, জিপিএ : ৪.৭ পেয়েছো, মোট নাম্বার: ৪৩৪, সর্বোচ্চ নাম্বার : ৪৩৪।, মেরিট পজিশন: ১।  ডৌবাড়ী আইডিয়াল পাবলিক স্কুল ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168add13a47775","2025-08-26 15:22:34");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("116","mram","88০১৭১৯৪২৮৮৩৯","আপনার সন্তানকে বিদ্যালয় পাঠান \nNAMIRA ISLAM MAHNUR,Your username namira \nPassword 12345","HTTP Error","200","2001","2025-08-29 17:12:23");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("117","mram","8801789518435","আপনার সন্তানকে বিদ্যালয় পাঠান \nMST SABRINA AKTER,Your username sabrina \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168b1df78b32a3","2025-08-29 17:12:25");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("118","mram","88০১৭৩০৯৫১৯২৩","আপনার সন্তানকে বিদ্যালয় পাঠান \nAIMAN SADI,Your username aimansadi \nPassword 12345","HTTP Error","200","2001","2025-08-29 17:12:26");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("119","mram","88০১৭২৭৩১৬০৭৩","আপনার সন্তানকে বিদ্যালয় পাঠান \nMD RUHAN AHMED,Your username ruhan \nPassword 12345","HTTP Error","200","2001","2025-08-29 17:12:26");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("120","mram","88০১৭৫৬০৫৭১৩১","আপনার সন্তানকে বিদ্যালয় পাঠান \nADYAN ALAMGIR ADNAN,Your username adyanalamgiradnan419 \nPassword ADYA8449","HTTP Error","200","2001","2025-08-29 17:12:27");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("121","mram","88০১৭১৬৫৯৬১৯৩","আপনার সন্তানকে বিদ্যালয় পাঠান \nANSARUL ARIAN,Your username ansarul \nPassword 12345","HTTP Error","200","2001","2025-08-29 17:12:29");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("122","mram","88০১৮৯৭৪১৮৯৩৯","আপনার সন্তানকে বিদ্যালয় পাঠান \nMD ANISUL HAQUE,Your username anisul \nPassword 12345","HTTP Error","200","2001","2025-08-29 17:12:30");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("123","mram","88০১৭৭২০৩৯৮৯৮","আপনার সন্তানকে বিদ্যালয় পাঠান \nSHOAIBUR RAHMAN,Your username shoaiburrahman131 \nPassword SHOA8957","HTTP Error","200","2001","2025-08-29 17:12:31");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("124","mram","88০১৭৩৯৮৭৮৩","আপনার সন্তানকে বিদ্যালয় পাঠান \nMST AYSHA AKTER,Your username aysha \nPassword 12345","HTTP Error","200","2001","2025-08-29 17:12:32");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("125","mram","88০১৭২৭৩১৬০৭৩","আপনার সন্তানকে বিদ্যালয় পাঠান \nABDUR RAHMAN,Your username abdur \nPassword 12345","HTTP Error","200","2001","2025-08-29 17:12:33");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("126","mram","88০১৩০৯৭২৬৯৫২","আপনার সন্তানকে বিদ্যালয় পাঠান \nMOSTAKIM AHMAD,Your username mostak \nPassword 12345","HTTP Error","200","2001","2025-08-29 17:12:35");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("127","mram","88০১৩০৪২৮৫৭০৪","আপনার সন্তানকে বিদ্যালয় পাঠান \nSHRESTHA DAS,Your username shrestha \nPassword 12345","HTTP Error","200","2001","2025-08-29 17:12:35");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("128","mram","8801779950102","আপনার সন্তানকে বিদ্যালয়ে পাঠান \nTAWFIQA JANNAT MUNTAHA,Your username tawfiqa \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbcf68c3b76","2025-09-06 06:06:32");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("129","mram","8801308652137","আপনার সন্তানকে বিদ্যালয়ে পাঠান \nMUNTAHA JANNAT TAKIYA,Your username muntaha \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbcf69906e6","2025-09-06 06:06:33");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("130","mram","8801324984372","আপনার সন্তানকে বিদ্যালয়ে পাঠান \nMD MAHDI HASAN,Your username mahdi \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbcf6a71c6e","2025-09-06 06:06:34");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("131","mram","8801749926384","আপনার সন্তানকে বিদ্যালয়ে পাঠান \nRAKIBUR HOSSAIN MAHI,Your username rakibur \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbcf6b43c14","2025-09-06 06:06:35");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("132","mram","8801759828898","আপনার সন্তানকে বিদ্যালয়ে পাঠান \nKAMRAN AHMED,Your username kamran \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbcf6b9d915","2025-09-06 06:06:35");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("133","mram","8801779950102","আপনার সন্তানকে বিদ্যালয় পাঠান \nTAWFIQA JANNAT MUNTAHA,Your username tawfiqa \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbd0da54aa8","2025-09-06 06:12:42");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("134","mram","8801308652137","আপনার সন্তানকে বিদ্যালয় পাঠান \nMUNTAHA JANNAT TAKIYA,Your username muntaha \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbd0db305b4","2025-09-06 06:12:43");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("135","mram","8801324984372","আপনার সন্তানকে বিদ্যালয় পাঠান \nMD MAHDI HASAN,Your username mahdi \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbd0dc066ef","2025-09-06 06:12:44");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("136","mram","8801749926384","আপনার সন্তানকে বিদ্যালয় পাঠান \nRAKIBUR HOSSAIN MAHI,Your username rakibur \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbd0dc5ac20","2025-09-06 06:12:44");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("137","mram","8801759828898","আপনার সন্তানকে বিদ্যালয় পাঠান \nKAMRAN AHMED,Your username kamran \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbd0dcad281","2025-09-06 06:12:44");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("138","mram","01727316073"," Abdullah ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbd4cef07f2","2025-09-06 06:29:35");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("139","mram","8801779950102","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nTAWFIQA JANNAT MUNTAHA,Your username tawfiqa \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbd51ac1ba4","2025-09-06 06:30:50");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("140","mram","8801308652137","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMUNTAHA JANNAT TAKIYA,Your username muntaha \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbd51b922d5","2025-09-06 06:30:51");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("141","mram","8801324984372","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nMD MAHDI HASAN,Your username mahdi \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbd51c5cca7","2025-09-06 06:30:52");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("142","mram","8801749926384","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nRAKIBUR HOSSAIN MAHI,Your username rakibur \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbd51d3323f","2025-09-06 06:30:53");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("143","mram","8801759828898","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  \nKAMRAN AHMED,Your username kamran \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbd51e02545","2025-09-06 06:30:54");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("144","mram","01309814905","আপনার সন্তানকে বিদ্যালয়ে পাঠান","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbe0ccc069b","2025-09-06 07:20:44");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("145","mram","8801779950102","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল \nTAWFIQA JANNAT MUNTAHA,Your username tawfiqa \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbe1873dd94","2025-09-06 07:23:51");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("146","mram","8801308652137","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল \nMUNTAHA JANNAT TAKIYA,Your username muntaha \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbe1878fef0","2025-09-06 07:23:51");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("147","mram","8801324984372","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল \nMD MAHDI HASAN,Your username mahdi \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbe18862254","2025-09-06 07:23:52");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("148","mram","8801749926384","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল \nRAKIBUR HOSSAIN MAHI,Your username rakibur \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbe1893c71c","2025-09-06 07:23:53");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("149","mram","8801759828898","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল \nKAMRAN AHMED,Your username kamran \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbe1898c834","2025-09-06 07:23:53");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("150","mram","01309814905","Your admission success\nUser ID :  59A101ZE \nPass :  259787  \nDownload admission form https://doubariidealpublicschool.top/sms/online-admission/download-admission-form.php \nDoubari Ideal public school","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbe2f160143","2025-09-06 07:29:53");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("151","mram","01309814905","Dear  MD RAHAT ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252031","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbe7b597802","2025-09-06 07:50:13");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("152","mram","8801309814905","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল \nMD RAHAT,Your username mdrahat593 \nPassword MD R6022","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168bbe81203b7b","2025-09-06 07:51:46");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("153","mram","01727316073","Your admission success\nUser ID :  57A103ZE \nPass :  596596  \nDownload admission form https://doubariidealpublicschool.top/sms/online-admission/download-admission-form.php \nDoubari Ideal public school","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168c79ce593bd6","2025-09-15 04:58:13");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("154","mram","01727316073","Dear  jubilee ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252053","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168c7a0970a67c","2025-09-15 05:13:59");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("155","mram","01756495492","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান\n","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38de727618","2025-10-06 09:37:43");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("156","mram","01734080229","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান\n","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38de77c44f","2025-10-06 09:37:43");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("157","mram","01711911237","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান\n","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38de844ffb","2025-10-06 09:37:44");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("158","mram","01717452764","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e773c91e","2025-10-06 09:40:07");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("159","mram","01781582871","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e780d5c0","2025-10-06 09:40:08");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("160","mram","01322191891","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e78d59e5","2025-10-06 09:40:09");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("161","mram","01796806137","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e7933e62","2025-10-06 09:40:09");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("162","mram","01875344468","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e79f0f9a","2025-10-06 09:40:10");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("163","mram","01715573708","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e7ac08ae","2025-10-06 09:40:10");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("164","mram","01741376329","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e7b1f3a2","2025-10-06 09:40:11");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("165","mram","01330303600","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e7e8a9b9","2025-10-06 09:40:14");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("166","mram","01743954467","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e7eec9a2","2025-10-06 09:40:15");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("167","mram","01784251274","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e7f4b4f5","2025-10-06 09:40:15");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("168","mram","01706611802","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e7f9d6be","2025-10-06 09:40:15");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("169","mram","01712095274","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e8069870","2025-10-06 09:40:16");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("170","mram","01723104395","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e80b994c","2025-10-06 09:40:16");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("171","mram","01727316073","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e81197e5","2025-10-06 09:40:17");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("172","mram","01760022641","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e816a177","2025-10-06 09:40:17");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("173","mram","01743920362","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e81bb6f7","2025-10-06 09:40:17");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("174","mram","01713804853","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e8218666","2025-10-06 09:40:18");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("175","mram","01761736426","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e826971b","2025-10-06 09:40:18");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("176","mram","01759934840","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e85c3ec5","2025-10-06 09:40:21");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("177","mram","01308461817","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e8624afd","2025-10-06 09:40:22");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("178","mram","01759853317","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e86773aa","2025-10-06 09:40:22");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("179","mram","01739874783","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e86ca4e7","2025-10-06 09:40:22");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("180","mram","01752506956","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e872ac3d","2025-10-06 09:40:23");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("181","mram","01729240429","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e877bedc","2025-10-06 09:40:23");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("182","mram","01310906842","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e87cd3bd","2025-10-06 09:40:23");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("183","mram","01723925871","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e882983d","2025-10-06 09:40:24");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("184","mram","01727316073","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e88807dd","2025-10-06 09:40:24");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("185","mram","01709949517","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e88d58f5","2025-10-06 09:40:25");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("186","mram","01309258948","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e8936d4d","2025-10-06 09:40:25");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("187","mram","01727316073","আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38e8991eb0","2025-10-06 09:40:25");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("188","mram","01717452764","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38ee75d94c","2025-10-06 09:41:59");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("189","mram","01781582871","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38ee8363ed","2025-10-06 09:42:00");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("190","mram","01322191891","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38ee88c06c","2025-10-06 09:42:00");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("191","mram","01796806137","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38ee9561e4","2025-10-06 09:42:01");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("192","mram","01875344468","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38ee9aa4e4","2025-10-06 09:42:01");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("193","mram","01715573708","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38eea06ee7","2025-10-06 09:42:02");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("194","mram","01741376329","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38eea58337","2025-10-06 09:42:02");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("195","mram","01330303600","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38eeaa9f77","2025-10-06 09:42:02");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("196","mram","01743954467","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38eeb0571a","2025-10-06 09:42:03");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("197","mram","01784251274","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38eeb5c046","2025-10-06 09:42:03");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("198","mram","01706611802","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38eebb1489","2025-10-06 09:42:03");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("199","mram","01712095274","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38eec0fd80","2025-10-06 09:42:04");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("200","mram","01723104395","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38eecd489c","2025-10-06 09:42:05");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("201","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38eed34883","2025-10-06 09:42:05");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("202","mram","01760022641","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38eed83e0f","2025-10-06 09:42:05");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("203","mram","01743920362","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38eedd38b4","2025-10-06 09:42:05");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("204","mram","01713804853","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38eee3086f","2025-10-06 09:42:06");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("205","mram","01761736426","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38eee810e5","2025-10-06 09:42:06");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("206","mram","01759934840","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38eeed3e43","2025-10-06 09:42:07");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("207","mram","01308461817","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38eef34144","2025-10-06 09:42:07");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("208","mram","01759853317","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38eef8505a","2025-10-06 09:42:07");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("209","mram","01739874783","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38eefd51de","2025-10-06 09:42:08");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("210","mram","01752506956","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38ef0427c8","2025-10-06 09:42:08");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("211","mram","01729240429","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38ef097747","2025-10-06 09:42:08");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("212","mram","01310906842","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38ef0e689d","2025-10-06 09:42:09");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("213","mram","01723925871","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38ef13fadd","2025-10-06 09:42:09");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("214","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38ef1987fa","2025-10-06 09:42:09");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("215","mram","01709949517","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38ef1e97f2","2025-10-06 09:42:10");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("216","mram","01309258948","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38ef245463","2025-10-06 09:42:10");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("217","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38ef297b5f","2025-10-06 09:42:10");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("218","mram","01789518435","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38f3c3dbb2","2025-10-06 09:43:24");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("219","mram","01730951923","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38f3c8da6f","2025-10-06 09:43:24");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("220","mram","01756057131","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38f3ce20d3","2025-10-06 09:43:25");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("221","mram","01771849796","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38f3d3d847","2025-10-06 09:43:25");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("222","mram","01716596193","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38f3d8f5b7","2025-10-06 09:43:25");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("223","mram","01897418939","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38f3de1db0","2025-10-06 09:43:26");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("224","mram","01772039898","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38f3e3d7a8","2025-10-06 09:43:26");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("225","mram","01309726952","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38f3e8d88a","2025-10-06 09:43:26");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("226","mram","01304285704","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। মাসিক বেতন পরিশোধ করুন। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38f3edf10a","2025-10-06 09:43:27");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("227","mram","01789518435","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38f79213b3","2025-10-06 09:44:25");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("228","mram","01730951923","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38f79dac70","2025-10-06 09:44:26");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("229","mram","01756057131","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38f7a375f3","2025-10-06 09:44:26");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("230","mram","01771849796","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38f7a86045","2025-10-06 09:44:26");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("231","mram","01716596193","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38f7ad4257","2025-10-06 09:44:26");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("232","mram","01897418939","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38f7b2e121","2025-10-06 09:44:27");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("233","mram","01772039898","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38f7be614a","2025-10-06 09:44:28");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("234","mram","01309726952","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38f7cbaee4","2025-10-06 09:44:28");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("235","mram","01304285704","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e38f7d829b3","2025-10-06 09:44:29");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("236","mram","01712095274","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। সন্তানের পড়ালেখার খোজ নিন। মাসিক বেতন পরিশোধ করুন। \n","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e390229bde9","2025-10-06 09:47:14");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("237","mram","01308652137","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। সন্তানের পড়ালেখার খোজ নিন। মাসিক বেতন পরিশোধ করুন। \n","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e3902372d9b","2025-10-06 09:47:15");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("238","mram","01709259285","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। সন্তানের পড়ালেখার খোজ নিন। মাসিক বেতন পরিশোধ করুন। \n","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e390243ee3d","2025-10-06 09:47:16");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("239","mram","01720825990","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। সন্তানের পড়ালেখার খোজ নিন। মাসিক বেতন পরিশোধ করুন। \n","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e390249075b","2025-10-06 09:47:16");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("240","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। সন্তানের পড়ালেখার খোজ নিন। মাসিক বেতন পরিশোধ করুন। \n","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e39024e25c3","2025-10-06 09:47:17");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("241","mram","01739874783","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। সন্তানের পড়ালেখার খোজ নিন। মাসিক বেতন পরিশোধ করুন। \n","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e390254034a","2025-10-06 09:47:17");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("242","mram","01720648048","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। সন্তানের পড়ালেখার খোজ নিন। মাসিক বেতন পরিশোধ করুন। \n","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e3902590c3d","2025-10-06 09:47:17");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("243","mram","01308384045","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। সন্তানের পড়ালেখার খোজ নিন। মাসিক বেতন পরিশোধ করুন। \n","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e3902658c80","2025-10-06 09:47:18");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("244","mram","01723366165","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। সন্তানের পড়ালেখার খোজ নিন। মাসিক বেতন পরিশোধ করুন। \n","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e39026a67af","2025-10-06 09:47:18");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("245","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। আপনার সন্তান কে নিয়মিত বিদ্যালয় পাঠান। সন্তানের পড়ালেখার খোজ নিন। মাসিক বেতন পরিশোধ করুন। \n","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e390277747a","2025-10-06 09:47:19");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("246","mram","01712095274","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আসসালামু আলাইকুম,  আগামীকাল  সকাল শিফট  বন্ধ থাকিবে। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e67a3ef40b5","2025-10-08 14:50:39");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("247","mram","01308652137","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আসসালামু আলাইকুম,  আগামীকাল  সকাল শিফট  বন্ধ থাকিবে। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e67a3fc2f74","2025-10-08 14:50:39");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("248","mram","01709259285","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আসসালামু আলাইকুম,  আগামীকাল  সকাল শিফট  বন্ধ থাকিবে। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e67a4020d96","2025-10-08 14:50:40");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("249","mram","01720825990","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আসসালামু আলাইকুম,  আগামীকাল  সকাল শিফট  বন্ধ থাকিবে। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e67a4071b4d","2025-10-08 14:50:40");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("250","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আসসালামু আলাইকুম,  আগামীকাল  সকাল শিফট  বন্ধ থাকিবে। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e67a413d745","2025-10-08 14:50:41");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("251","mram","01739874783","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আসসালামু আলাইকুম,  আগামীকাল  সকাল শিফট  বন্ধ থাকিবে। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e67a42179f9","2025-10-08 14:50:42");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("252","mram","01720648048","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আসসালামু আলাইকুম,  আগামীকাল  সকাল শিফট  বন্ধ থাকিবে। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e67a4267a09","2025-10-08 14:50:42");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("253","mram","01308384045","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আসসালামু আলাইকুম,  আগামীকাল  সকাল শিফট  বন্ধ থাকিবে। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e67a433e1db","2025-10-08 14:50:43");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("254","mram","01723366165","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আসসালামু আলাইকুম,  আগামীকাল  সকাল শিফট  বন্ধ থাকিবে। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e67a44644f4","2025-10-08 14:50:44");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("255","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আসসালামু আলাইকুম,  আগামীকাল  সকাল শিফট  বন্ধ থাকিবে। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e67a44b51dc","2025-10-08 14:50:44");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("256","mram","01756495492","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আসসালামু আলাইকুম,  আগামীকাল  সকাল শিফট  বন্ধ থাকিবে। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e67a7bbf80f","2025-10-08 14:51:39");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("257","mram","01734080229","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আসসালামু আলাইকুম,  আগামীকাল  সকাল শিফট  বন্ধ থাকিবে। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e67a7c9b836","2025-10-08 14:51:40");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("258","mram","01711911237","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আসসালামু আলাইকুম,  আগামীকাল  সকাল শিফট  বন্ধ থাকিবে। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168e67a7dd15a5","2025-10-08 14:51:41");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("259","mram","01717452764","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32596b5a5","2025-10-15 05:34:17");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("260","mram","01781582871","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef325a35715","2025-10-15 05:34:18");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("261","mram","01322191891","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef325af0baa","2025-10-15 05:34:19");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("262","mram","01796806137","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef325bc4c0a","2025-10-15 05:34:19");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("263","mram","01875344468","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef325c8bdda","2025-10-15 05:34:20");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("264","mram","01715573708","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef325cdbb3c","2025-10-15 05:34:21");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("265","mram","01741376329","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef325d3e8f1","2025-10-15 05:34:21");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("266","mram","01330303600","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef325d89431","2025-10-15 05:34:21");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("267","mram","01743954467","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef325e51b0c","2025-10-15 05:34:22");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("268","mram","01784251274","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef325f16dd8","2025-10-15 05:34:23");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("269","mram","01706611802","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef325fdb863","2025-10-15 05:34:24");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("270","mram","01712095274","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef3260aa3f4","2025-10-15 05:34:24");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("271","mram","01723104395","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef326107775","2025-10-15 05:34:25");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("272","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef3261ca77e","2025-10-15 05:34:25");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("273","mram","01760022641","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef3262250b1","2025-10-15 05:34:26");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("274","mram","01743920362","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef3262732a8","2025-10-15 05:34:26");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("275","mram","01713804853","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef3262c0069","2025-10-15 05:34:26");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("276","mram","01761736426","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32631c232","2025-10-15 05:34:27");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("277","mram","01759934840","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32636adea","2025-10-15 05:34:27");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("278","mram","01308461817","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef3263bc51a","2025-10-15 05:34:27");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("279","mram","01759853317","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef326413cf6","2025-10-15 05:34:28");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("280","mram","01739874783","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef326462a85","2025-10-15 05:34:28");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("281","mram","01752506956","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef3264b1890","2025-10-15 05:34:28");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("282","mram","01729240429","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32650a3d4","2025-10-15 05:34:29");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("283","mram","01310906842","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32655ee31","2025-10-15 05:34:29");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("284","mram","01723925871","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef3265aa63d","2025-10-15 05:34:29");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("285","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32660b3e7","2025-10-15 05:34:30");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("286","mram","01709949517","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef3266565e5","2025-10-15 05:34:30");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("287","mram","01309258948","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef3266a2a9d","2025-10-15 05:34:30");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("288","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef3266ee04a","2025-10-15 05:34:31");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("289","mram","01789518435","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32cf5d346","2025-10-15 05:36:15");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("290","mram","01730951923","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32cfad027","2025-10-15 05:36:15");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("291","mram","01756057131","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32d003e5f","2025-10-15 05:36:16");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("292","mram","01771849796","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32d050d7f","2025-10-15 05:36:16");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("293","mram","01716596193","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32d0a0511","2025-10-15 05:36:16");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("294","mram","01897418939","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32d0f07dc","2025-10-15 05:36:17");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("295","mram","01772039898","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32d14e130","2025-10-15 05:36:17");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("296","mram","01309726952","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32d19d24e","2025-10-15 05:36:17");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("297","mram","01304285704","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32d26d5cf","2025-10-15 05:36:18");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("298","mram","01779950102","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32e89c691","2025-10-15 05:36:40");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("299","mram","01308652137","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32e9666f2","2025-10-15 05:36:41");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("300","mram","01324984372","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32e9b52c6","2025-10-15 05:36:41");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("301","mram","01749926384","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32ea7c0eb","2025-10-15 05:36:42");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("302","mram","01759828898","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32eac8ff5","2025-10-15 05:36:42");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("303","mram","01309814905","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32eb284da","2025-10-15 05:36:43");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("304","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32fd30d43","2025-10-15 05:37:01");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("305","mram","01304280920","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32fd7e8d2","2025-10-15 05:37:01");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("306","mram","01715127807","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32fdc9e75","2025-10-15 05:37:01");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("307","mram","01776382205","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32fe21156","2025-10-15 05:37:02");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("308","mram","01777312455","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef32fee1eb6","2025-10-15 05:37:03");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("309","mram","01712095274","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef3311a4713","2025-10-15 05:37:21");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("310","mram","01308652137","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef331200187","2025-10-15 05:37:22");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("311","mram","01709259285","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef33124d9f0","2025-10-15 05:37:22");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("312","mram","01720825990","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef3316c16e3","2025-10-15 05:37:26");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("313","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef33171f4c0","2025-10-15 05:37:27");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("314","mram","01739874783","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef33176f462","2025-10-15 05:37:27");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("315","mram","01720648048","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef3317bda26","2025-10-15 05:37:27");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("316","mram","01308384045","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef331816fbc","2025-10-15 05:37:28");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("317","mram","01723366165","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef331865e3e","2025-10-15 05:37:28");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("318","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef3318b44b6","2025-10-15 05:37:28");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("319","mram","01756495492","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef33368307c","2025-10-15 05:37:58");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("320","mram","01734080229","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef3336cd2ff","2025-10-15 05:37:58");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("321","mram","01711911237","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল। সম্মানিত অভিভাবক বৃন্দ আগামী কাল টাইফয়েড টিকা দেওয়া হবে । সকল শিক্ষার্থী ওঅভিভাবক  উপস্থিত থাকার জন্য অনুরোধ  করা হলো ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233168ef333726286","2025-10-15 05:37:59");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("322","mram","01727316073","Dear  ass ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20251001","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039bfed1028","2025-10-30 17:10:23");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("323","mram","01717452764","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e679a774","2025-10-30 17:20:39");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("324","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e687c107","2025-10-30 17:20:40");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("325","mram","01781582871","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e695d51e","2025-10-30 17:20:41");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("326","mram","01322191891","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e69b581b","2025-10-30 17:20:41");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("327","mram","01796806137","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e6a1b869","2025-10-30 17:20:42");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("328","mram","01875344468","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e6b01644","2025-10-30 17:20:43");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("329","mram","01715573708","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e6c75996","2025-10-30 17:20:44");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("330","mram","01741376329","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e6d1b8d4","2025-10-30 17:20:45");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("331","mram","01330303600","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e6d7a30e","2025-10-30 17:20:45");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("332","mram","01743954467","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e6dd1a53","2025-10-30 17:20:46");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("333","mram","01784251274","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e6ebbbca","2025-10-30 17:20:47");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("334","mram","01706611802","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e6f5fcaa","2025-10-30 17:20:47");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("335","mram","01712095274","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e6fb9198","2025-10-30 17:20:47");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("336","mram","01723104395","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e733718b","2025-10-30 17:20:51");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("337","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e7449a6f","2025-10-30 17:20:52");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("338","mram","01760022641","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e74a08ae","2025-10-30 17:20:52");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("339","mram","01743920362","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e7506370","2025-10-30 17:20:53");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("340","mram","01713804853","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e755d37b","2025-10-30 17:20:53");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("341","mram","01761736426","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e75b4f6f","2025-10-30 17:20:54");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("342","mram","01759934840","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e76dd079","2025-10-30 17:20:55");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("343","mram","01308461817","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e773f695","2025-10-30 17:20:55");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("344","mram","01759853317","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e77972c6","2025-10-30 17:20:57");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("345","mram","01739874783","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e796357b","2025-10-30 17:20:57");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("346","mram","01752506956","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e79bc35b","2025-10-30 17:20:57");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("347","mram","01729240429","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e7a1c0b4","2025-10-30 17:20:58");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("348","mram","01310906842","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e7ab07be","2025-10-30 17:20:58");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("349","mram","01723925871","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e7b158dc","2025-10-30 17:21:00");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("350","mram","01304280920","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e7c57544","2025-10-30 17:21:00");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("351","mram","01715127807","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e7cece30","2025-10-30 17:21:01");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("352","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e7d4ff6a","2025-10-30 17:21:01");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("353","mram","01709949517","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e7de7550","2025-10-30 17:21:04");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("354","mram","01309258948","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e804eba5","2025-10-30 17:21:05");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("355","mram","01776382205","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e8163d7f","2025-10-30 17:21:05");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("356","mram","01777312455","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e8442008","2025-10-30 17:21:08");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("357","mram","01756495492","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e849980b","2025-10-30 17:21:08");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("358","mram","01734080229","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e84f2f5d","2025-10-30 17:21:09");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("359","mram","01711911237","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e8556634","2025-10-30 17:21:09");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("360","mram","01789518435","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e85cabc5","2025-10-30 17:21:10");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("361","mram","01730951923","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e866f496","2025-10-30 17:21:10");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("362","mram","01756057131","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e86cb181","2025-10-30 17:21:11");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("363","mram","01771849796","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e876e9d6","2025-10-30 17:21:11");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("364","mram","01716596193","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e8810275","2025-10-30 17:21:12");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("365","mram","01897418939","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e8868040","2025-10-30 17:21:14");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("366","mram","01772039898","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e8a56d5a","2025-10-30 17:21:14");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("367","mram","01309726952","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e8aebb90","2025-10-30 17:21:15");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("368","mram","01304285704","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e8b4e282","2025-10-30 17:21:15");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("369","mram","01712095274","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e8ba5eba","2025-10-30 17:21:15");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("370","mram","01308652137","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e8c06ab4","2025-10-30 17:21:16");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("371","mram","01709259285","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e8d1d818","2025-10-30 17:21:17");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("372","mram","01720825990","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e8d73bae","2025-10-30 17:21:17");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("373","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e8e2275d","2025-10-30 17:21:18");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("374","mram","01739874783","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e8e79a31","2025-10-30 17:21:18");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("375","mram","01720648048","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e8ed423c","2025-10-30 17:21:19");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("376","mram","01779950102","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e8f781ea","2025-10-30 17:21:19");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("377","mram","01308652137","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e9019582","2025-10-30 17:21:20");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("378","mram","01324984372","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e911c8c2","2025-10-30 17:21:21");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("379","mram","01749926384","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e91b2ab2","2025-10-30 17:21:23");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("380","mram","01759828898","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e93b9d67","2025-10-30 17:21:23");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("381","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e941eb92","2025-10-30 17:21:24");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("382","mram","01308384045","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e94754cd","2025-10-30 17:21:24");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("383","mram","01723366165","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e94ce714","2025-10-30 17:21:25");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("384","mram","01309814905","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e9534f7e","2025-10-30 17:21:27");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("385","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল এর বার্ষিক পরীক্ষা ২০ নভেম্বর থেকে শুরু হবে ।  তাই ২০ নভেম্বর এর মধ্যে আপনার সন্তানের  মাসিক বেতন ডিসেম্বর পর্ষন্ত পরিশোধ  করার জন্য অনুরোধ করা হল । আপনার সন্তানকে নিয়মিত বিদ্যালয়ে পাঠান ।","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039e97a34f2","2025-10-30 17:21:27");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("386","mram","01727316073","Dear  abdullah ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252081","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169039f67aa186","2025-10-30 17:25:01");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("387","mram","01345835821","Dear  MD ABDUL ROHMAN ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252041","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169058242e527c","2025-11-01 03:45:07");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("388","mram","01727316073","Dear  Tanha ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252021","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169061c255734d","2025-11-01 14:41:41");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("389","mram","01727316073","এখানে কাষ্টম এসএমএস লিখতে পারবেনYour User ID: 79  Password : .798961","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169062b111dfd3","2025-11-01 15:45:21");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("390","mram","01727316073","সম্মানিত অভিভাবক  আপনার  পেমেন্ট   বার্ষিক পরীক্ষা ফি মাসের  গৃহীত হয়েছে: ২০০ টাকা,অপরিশোধিত পরিমাণ: ০ টাকা, ইনভয়েস আইডি: ৩৭ . শিক্ষার্থীর নাম: মুহাম্মদ হুজাইফা আল তামহিদ, শিক্ষার্থীর আইডি: ৩৮ , ইনভয়েস পরীক্ষা করুন: https://doubariidealpublicschool.top/sms/accounting/main-user/invoice.php?id=37 ওয়েব বাজার বিডি","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169070cdc35eca","2025-11-02 07:48:44");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("391","mram","01727316073","সম্মানিত অভিভাবক শিক্ষার্থীর নাম: HUJAIFA AL TAMHID, শিক্ষার্থীর আইডি: ৩৮ , অপরিশোধিত টাকা: ৭,২০০","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169070f12abfb5","2025-11-02 07:58:10");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("392","mram","01723337467","Dear  OYASIM AHSAN EVAN ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20251001","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169155593108d1","2025-11-13 03:50:43");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("393","mram","8801727316073","doubari ideal public school \nSAFAJANNAT TAHHIYA,Your username safa \nPassword 12345","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691a106fac7b9","2025-11-16 17:57:03");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("394","mram","01717452764","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18ab80054","2025-11-17 12:44:27");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("395","mram","01781582871","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18ac51721","2025-11-17 12:44:28");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("396","mram","01322191891","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18aca7441","2025-11-17 12:44:28");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("397","mram","01796806137","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18ad07c02","2025-11-17 12:44:29");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("398","mram","01875344468","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18ad5b34d","2025-11-17 12:44:29");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("399","mram","01715573708","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18adb151a","2025-11-17 12:44:29");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("400","mram","01741376329","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18ae81286","2025-11-17 12:44:30");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("401","mram","01330303600","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18aed37f6","2025-11-17 12:44:31");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("402","mram","01743954467","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18af33040","2025-11-17 12:44:31");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("403","mram","01784251274","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18af86f9c","2025-11-17 12:44:31");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("404","mram","01706611802","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18afd8b89","2025-11-17 12:44:32");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("405","mram","01712095274","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18b03782b","2025-11-17 12:44:32");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("406","mram","01723104395","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18b10d6f5","2025-11-17 12:44:33");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("407","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18b162d33","2025-11-17 12:44:33");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("408","mram","01760022641","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18b1b8ef3","2025-11-17 12:44:33");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("409","mram","01743920362","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18b219a10","2025-11-17 12:44:34");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("410","mram","01713804853","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18b26d3c3","2025-11-17 12:44:34");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("411","mram","01761736426","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18b2c0645","2025-11-17 12:44:34");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("412","mram","01759934840","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18b31f72b","2025-11-17 12:44:35");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("413","mram","01308461817","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18b372757","2025-11-17 12:44:35");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("414","mram","01759853317","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18b3c789d","2025-11-17 12:44:35");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("415","mram","01739874783","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18b43b2c9","2025-11-17 12:44:36");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("416","mram","01752506956","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18b506d81","2025-11-17 12:44:37");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("417","mram","01729240429","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18b5c92f9","2025-11-17 12:44:37");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("418","mram","01310906842","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18b62599c","2025-11-17 12:44:38");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("419","mram","01723925871","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18b679630","2025-11-17 12:44:38");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("420","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18b6c9a83","2025-11-17 12:44:38");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("421","mram","01709949517","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18b72d972","2025-11-17 12:44:39");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("422","mram","01309258948","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18b780cd5","2025-11-17 12:44:39");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("423","mram","01723337467","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18b7d48e5","2025-11-17 12:44:40");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("424","mram","01789518435","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18d137c72","2025-11-17 12:45:05");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("425","mram","01730951923","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18d18a953","2025-11-17 12:45:05");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("426","mram","01756057131","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18d1d8dc7","2025-11-17 12:45:06");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("427","mram","01771849796","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18d2387f1","2025-11-17 12:45:06");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("428","mram","01716596193","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18d2870d1","2025-11-17 12:45:06");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("429","mram","01897418939","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18d2d2278","2025-11-17 12:45:07");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("430","mram","01772039898","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18d33132b","2025-11-17 12:45:07");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("431","mram","01309726952","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18d38908f","2025-11-17 12:45:07");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("432","mram","01304285704","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b18d3dd0cf","2025-11-17 12:45:08");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("433","mram","01717452764","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b19136f442","2025-11-17 12:46:11");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("434","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1913c2803","2025-11-17 12:46:11");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("435","mram","01781582871","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191422d5f","2025-11-17 12:46:12");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("436","mram","01322191891","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191474a37","2025-11-17 12:46:12");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("437","mram","01796806137","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1914c5706","2025-11-17 12:46:12");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("438","mram","01875344468","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1915247bf","2025-11-17 12:46:13");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("439","mram","01715573708","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191577dd9","2025-11-17 12:46:13");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("440","mram","01741376329","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1915c8868","2025-11-17 12:46:13");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("441","mram","01330303600","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1916281ba","2025-11-17 12:46:14");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("442","mram","01743954467","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b19167ca97","2025-11-17 12:46:14");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("443","mram","01784251274","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1916ce423","2025-11-17 12:46:14");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("444","mram","01706611802","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1917302fb","2025-11-17 12:46:15");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("445","mram","01712095274","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191782d74","2025-11-17 12:46:15");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("446","mram","01723104395","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1917d9e00","2025-11-17 12:46:16");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("447","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1918ae959","2025-11-17 12:46:16");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("448","mram","01760022641","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b19191035f","2025-11-17 12:46:17");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("449","mram","01743920362","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191963aec","2025-11-17 12:46:17");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("450","mram","01713804853","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1919b7253","2025-11-17 12:46:17");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("451","mram","01761736426","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191a1481a","2025-11-17 12:46:18");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("452","mram","01759934840","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191a656e4","2025-11-17 12:46:18");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("453","mram","01308461817","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191ab9e13","2025-11-17 12:46:18");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("454","mram","01759853317","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191b1806f","2025-11-17 12:46:19");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("455","mram","01739874783","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191b69955","2025-11-17 12:46:19");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("456","mram","01752506956","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191bbc910","2025-11-17 12:46:19");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("457","mram","01729240429","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191c1974d","2025-11-17 12:46:20");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("458","mram","01310906842","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191c6436f","2025-11-17 12:46:20");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("459","mram","01723925871","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191cb4079","2025-11-17 12:46:20");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("460","mram","01304280920","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191d12a59","2025-11-17 12:46:21");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("461","mram","01715127807","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191d6561d","2025-11-17 12:46:21");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("462","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191de67f3","2025-11-17 12:46:22");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("463","mram","01709949517","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191e44d15","2025-11-17 12:46:22");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("464","mram","01309258948","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191e99003","2025-11-17 12:46:22");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("465","mram","01776382205","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191eebcfc","2025-11-17 12:46:23");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("466","mram","01777312455","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191f4ab5c","2025-11-17 12:46:23");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("467","mram","01756495492","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191f9c7d1","2025-11-17 12:46:23");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("468","mram","01734080229","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b191fee630","2025-11-17 12:46:24");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("469","mram","01711911237","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b19204e6cd","2025-11-17 12:46:24");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("470","mram","01789518435","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1920a121d","2025-11-17 12:46:24");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("471","mram","01730951923","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1921006ed","2025-11-17 12:46:25");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("472","mram","01756057131","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b192159ce4","2025-11-17 12:46:25");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("473","mram","01771849796","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1921a7e5a","2025-11-17 12:46:25");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("474","mram","01716596193","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b192206611","2025-11-17 12:46:26");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("475","mram","01897418939","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b19225a922","2025-11-17 12:46:26");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("476","mram","01772039898","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1922b06e8","2025-11-17 12:46:26");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("477","mram","01309726952","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b19230c474","2025-11-17 12:46:27");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("478","mram","01304285704","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b192361075","2025-11-17 12:46:27");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("479","mram","01712095274","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1923b4ca9","2025-11-17 12:46:27");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("480","mram","01308652137","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b192411544","2025-11-17 12:46:28");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("481","mram","01709259285","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1924683a2","2025-11-17 12:46:28");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("482","mram","01720825990","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1924b9c07","2025-11-17 12:46:28");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("483","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b19251921c","2025-11-17 12:46:29");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("484","mram","01739874783","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b19256e734","2025-11-17 12:46:29");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("485","mram","01720648048","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1925bfb94","2025-11-17 12:46:29");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("486","mram","01779950102","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b192620950","2025-11-17 12:46:30");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("487","mram","01308652137","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b192674d9d","2025-11-17 12:46:30");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("488","mram","01324984372","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1926c404b","2025-11-17 12:46:30");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("489","mram","01749926384","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b192725e3a","2025-11-17 12:46:31");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("490","mram","01759828898","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1927a1885","2025-11-17 12:46:31");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("491","mram","01308384045","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1928003ab","2025-11-17 12:46:32");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("492","mram","01723366165","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1928500c7","2025-11-17 12:46:32");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("493","mram","01309814905","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1928a479b","2025-11-17 12:46:32");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("494","mram","01727316073","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b192900c53","2025-11-17 12:46:33");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("495","mram","01345835821","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b192952c80","2025-11-17 12:46:33");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("496","mram","01723337467","ডৌবাড়ী আইডিয়াল পাবলিক স্কুল  এর বার্ষিক পরীক্ষা ২২ তারিখে শুরু হবে। তাই আপনার সন্তানের  মাসিক বেতন  ও পরিক্ষা  ফি পরিশোধ করা জন্য অনুরোধ করা হলো। ","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691b1929a452a","2025-11-17 12:46:33");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("497","mram","01733464120","Dear  NUSRAT JAHAN TASNIM ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252021","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe4d67e008","2025-11-21 04:04:38");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("498","mram","01310906842","Dear  MST RAHIMA BEGUM  ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20251001","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe4ef7c9c5","2025-11-21 04:05:03");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("499","mram","01304285704","Dear  SHRESTHA DAS ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252022","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe4fd9c5e4","2025-11-21 04:05:17");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("500","mram","01782596815","Dear  MD JUBAYER AHMED ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20251002","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe50b7c1a5","2025-11-21 04:05:31");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("501","mram","01739874783","Dear  MST AYSHA AKTER ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252023","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe51629acf","2025-11-21 04:05:42");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("502","mram","01309570114","Dear  SUMAIYA BEGUM ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20251003","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe52077924","2025-11-21 04:05:52");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("503","mram","01772939898","Dear  MD SHOWAIBUR RAHMAN ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252024","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe52e40b59","2025-11-21 04:06:06");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("504","mram","01759934840","Dear  MST MUNTAHA JANNAT MIM ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20251004","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe53887148","2025-11-21 04:06:16");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("505","mram","01760022641","Dear  MST TAHMINA JANNAT NISA ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20251005","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe54184649","2025-11-21 04:06:25");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("506","mram","01897418939","Dear  MD ANISUL HAQUE ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252025","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe54b200bb","2025-11-21 04:06:35");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("507","mram","01727316073","Dear  RIMA BEGUM  ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20251006","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe55466c7c","2025-11-21 04:06:44");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("508","mram","01716596193","Dear  ANSARUL ARIAN ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252026","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe55d5a1f8","2025-11-21 04:06:53");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("509","mram","01727316073","Dear  ISRAT JANNAT SUMANA ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20251007","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe566c6f92","2025-11-21 04:07:02");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("510","mram","01727316073","Dear  MD RUHAN AHMED ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252027","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe570cbcb9","2025-11-21 04:07:12");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("511","mram","01730951923","Dear  AIMAN SADI ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252028","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe579a6246","2025-11-21 04:07:21");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("512","mram","01741625149","Dear  NISHAT ANJUM TANISHA ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20251008","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe5833e4d4","2025-11-21 04:07:31");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("513","mram","01743920362","Dear  MD MASUD AHMED ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20251009","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe59092c81","2025-11-21 04:07:44");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("514","mram","01315933521","Dear  MST SABRINA AKTER ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252029","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe59a13fec","2025-11-21 04:07:54");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("515","mram","01727316073","Dear  ABDUR RAHMAN ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  202520210","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe5a27ec44","2025-11-21 04:08:02");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("516","mram","01756057131","Dear  ADIAN ALAMGIR ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  202520211","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe5abcbb62","2025-11-21 04:08:11");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("517","mram","01309126953","Dear  MUSTAKIM AHMED ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  202520212","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe5b3edfa2","2025-11-21 04:08:20");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("518","mram","01719428839","Dear  NAMIRA ISLAM  MAHNUR ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  202520213","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe5bdd655d","2025-11-21 04:08:30");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("519","mram","01759853317","Dear  FAIZA JANNAT NAZIHA ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  202510010","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe5c6102e0","2025-11-21 04:08:38");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("520","mram","01752506956","Dear  MAHBUBA JANNAT FATIMA ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  202510011","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe5d1def42","2025-11-21 04:08:50");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("521","mram","01713804853","Dear  MD MIZANUR RAHMAN  ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  202510012","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331691fe6315b765","2025-11-21 04:10:25");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("522","mram","01715127807","Dear  MAHIA AKTER ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252041","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169215df22778d","2025-11-22 06:53:38");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("523","mram","01777312455","Dear  MST FARHANA AKTER ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252042","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169215e0140127","2025-11-22 06:53:53");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("524","mram","017833504476","Dear  MINHAJUL ISLAM MAHIN ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252043","HTTP Error","200","2001","2025-11-22 06:54:03");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("525","mram","01776382205","Dear  MD JAMIL AHMAD ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252044","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169215e1a281f3","2025-11-22 06:54:18");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("526","mram","01727316073","Dear  SAFA JANNAT TAHHIYA ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252045","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169215e2560185","2025-11-22 06:54:29");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("527","mram","01743954467","Dear  SAKIB AHMED ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  202510013","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169215e2f5c971","2025-11-22 06:54:39");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("528","mram","01761736426","Dear  AFFAN MUAZ ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  202510014","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169215e3fecf0b","2025-11-22 06:54:56");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("529","mram","01727316073","Dear  NUSRAT JANNAT LIMA ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  202510015","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169215e47f17a9","2025-11-22 06:55:04");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("530","mram","01739874783","Dear  RABEYA JANNAT ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  202510016","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169215e52a0238","2025-11-22 06:55:14");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("531","mram","01723366165","Dear  SHAHANA SIDDIKA ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252051","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC30023316921732c68e8e","2025-11-22 08:24:12");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("532","mram","01727316073","Dear  JUBAWER AHMED ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252052","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331692173361527f","2025-11-22 08:24:22");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("533","mram","01308384045","Dear  MD ABU BOKOR TAWHID ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252053","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331692173400fbf0","2025-11-22 08:24:32");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("534","mram","01308652137","Dear  ASAD AHMED ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252054","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC300233169217347dd7bb","2025-11-22 08:24:40");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("535","mram","01766159740","Dear  ANISUR RAHMAN ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252055","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC30023316921735206059","2025-11-22 08:24:50");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("536","mram","01721237841","Dear  ARAFATH RAHMAN PUSPO ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252056","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC30023316921735a6c068","2025-11-22 08:24:58");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_message`, `http_code`, `api_response`, `created_at`) VALUES("537","mram","01725542026","Dear  AFWAN AHMED ,
\nCongratulations! Your admission to Doubari Ideal Public School  has been successfully completed.  Your ID:  20252057","HTTP Error","200","SMS SUBMITTED: ID - bw-rdC3002331692173637c193","2025-11-22 08:25:07");
INSERT INTO `sms_error_log` (`id`, `provider`, `mobile`, `message`, `error_mes